/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.task.executor.worker;

import java.util.List;
import java.util.Optional;
import java.util.concurrent.atomic.LongAdder;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.apache.dolphinscheduler.task.executor.worker.TaskExecutorWorker;

public class TaskExecutorWorkers {
    private final List<TaskExecutorWorker> taskExecutorWorkers;
    private final LongAdder longAdder = new LongAdder();

    public TaskExecutorWorkers(int workerSize) {
        this.taskExecutorWorkers = IntStream.range(0, workerSize).mapToObj(TaskExecutorWorker::new).collect(Collectors.toList());
    }

    public List<TaskExecutorWorker> getWorkers() {
        return this.taskExecutorWorkers;
    }

    public TaskExecutorWorker getWorkerById(int workerId) {
        return this.taskExecutorWorkers.get(workerId);
    }

    public TaskExecutorWorker roundRobinSelectWorker() {
        int workerIndex = (int)(this.longAdder.longValue() % (long)this.taskExecutorWorkers.size());
        this.longAdder.increment();
        return this.taskExecutorWorkers.get(workerIndex);
    }

    public Optional<TaskExecutorWorker> selectIdleWorker() {
        for (TaskExecutorWorker taskExecutorWorker : this.taskExecutorWorkers) {
            if (taskExecutorWorker.getRegisteredTaskExecutorSize() != 0) continue;
            return Optional.of(taskExecutorWorker);
        }
        return Optional.empty();
    }
}

