/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.common.enums;

import com.baomidou.mybatisplus.annotation.EnumValue;
import java.util.HashMap;

public enum TaskGroupQueueStatus {
    WAIT_QUEUE(-1, "wait queue"),
    ACQUIRE_SUCCESS(1, "acquire success"),
    RELEASE(2, "release");

    @EnumValue
    private final int code;
    private final String descp;
    private static HashMap<Integer, TaskGroupQueueStatus> STATUS_MAP;

    private TaskGroupQueueStatus(int code, String descp) {
        this.code = code;
        this.descp = descp;
    }

    public static TaskGroupQueueStatus of(int status) {
        if (STATUS_MAP.containsKey(status)) {
            return STATUS_MAP.get(status);
        }
        throw new IllegalArgumentException("invalid status : " + status);
    }

    public int getCode() {
        return this.code;
    }

    public String getDescp() {
        return this.descp;
    }

    static {
        STATUS_MAP = new HashMap();
        for (TaskGroupQueueStatus taskGroupQueueStatus : TaskGroupQueueStatus.values()) {
            STATUS_MAP.put(taskGroupQueueStatus.code, taskGroupQueueStatus);
        }
    }
}

