/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.openapi.models;

import com.google.gson.annotations.SerializedName;
import io.kubernetes.client.openapi.models.FlowcontrolV1beta1Subject;
import io.kubernetes.client.openapi.models.V1beta1NonResourcePolicyRule;
import io.kubernetes.client.openapi.models.V1beta1ResourcePolicyRule;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="PolicyRulesWithSubjects prescribes a test that applies to a request to an apiserver. The test considers the subject making the request, the verb being requested, and the resource to be acted upon. This PolicyRulesWithSubjects matches a request if and only if both (a) at least one member of subjects matches the request and (b) at least one member of resourceRules or nonResourceRules matches the request.")
public class V1beta1PolicyRulesWithSubjects {
    public static final String SERIALIZED_NAME_NON_RESOURCE_RULES = "nonResourceRules";
    @SerializedName(value="nonResourceRules")
    private List<V1beta1NonResourcePolicyRule> nonResourceRules = null;
    public static final String SERIALIZED_NAME_RESOURCE_RULES = "resourceRules";
    @SerializedName(value="resourceRules")
    private List<V1beta1ResourcePolicyRule> resourceRules = null;
    public static final String SERIALIZED_NAME_SUBJECTS = "subjects";
    @SerializedName(value="subjects")
    private List<FlowcontrolV1beta1Subject> subjects = new ArrayList<FlowcontrolV1beta1Subject>();

    public V1beta1PolicyRulesWithSubjects nonResourceRules(List<V1beta1NonResourcePolicyRule> nonResourceRules) {
        this.nonResourceRules = nonResourceRules;
        return this;
    }

    public V1beta1PolicyRulesWithSubjects addNonResourceRulesItem(V1beta1NonResourcePolicyRule nonResourceRulesItem) {
        if (this.nonResourceRules == null) {
            this.nonResourceRules = new ArrayList<V1beta1NonResourcePolicyRule>();
        }
        this.nonResourceRules.add(nonResourceRulesItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="`nonResourceRules` is a list of NonResourcePolicyRules that identify matching requests according to their verb and the target non-resource URL.")
    public List<V1beta1NonResourcePolicyRule> getNonResourceRules() {
        return this.nonResourceRules;
    }

    public void setNonResourceRules(List<V1beta1NonResourcePolicyRule> nonResourceRules) {
        this.nonResourceRules = nonResourceRules;
    }

    public V1beta1PolicyRulesWithSubjects resourceRules(List<V1beta1ResourcePolicyRule> resourceRules) {
        this.resourceRules = resourceRules;
        return this;
    }

    public V1beta1PolicyRulesWithSubjects addResourceRulesItem(V1beta1ResourcePolicyRule resourceRulesItem) {
        if (this.resourceRules == null) {
            this.resourceRules = new ArrayList<V1beta1ResourcePolicyRule>();
        }
        this.resourceRules.add(resourceRulesItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="`resourceRules` is a slice of ResourcePolicyRules that identify matching requests according to their verb and the target resource. At least one of `resourceRules` and `nonResourceRules` has to be non-empty.")
    public List<V1beta1ResourcePolicyRule> getResourceRules() {
        return this.resourceRules;
    }

    public void setResourceRules(List<V1beta1ResourcePolicyRule> resourceRules) {
        this.resourceRules = resourceRules;
    }

    public V1beta1PolicyRulesWithSubjects subjects(List<FlowcontrolV1beta1Subject> subjects) {
        this.subjects = subjects;
        return this;
    }

    public V1beta1PolicyRulesWithSubjects addSubjectsItem(FlowcontrolV1beta1Subject subjectsItem) {
        this.subjects.add(subjectsItem);
        return this;
    }

    @ApiModelProperty(required=true, value="subjects is the list of normal user, serviceaccount, or group that this rule cares about. There must be at least one member in this slice. A slice that includes both the system:authenticated and system:unauthenticated user groups matches every request. Required.")
    public List<FlowcontrolV1beta1Subject> getSubjects() {
        return this.subjects;
    }

    public void setSubjects(List<FlowcontrolV1beta1Subject> subjects) {
        this.subjects = subjects;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        V1beta1PolicyRulesWithSubjects v1beta1PolicyRulesWithSubjects = (V1beta1PolicyRulesWithSubjects)o;
        return Objects.equals(this.nonResourceRules, v1beta1PolicyRulesWithSubjects.nonResourceRules) && Objects.equals(this.resourceRules, v1beta1PolicyRulesWithSubjects.resourceRules) && Objects.equals(this.subjects, v1beta1PolicyRulesWithSubjects.subjects);
    }

    public int hashCode() {
        return Objects.hash(this.nonResourceRules, this.resourceRules, this.subjects);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class V1beta1PolicyRulesWithSubjects {\n");
        sb.append("    nonResourceRules: ").append(this.toIndentedString(this.nonResourceRules)).append("\n");
        sb.append("    resourceRules: ").append(this.toIndentedString(this.resourceRules)).append("\n");
        sb.append("    subjects: ").append(this.toIndentedString(this.subjects)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

