/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.extended.network;

import io.kubernetes.client.extended.network.LoadBalanceStrategy;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;

public class RoundRobinLoadBalanceStrategy
implements LoadBalanceStrategy {
    private final AtomicInteger robinIndex = new AtomicInteger(0);

    @Override
    public String chooseIP(List<String> availableIPs) {
        if (availableIPs == null || availableIPs.size() == 0) {
            throw new IllegalArgumentException("failed choosing IP target: empty candidates");
        }
        int len = availableIPs.size();
        int idx = this.robinIndex.getAndIncrement() % len;
        return availableIPs.get(idx);
    }
}

