/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.server.worker.executor;

import java.util.Optional;
import lombok.Generated;
import org.apache.dolphinscheduler.plugin.task.api.TaskExecutionContext;
import org.apache.dolphinscheduler.server.worker.executor.PhysicalTaskEngineFactory;
import org.apache.dolphinscheduler.server.worker.executor.PhysicalTaskExecutorFactory;
import org.apache.dolphinscheduler.server.worker.executor.PhysicalTaskExecutorLifecycleEventReporter;
import org.apache.dolphinscheduler.server.worker.executor.PhysicalTaskExecutorRepository;
import org.apache.dolphinscheduler.task.executor.ITaskExecutor;
import org.apache.dolphinscheduler.task.executor.TaskEngine;
import org.apache.dolphinscheduler.task.executor.eventbus.ITaskExecutorLifecycleEventReporter;
import org.apache.dolphinscheduler.task.executor.operations.TaskExecutorReassignMasterRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class PhysicalTaskEngineDelegator
implements AutoCloseable {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(PhysicalTaskEngineDelegator.class);
    private final TaskEngine taskEngine;
    private final PhysicalTaskExecutorFactory physicalTaskExecutorFactory;
    private final PhysicalTaskExecutorLifecycleEventReporter physicalTaskExecutorEventReporter;
    private final PhysicalTaskExecutorRepository physicalTaskExecutorRepository;

    public PhysicalTaskEngineDelegator(PhysicalTaskEngineFactory physicalTaskEngineFactory, PhysicalTaskExecutorFactory physicalTaskExecutorFactory, PhysicalTaskExecutorRepository physicalTaskExecutorRepository, PhysicalTaskExecutorLifecycleEventReporter physicalTaskExecutorEventReporter) {
        this.physicalTaskExecutorFactory = physicalTaskExecutorFactory;
        this.taskEngine = physicalTaskEngineFactory.createTaskEngine();
        this.physicalTaskExecutorRepository = physicalTaskExecutorRepository;
        this.physicalTaskExecutorEventReporter = physicalTaskExecutorEventReporter;
    }

    public void start() {
        this.taskEngine.start();
        this.physicalTaskExecutorEventReporter.start();
        log.info("PhysicalTaskEngineDelegator started");
    }

    public void dispatchLogicTask(TaskExecutionContext taskExecutionContext) {
        ITaskExecutor taskExecutor = this.physicalTaskExecutorFactory.createTaskExecutor(taskExecutionContext);
        this.taskEngine.submitTask(taskExecutor);
    }

    public void killLogicTask(int taskInstanceId) {
        this.taskEngine.killTask(taskInstanceId);
    }

    public void pauseLogicTask(int taskInstanceId) {
        this.taskEngine.pauseTask(taskInstanceId);
    }

    public void ackPhysicalTaskExecutorLifecycleEventACK(ITaskExecutorLifecycleEventReporter.TaskExecutorLifecycleEventAck taskExecutorLifecycleEventAck) {
        this.physicalTaskExecutorEventReporter.receiveTaskExecutorLifecycleEventACK(taskExecutorLifecycleEventAck);
    }

    public boolean reassignWorkflowInstanceHost(TaskExecutorReassignMasterRequest taskExecutorReassignMasterRequest) {
        int taskInstanceId = taskExecutorReassignMasterRequest.getTaskInstanceId();
        String workflowHost = taskExecutorReassignMasterRequest.getWorkflowHost();
        Optional taskExecutorOptional = this.physicalTaskExecutorRepository.get(taskInstanceId);
        if (taskExecutorOptional.isPresent()) {
            ((ITaskExecutor)taskExecutorOptional.get()).getTaskExecutionContext().setWorkflowInstanceHost(workflowHost);
            this.physicalTaskExecutorEventReporter.onWorkflowInstanceHostChanged(taskInstanceId);
            return true;
        }
        return false;
    }

    @Override
    public void close() {
        this.taskEngine.close();
    }
}

