/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.appservice.implementation;

import com.azure.core.management.Resource;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.appservice.AppServiceManager;
import com.azure.resourcemanager.appservice.fluent.WebSiteManagementClient;
import com.azure.resourcemanager.appservice.fluent.models.AppServicePlanInner;
import com.azure.resourcemanager.appservice.models.AppServicePlan;
import com.azure.resourcemanager.appservice.models.OperatingSystem;
import com.azure.resourcemanager.appservice.models.PricingTier;
import com.azure.resourcemanager.resources.fluentcore.arm.Manager;
import com.azure.resourcemanager.resources.fluentcore.arm.models.implementation.GroupableResourceImpl;
import com.azure.resourcemanager.resources.fluentcore.model.implementation.IndexableRefreshableWrapperImpl;
import com.azure.resourcemanager.resources.fluentcore.utils.ResourceManagerUtils;
import reactor.core.publisher.Mono;

class AppServicePlanImpl
extends GroupableResourceImpl<AppServicePlan, AppServicePlanInner, AppServicePlanImpl, AppServiceManager>
implements AppServicePlan,
AppServicePlan.Definition,
AppServicePlan.Update {
    private final ClientLogger logger = new ClientLogger(this.getClass());

    AppServicePlanImpl(String name, AppServicePlanInner innerObject, AppServiceManager manager) {
        super(name, (Resource)innerObject, (Manager)manager);
    }

    public Mono<AppServicePlan> createResourceAsync() {
        return ((WebSiteManagementClient)((AppServiceManager)this.manager()).serviceClient()).getAppServicePlans().createOrUpdateAsync(this.resourceGroupName(), this.name(), (AppServicePlanInner)((Object)this.innerModel())).map(this.innerToFluentMap((IndexableRefreshableWrapperImpl)this));
    }

    protected Mono<AppServicePlanInner> getInnerAsync() {
        return ((WebSiteManagementClient)((AppServiceManager)this.manager()).serviceClient()).getAppServicePlans().getByResourceGroupAsync(this.resourceGroupName(), this.name());
    }

    @Override
    public int maxInstances() {
        return ResourceManagerUtils.toPrimitiveInt((Integer)((AppServicePlanInner)((Object)this.innerModel())).maximumNumberOfWorkers());
    }

    @Override
    public int capacity() {
        return ResourceManagerUtils.toPrimitiveInt((Integer)((AppServicePlanInner)((Object)this.innerModel())).sku().capacity());
    }

    @Override
    public boolean perSiteScaling() {
        return ((AppServicePlanInner)((Object)this.innerModel())).perSiteScaling();
    }

    @Override
    public int numberOfWebApps() {
        return ResourceManagerUtils.toPrimitiveInt((Integer)((AppServicePlanInner)((Object)this.innerModel())).numberOfSites());
    }

    @Override
    public PricingTier pricingTier() {
        return PricingTier.fromSkuDescription(((AppServicePlanInner)((Object)this.innerModel())).sku());
    }

    @Override
    public OperatingSystem operatingSystem() {
        return ((AppServicePlanInner)((Object)this.innerModel())).reserved() == null || ((AppServicePlanInner)((Object)this.innerModel())).reserved() == false ? OperatingSystem.WINDOWS : OperatingSystem.LINUX;
    }

    @Override
    public AppServicePlanImpl withFreePricingTier() {
        return this.withPricingTier(PricingTier.FREE_F1);
    }

    @Override
    public AppServicePlanImpl withSharedPricingTier() {
        return this.withPricingTier(PricingTier.SHARED_D1);
    }

    @Override
    public AppServicePlanImpl withPricingTier(PricingTier pricingTier) {
        if (pricingTier == null) {
            throw this.logger.logExceptionAsError((RuntimeException)new IllegalArgumentException("pricingTier == null"));
        }
        ((AppServicePlanInner)((Object)this.innerModel())).withSku(pricingTier.toSkuDescription());
        return this;
    }

    @Override
    public AppServicePlanImpl withPerSiteScaling(boolean perSiteScaling) {
        ((AppServicePlanInner)((Object)this.innerModel())).withPerSiteScaling(perSiteScaling);
        return this;
    }

    @Override
    public AppServicePlanImpl withCapacity(int capacity) {
        if (capacity < 1) {
            throw this.logger.logExceptionAsError((RuntimeException)new IllegalArgumentException("Capacity is at least 1."));
        }
        ((AppServicePlanInner)((Object)this.innerModel())).sku().withCapacity(capacity);
        return this;
    }

    @Override
    public AppServicePlanImpl withOperatingSystem(OperatingSystem operatingSystem) {
        if (OperatingSystem.LINUX.equals((Object)operatingSystem)) {
            ((AppServicePlanInner)((Object)this.innerModel())).withReserved(true);
            ((AppServicePlanInner)((Object)this.innerModel())).withKind("linux");
        } else {
            ((AppServicePlanInner)((Object)this.innerModel())).withKind("app");
        }
        return this;
    }
}

