/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.appservice.models;

import com.azure.core.http.HttpPipelineCallContext;
import com.azure.core.http.HttpPipelineNextPolicy;
import com.azure.core.http.HttpResponse;
import com.azure.core.http.policy.HttpPipelinePolicy;
import com.azure.resourcemanager.appservice.models.WebAppBase;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import reactor.core.publisher.Mono;

public final class KuduAuthenticationPolicy
implements HttpPipelinePolicy {
    private final WebAppBase webApp;
    private static final String HEADER_NAME = "Authorization";
    private String basicToken;

    public KuduAuthenticationPolicy(WebAppBase webApp) {
        this.webApp = webApp;
    }

    public Mono<HttpResponse> process(HttpPipelineCallContext context, HttpPipelineNextPolicy next) {
        Mono basicTokenMono = this.basicToken == null ? this.webApp.getPublishingProfileAsync().map(profile -> {
            this.basicToken = Base64.getEncoder().encodeToString((profile.gitUsername() + ":" + profile.gitPassword()).getBytes(StandardCharsets.UTF_8));
            return this.basicToken;
        }) : Mono.just((Object)this.basicToken);
        return basicTokenMono.flatMap(key -> {
            context.getHttpRequest().setHeader(HEADER_NAME, "Basic " + this.basicToken);
            return next.process();
        });
    }
}

