/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.datafactory.implementation;

import com.azure.core.util.Context;
import com.azure.resourcemanager.datafactory.DataFactoryManager;
import com.azure.resourcemanager.datafactory.fluent.models.ManagedIdentityCredentialResourceInner;
import com.azure.resourcemanager.datafactory.implementation.Utils;
import com.azure.resourcemanager.datafactory.models.ManagedIdentityCredential;
import com.azure.resourcemanager.datafactory.models.ManagedIdentityCredentialResource;

public final class ManagedIdentityCredentialResourceImpl
implements ManagedIdentityCredentialResource,
ManagedIdentityCredentialResource.Definition,
ManagedIdentityCredentialResource.Update {
    private ManagedIdentityCredentialResourceInner innerObject;
    private final DataFactoryManager serviceManager;
    private String resourceGroupName;
    private String factoryName;
    private String credentialName;
    private String createIfMatch;
    private String updateIfMatch;

    @Override
    public String id() {
        return this.innerModel().id();
    }

    @Override
    public ManagedIdentityCredential properties() {
        return this.innerModel().properties();
    }

    @Override
    public String name() {
        return this.innerModel().name();
    }

    @Override
    public String type() {
        return this.innerModel().type();
    }

    @Override
    public String etag() {
        return this.innerModel().etag();
    }

    @Override
    public String resourceGroupName() {
        return this.resourceGroupName;
    }

    @Override
    public ManagedIdentityCredentialResourceInner innerModel() {
        return this.innerObject;
    }

    private DataFactoryManager manager() {
        return this.serviceManager;
    }

    @Override
    public ManagedIdentityCredentialResourceImpl withExistingFactory(String resourceGroupName, String factoryName) {
        this.resourceGroupName = resourceGroupName;
        this.factoryName = factoryName;
        return this;
    }

    @Override
    public ManagedIdentityCredentialResource create() {
        this.innerObject = (ManagedIdentityCredentialResourceInner)((Object)this.serviceManager.serviceClient().getCredentialOperations().createOrUpdateWithResponse(this.resourceGroupName, this.factoryName, this.credentialName, this.innerModel(), this.createIfMatch, Context.NONE).getValue());
        return this;
    }

    @Override
    public ManagedIdentityCredentialResource create(Context context) {
        this.innerObject = (ManagedIdentityCredentialResourceInner)((Object)this.serviceManager.serviceClient().getCredentialOperations().createOrUpdateWithResponse(this.resourceGroupName, this.factoryName, this.credentialName, this.innerModel(), this.createIfMatch, context).getValue());
        return this;
    }

    ManagedIdentityCredentialResourceImpl(String name, DataFactoryManager serviceManager) {
        this.innerObject = new ManagedIdentityCredentialResourceInner();
        this.serviceManager = serviceManager;
        this.credentialName = name;
        this.createIfMatch = null;
    }

    @Override
    public ManagedIdentityCredentialResourceImpl update() {
        this.updateIfMatch = null;
        return this;
    }

    @Override
    public ManagedIdentityCredentialResource apply() {
        this.innerObject = (ManagedIdentityCredentialResourceInner)((Object)this.serviceManager.serviceClient().getCredentialOperations().createOrUpdateWithResponse(this.resourceGroupName, this.factoryName, this.credentialName, this.innerModel(), this.updateIfMatch, Context.NONE).getValue());
        return this;
    }

    @Override
    public ManagedIdentityCredentialResource apply(Context context) {
        this.innerObject = (ManagedIdentityCredentialResourceInner)((Object)this.serviceManager.serviceClient().getCredentialOperations().createOrUpdateWithResponse(this.resourceGroupName, this.factoryName, this.credentialName, this.innerModel(), this.updateIfMatch, context).getValue());
        return this;
    }

    ManagedIdentityCredentialResourceImpl(ManagedIdentityCredentialResourceInner innerObject, DataFactoryManager serviceManager) {
        this.innerObject = innerObject;
        this.serviceManager = serviceManager;
        this.resourceGroupName = Utils.getValueFromIdByName(innerObject.id(), "resourceGroups");
        this.factoryName = Utils.getValueFromIdByName(innerObject.id(), "factories");
        this.credentialName = Utils.getValueFromIdByName(innerObject.id(), "credentials");
    }

    @Override
    public ManagedIdentityCredentialResource refresh() {
        String localIfNoneMatch = null;
        this.innerObject = (ManagedIdentityCredentialResourceInner)((Object)this.serviceManager.serviceClient().getCredentialOperations().getWithResponse(this.resourceGroupName, this.factoryName, this.credentialName, localIfNoneMatch, Context.NONE).getValue());
        return this;
    }

    @Override
    public ManagedIdentityCredentialResource refresh(Context context) {
        String localIfNoneMatch = null;
        this.innerObject = (ManagedIdentityCredentialResourceInner)((Object)this.serviceManager.serviceClient().getCredentialOperations().getWithResponse(this.resourceGroupName, this.factoryName, this.credentialName, localIfNoneMatch, context).getValue());
        return this;
    }

    @Override
    public ManagedIdentityCredentialResourceImpl withProperties(ManagedIdentityCredential properties) {
        this.innerModel().withProperties(properties);
        return this;
    }

    @Override
    public ManagedIdentityCredentialResourceImpl withIfMatch(String ifMatch) {
        if (this.isInCreateMode()) {
            this.createIfMatch = ifMatch;
            return this;
        }
        this.updateIfMatch = ifMatch;
        return this;
    }

    private boolean isInCreateMode() {
        return this.innerModel().id() == null;
    }
}

