/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.datafactory.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.datafactory.fluent.models.CouchbaseLinkedServiceTypeProperties;
import com.azure.resourcemanager.datafactory.models.AzureKeyVaultSecretReference;
import com.azure.resourcemanager.datafactory.models.IntegrationRuntimeReference;
import com.azure.resourcemanager.datafactory.models.LinkedService;
import com.azure.resourcemanager.datafactory.models.ParameterSpecification;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.annotation.JsonTypeName;
import java.util.List;
import java.util.Map;

@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY, property="type")
@JsonTypeName(value="Couchbase")
public final class CouchbaseLinkedService
extends LinkedService {
    @JsonProperty(value="typeProperties", required=true)
    private CouchbaseLinkedServiceTypeProperties innerTypeProperties = new CouchbaseLinkedServiceTypeProperties();
    private static final ClientLogger LOGGER = new ClientLogger(CouchbaseLinkedService.class);

    private CouchbaseLinkedServiceTypeProperties innerTypeProperties() {
        return this.innerTypeProperties;
    }

    @Override
    public CouchbaseLinkedService withConnectVia(IntegrationRuntimeReference connectVia) {
        super.withConnectVia(connectVia);
        return this;
    }

    @Override
    public CouchbaseLinkedService withDescription(String description) {
        super.withDescription(description);
        return this;
    }

    @Override
    public CouchbaseLinkedService withParameters(Map<String, ParameterSpecification> parameters) {
        super.withParameters(parameters);
        return this;
    }

    @Override
    public CouchbaseLinkedService withAnnotations(List<Object> annotations) {
        super.withAnnotations(annotations);
        return this;
    }

    public Object connectionString() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().connectionString();
    }

    public CouchbaseLinkedService withConnectionString(Object connectionString) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new CouchbaseLinkedServiceTypeProperties();
        }
        this.innerTypeProperties().withConnectionString(connectionString);
        return this;
    }

    public AzureKeyVaultSecretReference credString() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().credString();
    }

    public CouchbaseLinkedService withCredString(AzureKeyVaultSecretReference credString) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new CouchbaseLinkedServiceTypeProperties();
        }
        this.innerTypeProperties().withCredString(credString);
        return this;
    }

    public Object encryptedCredential() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().encryptedCredential();
    }

    public CouchbaseLinkedService withEncryptedCredential(Object encryptedCredential) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new CouchbaseLinkedServiceTypeProperties();
        }
        this.innerTypeProperties().withEncryptedCredential(encryptedCredential);
        return this;
    }

    @Override
    public void validate() {
        super.validate();
        if (this.innerTypeProperties() == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException("Missing required property innerTypeProperties in model CouchbaseLinkedService"));
        }
        this.innerTypeProperties().validate();
    }
}

