/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.datafactory.models;

import com.azure.core.http.rest.Response;
import com.azure.core.util.Context;
import com.azure.resourcemanager.datafactory.fluent.models.PipelineResourceInner;
import com.azure.resourcemanager.datafactory.models.Activity;
import com.azure.resourcemanager.datafactory.models.CreateRunResponse;
import com.azure.resourcemanager.datafactory.models.ParameterSpecification;
import com.azure.resourcemanager.datafactory.models.PipelineFolder;
import com.azure.resourcemanager.datafactory.models.PipelinePolicy;
import com.azure.resourcemanager.datafactory.models.VariableSpecification;
import java.util.List;
import java.util.Map;

public interface PipelineResource {
    public String id();

    public String name();

    public String type();

    public String etag();

    public Map<String, Object> additionalProperties();

    public String description();

    public List<Activity> activities();

    public Map<String, ParameterSpecification> parameters();

    public Map<String, VariableSpecification> variables();

    public Integer concurrency();

    public List<Object> annotations();

    public Map<String, Object> runDimensions();

    public PipelineFolder folder();

    public PipelinePolicy policy();

    public String resourceGroupName();

    public PipelineResourceInner innerModel();

    public Update update();

    public PipelineResource refresh();

    public PipelineResource refresh(Context var1);

    public Response<CreateRunResponse> createRunWithResponse(String var1, Boolean var2, String var3, Boolean var4, Map<String, Object> var5, Context var6);

    public CreateRunResponse createRun();

    public static interface UpdateStages {

        public static interface WithIfMatch {
            public Update withIfMatch(String var1);
        }

        public static interface WithPolicy {
            public Update withPolicy(PipelinePolicy var1);
        }

        public static interface WithFolder {
            public Update withFolder(PipelineFolder var1);
        }

        public static interface WithRunDimensions {
            public Update withRunDimensions(Map<String, Object> var1);
        }

        public static interface WithAnnotations {
            public Update withAnnotations(List<Object> var1);
        }

        public static interface WithConcurrency {
            public Update withConcurrency(Integer var1);
        }

        public static interface WithVariables {
            public Update withVariables(Map<String, VariableSpecification> var1);
        }

        public static interface WithParameters {
            public Update withParameters(Map<String, ParameterSpecification> var1);
        }

        public static interface WithActivities {
            public Update withActivities(List<Activity> var1);
        }

        public static interface WithDescription {
            public Update withDescription(String var1);
        }

        public static interface WithAdditionalProperties {
            public Update withAdditionalProperties(Map<String, Object> var1);
        }
    }

    public static interface Update
    extends UpdateStages.WithAdditionalProperties,
    UpdateStages.WithDescription,
    UpdateStages.WithActivities,
    UpdateStages.WithParameters,
    UpdateStages.WithVariables,
    UpdateStages.WithConcurrency,
    UpdateStages.WithAnnotations,
    UpdateStages.WithRunDimensions,
    UpdateStages.WithFolder,
    UpdateStages.WithPolicy,
    UpdateStages.WithIfMatch {
        public PipelineResource apply();

        public PipelineResource apply(Context var1);
    }

    public static interface DefinitionStages {

        public static interface WithIfMatch {
            public WithCreate withIfMatch(String var1);
        }

        public static interface WithPolicy {
            public WithCreate withPolicy(PipelinePolicy var1);
        }

        public static interface WithFolder {
            public WithCreate withFolder(PipelineFolder var1);
        }

        public static interface WithRunDimensions {
            public WithCreate withRunDimensions(Map<String, Object> var1);
        }

        public static interface WithAnnotations {
            public WithCreate withAnnotations(List<Object> var1);
        }

        public static interface WithConcurrency {
            public WithCreate withConcurrency(Integer var1);
        }

        public static interface WithVariables {
            public WithCreate withVariables(Map<String, VariableSpecification> var1);
        }

        public static interface WithParameters {
            public WithCreate withParameters(Map<String, ParameterSpecification> var1);
        }

        public static interface WithActivities {
            public WithCreate withActivities(List<Activity> var1);
        }

        public static interface WithDescription {
            public WithCreate withDescription(String var1);
        }

        public static interface WithAdditionalProperties {
            public WithCreate withAdditionalProperties(Map<String, Object> var1);
        }

        public static interface WithCreate
        extends WithAdditionalProperties,
        WithDescription,
        WithActivities,
        WithParameters,
        WithVariables,
        WithConcurrency,
        WithAnnotations,
        WithRunDimensions,
        WithFolder,
        WithPolicy,
        WithIfMatch {
            public PipelineResource create();

            public PipelineResource create(Context var1);
        }

        public static interface WithParentResource {
            public WithCreate withExistingFactory(String var1, String var2);
        }

        public static interface Blank
        extends WithParentResource {
        }
    }

    public static interface Definition
    extends DefinitionStages.Blank,
    DefinitionStages.WithParentResource,
    DefinitionStages.WithCreate {
    }
}

