/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.datafactory.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.datafactory.models.SecretBase;
import com.azure.resourcemanager.datafactory.models.WebLinkedServiceTypeProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.annotation.JsonTypeName;

@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY, property="authenticationType")
@JsonTypeName(value="ClientCertificate")
public final class WebClientCertificateAuthentication
extends WebLinkedServiceTypeProperties {
    @JsonProperty(value="pfx", required=true)
    private SecretBase pfx;
    @JsonProperty(value="password", required=true)
    private SecretBase password;
    private static final ClientLogger LOGGER = new ClientLogger(WebClientCertificateAuthentication.class);

    public SecretBase pfx() {
        return this.pfx;
    }

    public WebClientCertificateAuthentication withPfx(SecretBase pfx) {
        this.pfx = pfx;
        return this;
    }

    public SecretBase password() {
        return this.password;
    }

    public WebClientCertificateAuthentication withPassword(SecretBase password) {
        this.password = password;
        return this;
    }

    @Override
    public WebClientCertificateAuthentication withUrl(Object url) {
        super.withUrl(url);
        return this;
    }

    @Override
    public void validate() {
        super.validate();
        if (this.pfx() == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException("Missing required property pfx in model WebClientCertificateAuthentication"));
        }
        this.pfx().validate();
        if (this.password() == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException("Missing required property password in model WebClientCertificateAuthentication"));
        }
        this.password().validate();
    }
}

