/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.dns.implementation;

import com.azure.core.annotation.BodyParam;
import com.azure.core.annotation.ExpectedResponses;
import com.azure.core.annotation.HeaderParam;
import com.azure.core.annotation.Headers;
import com.azure.core.annotation.Host;
import com.azure.core.annotation.HostParam;
import com.azure.core.annotation.PathParam;
import com.azure.core.annotation.Post;
import com.azure.core.annotation.QueryParam;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceInterface;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.RestProxy;
import com.azure.core.management.exception.ManagementException;
import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.logging.ClientLogger;
import com.azure.core.util.serializer.SerializerAdapter;
import com.azure.resourcemanager.dns.fluent.DnsResourceReferencesClient;
import com.azure.resourcemanager.dns.fluent.models.DnsResourceReferenceResultInner;
import com.azure.resourcemanager.dns.implementation.DnsManagementClientImpl;
import com.azure.resourcemanager.dns.models.DnsResourceReferenceRequest;
import reactor.core.publisher.Mono;

public final class DnsResourceReferencesClientImpl
implements DnsResourceReferencesClient {
    private final ClientLogger logger = new ClientLogger(DnsResourceReferencesClientImpl.class);
    private final DnsResourceReferencesService service;
    private final DnsManagementClientImpl client;

    DnsResourceReferencesClientImpl(DnsManagementClientImpl client) {
        this.service = (DnsResourceReferencesService)RestProxy.create(DnsResourceReferencesService.class, (HttpPipeline)client.getHttpPipeline(), (SerializerAdapter)client.getSerializerAdapter());
        this.client = client;
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<DnsResourceReferenceResultInner>> getByTargetResourcesWithResponseAsync(DnsResourceReferenceRequest parameters) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (parameters == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter parameters is required and cannot be null."));
        }
        parameters.validate();
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.getByTargetResources(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), parameters, "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<DnsResourceReferenceResultInner>> getByTargetResourcesWithResponseAsync(DnsResourceReferenceRequest parameters, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (parameters == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter parameters is required and cannot be null."));
        }
        parameters.validate();
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.getByTargetResources(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), parameters, "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<DnsResourceReferenceResultInner> getByTargetResourcesAsync(DnsResourceReferenceRequest parameters) {
        return this.getByTargetResourcesWithResponseAsync(parameters).flatMap(res -> {
            if (res.getValue() != null) {
                return Mono.just((Object)((DnsResourceReferenceResultInner)res.getValue()));
            }
            return Mono.empty();
        });
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public DnsResourceReferenceResultInner getByTargetResources(DnsResourceReferenceRequest parameters) {
        return (DnsResourceReferenceResultInner)this.getByTargetResourcesAsync(parameters).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<DnsResourceReferenceResultInner> getByTargetResourcesWithResponse(DnsResourceReferenceRequest parameters, Context context) {
        return (Response)this.getByTargetResourcesWithResponseAsync(parameters, context).block();
    }

    @Host(value="{$host}")
    @ServiceInterface(name="DnsManagementClientD")
    private static interface DnsResourceReferencesService {
        @Headers(value={"Content-Type: application/json"})
        @Post(value="/subscriptions/{subscriptionId}/providers/Microsoft.Network/getDnsResourceReference")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<DnsResourceReferenceResultInner>> getByTargetResources(@HostParam(value="$host") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="subscriptionId") String var3, @BodyParam(value="application/json") DnsResourceReferenceRequest var4, @HeaderParam(value="Accept") String var5, Context var6);
    }
}

