/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.kubernetes.commons.config.reload;

import java.time.Duration;
import java.util.List;
import javax.annotation.PostConstruct;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.boot.task.TaskSchedulerBuilder;
import org.springframework.cloud.bootstrap.config.PropertySourceLocator;
import org.springframework.cloud.kubernetes.commons.config.reload.ConfigReloadProperties;
import org.springframework.cloud.kubernetes.commons.config.reload.ConfigurationChangeDetector;
import org.springframework.cloud.kubernetes.commons.config.reload.ConfigurationUpdateStrategy;
import org.springframework.core.env.AbstractEnvironment;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.Environment;
import org.springframework.scheduling.TaskScheduler;
import org.springframework.scheduling.Trigger;
import org.springframework.scheduling.support.PeriodicTrigger;

public class PollingConfigMapChangeDetector
extends ConfigurationChangeDetector {
    protected Log log = LogFactory.getLog(this.getClass());
    private PropertySourceLocator propertySourceLocator;
    private Class propertySourceClass;
    private TaskScheduler taskExecutor;
    private Duration period = Duration.ofMillis(1500L);

    @Deprecated
    public PollingConfigMapChangeDetector(AbstractEnvironment environment, ConfigReloadProperties properties, ConfigurationUpdateStrategy strategy, Class propertySourceClass, PropertySourceLocator propertySourceLocator) {
        super((ConfigurableEnvironment)environment, properties, strategy);
        this.propertySourceLocator = propertySourceLocator;
        this.propertySourceClass = propertySourceClass;
        this.taskExecutor = new TaskSchedulerBuilder().build();
    }

    public PollingConfigMapChangeDetector(AbstractEnvironment environment, ConfigReloadProperties properties, ConfigurationUpdateStrategy strategy, Class propertySourceClass, PropertySourceLocator propertySourceLocator, TaskScheduler taskExecutor) {
        super((ConfigurableEnvironment)environment, properties, strategy);
        this.propertySourceLocator = propertySourceLocator;
        this.propertySourceClass = propertySourceClass;
        this.taskExecutor = taskExecutor;
        this.period = properties.getPeriod();
    }

    @PostConstruct
    public void init() {
        this.log.info((Object)"Kubernetes polling configMap change detector activated");
        PeriodicTrigger trigger = new PeriodicTrigger(this.period.toMillis());
        trigger.setInitialDelay(this.period.toMillis());
        this.taskExecutor.schedule(this::executeCycle, (Trigger)trigger);
    }

    public void executeCycle() {
        boolean changedConfigMap = false;
        if (this.properties.isMonitoringConfigMaps()) {
            List currentConfigMapSources;
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)"Polling for changes in config maps");
            }
            if (!(currentConfigMapSources = this.findPropertySources(this.propertySourceClass)).isEmpty()) {
                changedConfigMap = this.changed(this.locateMapPropertySources(this.propertySourceLocator, (Environment)this.environment), currentConfigMapSources);
            }
        }
        if (changedConfigMap) {
            this.log.info((Object)"Detected change in config maps");
            this.reloadProperties();
        }
    }
}

