/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.api.controller;

import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.Parameters;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.util.List;
import org.apache.dolphinscheduler.api.audit.OperatorLog;
import org.apache.dolphinscheduler.api.audit.enums.AuditType;
import org.apache.dolphinscheduler.api.controller.BaseController;
import org.apache.dolphinscheduler.api.enums.Status;
import org.apache.dolphinscheduler.api.exceptions.ApiException;
import org.apache.dolphinscheduler.api.service.DataSourceService;
import org.apache.dolphinscheduler.api.utils.PageInfo;
import org.apache.dolphinscheduler.api.utils.Result;
import org.apache.dolphinscheduler.dao.entity.DataSource;
import org.apache.dolphinscheduler.dao.entity.User;
import org.apache.dolphinscheduler.plugin.datasource.api.datasource.BaseDataSourceParamDTO;
import org.apache.dolphinscheduler.plugin.datasource.api.utils.CommonUtils;
import org.apache.dolphinscheduler.plugin.datasource.api.utils.DataSourceUtils;
import org.apache.dolphinscheduler.plugin.task.api.utils.ParameterUtils;
import org.apache.dolphinscheduler.spi.datasource.ConnectionParam;
import org.apache.dolphinscheduler.spi.enums.DbType;
import org.apache.dolphinscheduler.spi.params.base.ParamsOptions;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestAttribute;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.bind.annotation.RestController;

@Tag(name="DATA_SOURCE_TAG")
@RestController
@RequestMapping(value={"datasources"})
public class DataSourceController
extends BaseController {
    @Autowired
    private DataSourceService dataSourceService;

    @Operation(summary="createDataSource", description="CREATE_DATA_SOURCE_NOTES")
    @PostMapping
    @ResponseStatus(value=HttpStatus.CREATED)
    @ApiException(value=Status.CREATE_DATASOURCE_ERROR)
    @OperatorLog(auditType=AuditType.DATASOURCE_CREATE)
    public Result<DataSource> createDataSource(@Parameter(hidden=true) @RequestAttribute(value="session.user") User loginUser, @Parameter(name="dataSourceParam", description="DATA_SOURCE_PARAM", required=true) @RequestBody String jsonStr) {
        BaseDataSourceParamDTO dataSourceParam = DataSourceUtils.buildDatasourceParam((String)jsonStr);
        DataSource dataSource = this.dataSourceService.createDataSource(loginUser, dataSourceParam);
        return Result.success(dataSource);
    }

    @Operation(summary="updateDataSource", description="UPDATE_DATA_SOURCE_NOTES")
    @Parameters(value={@Parameter(name="id", description="DATA_SOURCE_ID", required=true, schema=@Schema(implementation=int.class)), @Parameter(name="dataSourceParam", description="DATA_SOURCE_PARAM", required=true, schema=@Schema(implementation=BaseDataSourceParamDTO.class))})
    @PutMapping(value={"/{id}"})
    @ResponseStatus(value=HttpStatus.OK)
    @ApiException(value=Status.UPDATE_DATASOURCE_ERROR)
    @OperatorLog(auditType=AuditType.DATASOURCE_UPDATE)
    public Result<DataSource> updateDataSource(@Parameter(hidden=true) @RequestAttribute(value="session.user") User loginUser, @PathVariable(value="id") Integer id, @RequestBody String jsonStr) {
        BaseDataSourceParamDTO dataSourceParam = DataSourceUtils.buildDatasourceParam((String)jsonStr);
        dataSourceParam.setId(id);
        DataSource dataSource = this.dataSourceService.updateDataSource(loginUser, dataSourceParam);
        return Result.success(dataSource);
    }

    @Operation(summary="queryDataSource", description="QUERY_DATA_SOURCE_NOTES")
    @Parameters(value={@Parameter(name="id", description="DATA_SOURCE_ID", required=true, schema=@Schema(implementation=int.class, example="100"))})
    @GetMapping(value={"/{id}"})
    @ResponseStatus(value=HttpStatus.OK)
    @ApiException(value=Status.QUERY_DATASOURCE_ERROR)
    public Result<Object> queryDataSource(@Parameter(hidden=true) @RequestAttribute(value="session.user") User loginUser, @PathVariable(value="id") int id) {
        BaseDataSourceParamDTO dataSource = this.dataSourceService.queryDataSource(id, loginUser);
        return Result.success(dataSource);
    }

    @Operation(summary="queryDataSourceList", description="QUERY_DATA_SOURCE_LIST_BY_TYPE_NOTES")
    @Parameters(value={@Parameter(name="type", description="DB_TYPE", required=true, schema=@Schema(implementation=DbType.class))})
    @GetMapping(value={"/list"})
    @ResponseStatus(value=HttpStatus.OK)
    @ApiException(value=Status.QUERY_DATASOURCE_ERROR)
    public Result<Object> queryDataSourceList(@Parameter(hidden=true) @RequestAttribute(value="session.user") User loginUser, @RequestParam(value="type") DbType type) {
        List<DataSource> datasourceList = this.dataSourceService.queryDataSourceList(loginUser, type.getCode());
        return Result.success(datasourceList);
    }

    @Operation(summary="queryDataSourceListPaging", description="QUERY_DATA_SOURCE_LIST_PAGING_NOTES")
    @Parameters(value={@Parameter(name="searchVal", description="SEARCH_VAL", schema=@Schema(implementation=String.class)), @Parameter(name="pageNo", description="PAGE_NO", required=true, schema=@Schema(implementation=int.class, example="1")), @Parameter(name="pageSize", description="PAGE_SIZE", required=true, schema=@Schema(implementation=int.class, example="20"))})
    @GetMapping
    @ResponseStatus(value=HttpStatus.OK)
    @ApiException(value=Status.QUERY_DATASOURCE_ERROR)
    public Result<Object> queryDataSourceListPaging(@Parameter(hidden=true) @RequestAttribute(value="session.user") User loginUser, @RequestParam(value="searchVal", required=false) String searchVal, @RequestParam(value="pageNo") Integer pageNo, @RequestParam(value="pageSize") Integer pageSize) {
        this.checkPageParams(pageNo, pageSize);
        searchVal = ParameterUtils.handleEscapes((String)searchVal);
        PageInfo<DataSource> pageInfo = this.dataSourceService.queryDataSourceListPaging(loginUser, searchVal, pageNo, pageSize);
        return Result.success(pageInfo);
    }

    @Operation(summary="connectDataSource", description="CONNECT_DATA_SOURCE_NOTES")
    @PostMapping(value={"/connect"})
    @ResponseStatus(value=HttpStatus.OK)
    @ApiException(value=Status.CONNECT_DATASOURCE_FAILURE)
    public Result<Boolean> connectDataSource(@Parameter(hidden=true) @RequestAttribute(value="session.user") User loginUser, @io.swagger.v3.oas.annotations.parameters.RequestBody(description="dataSourceParam") @RequestBody String jsonStr) {
        BaseDataSourceParamDTO dataSourceParam = DataSourceUtils.buildDatasourceParam((String)jsonStr);
        DataSourceUtils.checkDatasourceParam((BaseDataSourceParamDTO)dataSourceParam);
        ConnectionParam connectionParams = DataSourceUtils.buildConnectionParams((BaseDataSourceParamDTO)dataSourceParam);
        this.dataSourceService.checkConnection(dataSourceParam.getType(), connectionParams);
        return Result.success(true);
    }

    @Operation(summary="connectionTest", description="CONNECT_DATA_SOURCE_TEST_NOTES")
    @Parameters(value={@Parameter(name="id", description="DATA_SOURCE_ID", required=true, schema=@Schema(implementation=int.class, example="100"))})
    @GetMapping(value={"/{id}/connect-test"})
    @ResponseStatus(value=HttpStatus.OK)
    @ApiException(value=Status.CONNECTION_TEST_FAILURE)
    public Result<Boolean> connectionTest(@Parameter(hidden=true) @RequestAttribute(value="session.user") User loginUser, @PathVariable(value="id") int id) {
        this.dataSourceService.connectionTest(id);
        return Result.success(true);
    }

    @Operation(summary="deleteDataSource", description="DELETE_DATA_SOURCE_NOTES")
    @Parameters(value={@Parameter(name="id", description="DATA_SOURCE_ID", required=true, schema=@Schema(implementation=int.class, example="100"))})
    @DeleteMapping(value={"/{id}"})
    @ResponseStatus(value=HttpStatus.OK)
    @ApiException(value=Status.DELETE_DATA_SOURCE_FAILURE)
    @OperatorLog(auditType=AuditType.DATASOURCE_DELETE)
    public Result<Boolean> deleteDataSource(@Parameter(hidden=true) @RequestAttribute(value="session.user") User loginUser, @PathVariable(value="id") int id) {
        this.dataSourceService.delete(loginUser, id);
        return Result.success(true);
    }

    @Operation(summary="verifyDataSourceName", description="VERIFY_DATA_SOURCE_NOTES")
    @Parameters(value={@Parameter(name="name", description="DATA_SOURCE_NAME", required=true, schema=@Schema(implementation=String.class))})
    @GetMapping(value={"/verify-name"})
    @ResponseStatus(value=HttpStatus.OK)
    @ApiException(value=Status.VERIFY_DATASOURCE_NAME_FAILURE)
    public Result<Boolean> verifyDataSourceName(@Parameter(hidden=true) @RequestAttribute(value="session.user") User loginUser, @RequestParam(value="name") String name) {
        this.dataSourceService.verifyDataSourceName(name);
        return Result.success(true);
    }

    @Operation(summary="unauthorizedDatasource", description="UNAUTHORIZED_DATA_SOURCE_NOTES")
    @Parameters(value={@Parameter(name="userId", description="USER_ID", required=true, schema=@Schema(implementation=int.class, example="100"))})
    @GetMapping(value={"/unauth-datasource"})
    @ResponseStatus(value=HttpStatus.OK)
    @ApiException(value=Status.UNAUTHORIZED_DATASOURCE)
    public Result<Object> unAuthDatasource(@Parameter(hidden=true) @RequestAttribute(value="session.user") User loginUser, @RequestParam(value="userId") Integer userId) {
        List<DataSource> unAuthDatasourceList = this.dataSourceService.unAuthDatasource(loginUser, userId);
        return Result.success(unAuthDatasourceList);
    }

    @Operation(summary="authedDatasource", description="AUTHORIZED_DATA_SOURCE_NOTES")
    @Parameters(value={@Parameter(name="userId", description="USER_ID", required=true, schema=@Schema(implementation=int.class, example="100"))})
    @GetMapping(value={"/authed-datasource"})
    @ResponseStatus(value=HttpStatus.OK)
    @ApiException(value=Status.AUTHORIZED_DATA_SOURCE)
    public Result<Object> authedDatasource(@Parameter(hidden=true) @RequestAttribute(value="session.user") User loginUser, @RequestParam(value="userId") Integer userId) {
        List<DataSource> authedDatasourceList = this.dataSourceService.authedDatasource(loginUser, userId);
        return Result.success(authedDatasourceList);
    }

    @Operation(summary="getKerberosStartupState", description="GET_USER_INFO_NOTES")
    @GetMapping(value={"/kerberos-startup-state"})
    @ResponseStatus(value=HttpStatus.OK)
    @ApiException(value=Status.KERBEROS_STARTUP_STATE)
    public Result<Object> getKerberosStartupState(@Parameter(hidden=true) @RequestAttribute(value="session.user") User loginUser) {
        return this.success(Status.SUCCESS.getMsg(), CommonUtils.getKerberosStartupState());
    }

    @Operation(summary="tables", description="GET_DATASOURCE_TABLES_NOTES")
    @Parameters(value={@Parameter(name="datasourceId", description="DATA_SOURCE_ID", required=true, schema=@Schema(implementation=int.class, example="1")), @Parameter(name="database", description="DATABASE", required=true, schema=@Schema(implementation=String.class, example="test"))})
    @GetMapping(value={"/tables"})
    @ResponseStatus(value=HttpStatus.OK)
    @ApiException(value=Status.GET_DATASOURCE_TABLES_ERROR)
    public Result<Object> getTables(@RequestParam(value="datasourceId") Integer datasourceId, @RequestParam(value="database") String database) {
        List<ParamsOptions> options = this.dataSourceService.getTables(datasourceId, database);
        return Result.success(options);
    }

    @Operation(summary="tableColumns", description="GET_DATASOURCE_TABLE_COLUMNS_NOTES")
    @Parameters(value={@Parameter(name="datasourceId", description="DATA_SOURCE_ID", required=true, schema=@Schema(implementation=int.class, example="1")), @Parameter(name="tableName", description="TABLE_NAME", required=true, schema=@Schema(implementation=String.class, example="test")), @Parameter(name="database", description="DATABASE", required=true, schema=@Schema(implementation=String.class, example="test"))})
    @GetMapping(value={"/tableColumns"})
    @ResponseStatus(value=HttpStatus.OK)
    @ApiException(value=Status.GET_DATASOURCE_TABLE_COLUMNS_ERROR)
    public Result<Object> getTableColumns(@RequestParam(value="datasourceId") Integer datasourceId, @RequestParam(value="tableName") String tableName, @RequestParam(value="database") String database) {
        List<ParamsOptions> options = this.dataSourceService.getTableColumns(datasourceId, database, tableName);
        return Result.success(options);
    }

    @Operation(summary="databases", description="GET_DATASOURCE_DATABASE_NOTES")
    @Parameters(value={@Parameter(name="datasourceId", description="DATA_SOURCE_ID", required=true, schema=@Schema(implementation=int.class, example="1"))})
    @GetMapping(value={"/databases"})
    @ResponseStatus(value=HttpStatus.OK)
    @ApiException(value=Status.GET_DATASOURCE_DATABASES_ERROR)
    public Result<Object> getDatabases(@RequestParam(value="datasourceId") Integer datasourceId) {
        List<ParamsOptions> options = this.dataSourceService.getDatabases(datasourceId);
        return Result.success(options);
    }
}

