/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.api.k8s;

import io.fabric8.kubernetes.client.Config;
import io.fabric8.kubernetes.client.KubernetesClient;
import io.fabric8.kubernetes.client.KubernetesClientBuilder;
import java.util.Hashtable;
import java.util.Map;
import lombok.Generated;
import org.apache.dolphinscheduler.dao.entity.Cluster;
import org.apache.dolphinscheduler.dao.mapper.ClusterMapper;
import org.apache.dolphinscheduler.service.utils.ClusterConfUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class K8sManager {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(K8sManager.class);
    private static Map<Long, KubernetesClient> clientMap = new Hashtable<Long, KubernetesClient>();
    @Autowired
    private ClusterMapper clusterMapper;

    public synchronized KubernetesClient getK8sClient(Long clusterCode) {
        if (null == clusterCode) {
            return null;
        }
        return this.getAndUpdateK8sClient(clusterCode, false);
    }

    public synchronized KubernetesClient getAndUpdateK8sClient(Long clusterCode, boolean update) {
        if (null == clusterCode) {
            return null;
        }
        if (update) {
            this.deleteK8sClientInner(clusterCode);
        }
        if (clientMap.containsKey(clusterCode)) {
            return clientMap.get(clusterCode);
        }
        this.createK8sClientInner(clusterCode);
        return clientMap.get(clusterCode);
    }

    private void deleteK8sClientInner(Long clusterCode) {
        if (clusterCode == null) {
            return;
        }
        Cluster cluster = this.clusterMapper.queryByClusterCode(clusterCode);
        if (cluster == null) {
            return;
        }
        KubernetesClient client = clientMap.get(clusterCode);
        if (client != null) {
            client.close();
        }
    }

    private void createK8sClientInner(Long clusterCode) {
        Cluster cluster = this.clusterMapper.queryByClusterCode(clusterCode);
        if (cluster == null) {
            return;
        }
        String k8sConfig = ClusterConfUtils.getK8sConfig((String)cluster.getConfig());
        if (k8sConfig != null) {
            KubernetesClient client = null;
            try {
                client = this.getClient(k8sConfig);
                clientMap.put(clusterCode, client);
            }
            catch (Exception e) {
                log.error("cluster code ={},fail to get k8s ApiClient:  {}", (Object)clusterCode, (Object)e.getMessage());
                throw new RuntimeException("fail to get k8s ApiClient:" + e.getMessage());
            }
        }
    }

    private KubernetesClient getClient(String configYaml) throws RuntimeException {
        try {
            Config config = Config.fromKubeconfig((String)configYaml);
            return new KubernetesClientBuilder().withConfig(config).build();
        }
        catch (Exception e) {
            log.error("Fail to get k8s ApiClient", (Throwable)e);
            throw new RuntimeException("fail to get k8s ApiClient:" + e.getMessage());
        }
    }
}

