/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.api.python;

import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.PostConstruct;
import lombok.Generated;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.dolphinscheduler.api.configuration.ApiConfig;
import org.apache.dolphinscheduler.api.dto.EnvironmentDto;
import org.apache.dolphinscheduler.api.dto.resources.ResourceComponent;
import org.apache.dolphinscheduler.api.dto.workflow.WorkflowTriggerRequest;
import org.apache.dolphinscheduler.api.enums.Status;
import org.apache.dolphinscheduler.api.exceptions.ServiceException;
import org.apache.dolphinscheduler.api.service.EnvironmentService;
import org.apache.dolphinscheduler.api.service.ExecutorService;
import org.apache.dolphinscheduler.api.service.ProjectService;
import org.apache.dolphinscheduler.api.service.ResourcesService;
import org.apache.dolphinscheduler.api.service.SchedulerService;
import org.apache.dolphinscheduler.api.service.TaskDefinitionService;
import org.apache.dolphinscheduler.api.service.TenantService;
import org.apache.dolphinscheduler.api.service.UsersService;
import org.apache.dolphinscheduler.api.service.WorkflowDefinitionService;
import org.apache.dolphinscheduler.common.enums.CommandType;
import org.apache.dolphinscheduler.common.enums.ComplementDependentMode;
import org.apache.dolphinscheduler.common.enums.ExecutionOrder;
import org.apache.dolphinscheduler.common.enums.FailureStrategy;
import org.apache.dolphinscheduler.common.enums.Flag;
import org.apache.dolphinscheduler.common.enums.Priority;
import org.apache.dolphinscheduler.common.enums.ReleaseState;
import org.apache.dolphinscheduler.common.enums.RunMode;
import org.apache.dolphinscheduler.common.enums.TaskDependType;
import org.apache.dolphinscheduler.common.enums.UserType;
import org.apache.dolphinscheduler.common.enums.WarningType;
import org.apache.dolphinscheduler.common.enums.WorkflowExecutionTypeEnum;
import org.apache.dolphinscheduler.common.utils.CodeGenerateUtils;
import org.apache.dolphinscheduler.dao.entity.DataSource;
import org.apache.dolphinscheduler.dao.entity.Project;
import org.apache.dolphinscheduler.dao.entity.ProjectUser;
import org.apache.dolphinscheduler.dao.entity.Queue;
import org.apache.dolphinscheduler.dao.entity.Schedule;
import org.apache.dolphinscheduler.dao.entity.TaskDefinition;
import org.apache.dolphinscheduler.dao.entity.Tenant;
import org.apache.dolphinscheduler.dao.entity.User;
import org.apache.dolphinscheduler.dao.entity.WorkflowDefinition;
import org.apache.dolphinscheduler.dao.mapper.DataSourceMapper;
import org.apache.dolphinscheduler.dao.mapper.ProjectMapper;
import org.apache.dolphinscheduler.dao.mapper.ProjectUserMapper;
import org.apache.dolphinscheduler.dao.mapper.ScheduleMapper;
import org.apache.dolphinscheduler.dao.mapper.TaskDefinitionMapper;
import org.apache.dolphinscheduler.dao.mapper.WorkflowDefinitionMapper;
import org.apache.dolphinscheduler.plugin.storage.api.StorageEntity;
import org.apache.dolphinscheduler.spi.enums.ResourceType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import py4j.GatewayServer;

@Component
public class PythonGateway {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(PythonGateway.class);
    private static final FailureStrategy DEFAULT_FAILURE_STRATEGY = FailureStrategy.CONTINUE;
    private static final Priority DEFAULT_PRIORITY = Priority.MEDIUM;
    private static final Long DEFAULT_ENVIRONMENT_CODE = -1L;
    private static final TaskDependType DEFAULT_TASK_DEPEND_TYPE = TaskDependType.TASK_POST;
    private static final RunMode DEFAULT_RUN_MODE = RunMode.RUN_MODE_SERIAL;
    private static final ExecutionOrder DEFAULT_EXECUTION_ORDER = ExecutionOrder.DESC_ORDER;
    private static final int DEFAULT_DRY_RUN = 0;
    private static final ComplementDependentMode COMPLEMENT_DEPENDENT_MODE = ComplementDependentMode.OFF_MODE;
    private static final int ADMIN_USER_ID = 1;
    @Autowired
    private WorkflowDefinitionMapper workflowDefinitionMapper;
    @Autowired
    private ProjectService projectService;
    @Autowired
    private TenantService tenantService;
    @Autowired
    private EnvironmentService environmentService;
    @Autowired
    private ExecutorService executorService;
    @Autowired
    private WorkflowDefinitionService workflowDefinitionService;
    @Autowired
    private TaskDefinitionService taskDefinitionService;
    @Autowired
    private UsersService usersService;
    @Autowired
    private ResourcesService resourceService;
    @Autowired
    private ProjectMapper projectMapper;
    @Autowired
    private TaskDefinitionMapper taskDefinitionMapper;
    @Autowired
    private SchedulerService schedulerService;
    @Autowired
    private ScheduleMapper scheduleMapper;
    @Autowired
    private DataSourceMapper dataSourceMapper;
    @Autowired
    private ApiConfig apiConfig;
    @Autowired
    private ProjectUserMapper projectUserMapper;
    private final User dummyAdminUser = new User(){
        {
            this.setId(1);
            this.setUserName("dummyUser");
            this.setUserType(UserType.ADMIN_USER);
        }
    };
    private final Queue queuePythonGateway = new Queue(){
        {
            this.setId(Integer.MAX_VALUE);
            this.setQueueName("queuePythonGateway");
        }
    };

    public String ping() {
        return "PONG";
    }

    public Map<String, Object> genTaskCodeList(Integer genNum) {
        return this.taskDefinitionService.genTaskCodeList(genNum);
    }

    public Map<String, Long> getCodeAndVersion(String projectName, String workflowDefinitionName, String taskName) {
        Project project = this.projectMapper.queryByName(projectName);
        HashMap<String, Long> result = new HashMap<String, Long>();
        if (project == null) {
            result.put("code", CodeGenerateUtils.genCode());
            result.put("version", 0L);
            return result;
        }
        WorkflowDefinition workflowDefinition = this.workflowDefinitionMapper.queryByDefineName(project.getCode(), workflowDefinitionName);
        if (workflowDefinition == null) {
            result.put("code", CodeGenerateUtils.genCode());
            result.put("version", 0L);
            return result;
        }
        TaskDefinition taskDefinition = this.taskDefinitionMapper.queryByName(project.getCode(), workflowDefinition.getCode(), taskName);
        if (taskDefinition == null) {
            result.put("code", CodeGenerateUtils.genCode());
            result.put("version", 0L);
        } else {
            result.put("code", taskDefinition.getCode());
            result.put("version", Long.valueOf(taskDefinition.getVersion()));
        }
        return result;
    }

    public Long createOrUpdateWorkflow(String userName, String projectName, String name, String description, String globalParams, String schedule, boolean onlineSchedule, String warningType, int warningGroupId, int timeout, String workerGroup, int releaseState, String taskRelationJson, String taskDefinitionJson, String otherParamsJson, String executionType) {
        long workflowDefinitionCode;
        User user = this.usersService.queryUser(userName);
        if (user.getTenantCode() == null) {
            throw new RuntimeException("Can not create or update workflow for user who not related to any tenant.");
        }
        Project project = this.projectMapper.queryByName(projectName);
        long projectCode = project.getCode();
        WorkflowDefinition workflowDefinition = this.getWorkflow(user, projectCode, name);
        WorkflowExecutionTypeEnum executionTypeEnum = WorkflowExecutionTypeEnum.valueOf((String)executionType);
        if (workflowDefinition != null) {
            workflowDefinitionCode = workflowDefinition.getCode();
            this.workflowDefinitionService.offlineWorkflowDefinition(user, projectCode, workflowDefinitionCode);
            this.workflowDefinitionService.updateWorkflowDefinition(user, projectCode, name, workflowDefinitionCode, description, globalParams, null, timeout, taskRelationJson, taskDefinitionJson, executionTypeEnum);
        } else {
            Map<String, Object> result = this.workflowDefinitionService.createWorkflowDefinition(user, projectCode, name, description, globalParams, null, timeout, taskRelationJson, taskDefinitionJson, otherParamsJson, executionTypeEnum);
            if (result.get("status") != Status.SUCCESS) {
                log.error(result.get("msg").toString());
                throw new ServiceException(result.get("msg").toString());
            }
            workflowDefinition = (WorkflowDefinition)result.get("data");
            workflowDefinitionCode = workflowDefinition.getCode();
        }
        if (schedule != null) {
            this.createOrUpdateSchedule(user, projectCode, workflowDefinitionCode, schedule, onlineSchedule, workerGroup, warningType, warningGroupId);
        }
        if (ReleaseState.ONLINE.equals((Object)ReleaseState.getEnum((int)releaseState))) {
            this.workflowDefinitionService.onlineWorkflowDefinition(user, projectCode, workflowDefinitionCode);
        } else if (ReleaseState.OFFLINE.equals((Object)ReleaseState.getEnum((int)releaseState))) {
            this.workflowDefinitionService.offlineWorkflowDefinition(user, projectCode, workflowDefinitionCode);
        }
        return workflowDefinitionCode;
    }

    private WorkflowDefinition getWorkflow(User user, long projectCode, String workflowName) {
        Map<String, Object> verifyWorkflowDefinitionExists = this.workflowDefinitionService.verifyWorkflowDefinitionName(user, projectCode, workflowName, 0L);
        Status verifyStatus = (Status)((Object)verifyWorkflowDefinitionExists.get("status"));
        WorkflowDefinition workflowDefinition = null;
        if (verifyStatus == Status.WORKFLOW_DEFINITION_NAME_EXIST) {
            workflowDefinition = this.workflowDefinitionMapper.queryByDefineName(projectCode, workflowName);
        } else if (verifyStatus != Status.SUCCESS) {
            String msg = "Verify workflow exists status is invalid, neither SUCCESS or WORKFLOW_NAME_EXIST.";
            log.error(msg);
            throw new RuntimeException(msg);
        }
        return workflowDefinition;
    }

    private void createOrUpdateSchedule(User user, long projectCode, long workflowCode, String schedule, boolean onlineSchedule, String workerGroup, String warningType, int warningGroupId) {
        int scheduleId;
        Schedule scheduleObj = this.scheduleMapper.queryByWorkflowDefinitionCode(workflowCode);
        if (scheduleObj == null) {
            this.workflowDefinitionService.onlineWorkflowDefinition(user, projectCode, workflowCode);
            Map<String, Object> result = this.schedulerService.insertSchedule(user, projectCode, workflowCode, schedule, WarningType.valueOf((String)warningType), warningGroupId, DEFAULT_FAILURE_STRATEGY, DEFAULT_PRIORITY, workerGroup, user.getTenantCode(), DEFAULT_ENVIRONMENT_CODE);
            scheduleId = (Integer)result.get("scheduleId");
        } else {
            scheduleId = scheduleObj.getId();
            this.workflowDefinitionService.offlineWorkflowDefinition(user, projectCode, workflowCode);
            this.schedulerService.updateSchedule(user, projectCode, scheduleId, schedule, WarningType.valueOf((String)warningType), warningGroupId, DEFAULT_FAILURE_STRATEGY, DEFAULT_PRIORITY, workerGroup, user.getTenantCode(), DEFAULT_ENVIRONMENT_CODE);
        }
        if (onlineSchedule) {
            this.workflowDefinitionService.onlineWorkflowDefinition(user, projectCode, workflowCode);
            this.schedulerService.onlineScheduler(user, projectCode, scheduleId);
        }
    }

    public void execWorkflowInstance(String userName, String projectName, String workflowName, String workerGroup, String warningType, Integer warningGroupId) {
        User user = this.usersService.queryUser(userName);
        Project project = this.projectMapper.queryByName(projectName);
        WorkflowDefinition workflowDefinition = this.workflowDefinitionMapper.queryByDefineName(project.getCode(), workflowName);
        this.workflowDefinitionService.onlineWorkflowDefinition(user, project.getCode(), workflowDefinition.getCode());
        WorkflowTriggerRequest workflowTriggerRequest = WorkflowTriggerRequest.builder().loginUser(user).workflowDefinitionCode(workflowDefinition.getCode()).workerGroup(workerGroup).warningType(WarningType.of((String)warningType)).warningGroupId(warningGroupId).execType(CommandType.START_PROCESS).taskDependType(TaskDependType.TASK_POST).dryRun(Flag.NO).build();
        this.executorService.triggerWorkflowDefinition(workflowTriggerRequest);
    }

    private Integer grantProjectToUser(Project project, User user) {
        Date now = new Date();
        ProjectUser projectUser = new ProjectUser();
        projectUser.setUserId(user.getId().intValue());
        projectUser.setProjectId(project.getId().intValue());
        projectUser.setPerm(7);
        projectUser.setCreateTime(now);
        projectUser.setUpdateTime(now);
        return this.projectUserMapper.insert((Object)projectUser);
    }

    public void createOrGrantProject(String userName, String name, String desc) {
        ProjectUser projectUser;
        User user = this.usersService.queryUser(userName);
        Project project = this.projectMapper.queryByName(name);
        if (project == null) {
            this.projectService.createProject(user, name, desc);
        } else if (project.getUserId() != user.getId() && (projectUser = this.projectUserMapper.queryProjectRelation(project.getId().intValue(), user.getId().intValue())) == null) {
            this.grantProjectToUser(project, user);
        }
    }

    public Project queryProjectByName(String userName, String projectName) {
        User user = this.usersService.queryUser(userName);
        return (Project)this.projectService.queryByName(user, projectName).get("data");
    }

    public void updateProject(String userName, Long projectCode, String projectName, String desc) {
        User user = this.usersService.queryUser(userName);
        this.projectService.update(user, projectCode, projectName, desc);
    }

    public void deleteProject(String userName, Long projectCode) {
        User user = this.usersService.queryUser(userName);
        this.projectService.deleteProject(user, projectCode);
    }

    public Tenant createTenant(String tenantCode, String desc, String queueName) {
        return this.tenantService.createTenantIfNotExists(tenantCode, desc, queueName, queueName);
    }

    public Tenant queryTenantByCode(String tenantCode) {
        return (Tenant)this.tenantService.queryByTenantCode(tenantCode).get("data");
    }

    public void updateTenant(String userName, int id, String tenantCode, int queueId, String desc) throws Exception {
        User user = this.usersService.queryUser(userName);
        this.tenantService.updateTenant(user, id, tenantCode, queueId, desc);
    }

    public void deleteTenantById(String userName, Integer tenantId) throws Exception {
        User user = this.usersService.queryUser(userName);
        this.tenantService.deleteTenantById(user, tenantId);
    }

    public User createUser(String userName, String userPassword, String email, String phone, String tenantCode, String queue, int state) throws IOException {
        return this.usersService.createUserIfNotExists(userName, userPassword, email, phone, tenantCode, queue, state);
    }

    public User queryUser(int id) {
        User user = this.usersService.queryUser(id);
        if (user == null) {
            throw new RuntimeException("User not found");
        }
        return user;
    }

    public User updateUser(String userName, String userPassword, String email, String phone, String tenantCode, String queue, int state) throws Exception {
        return this.usersService.createUserIfNotExists(userName, userPassword, email, phone, tenantCode, queue, state);
    }

    public User deleteUser(String userName, int id) throws Exception {
        User user = this.usersService.queryUser(userName);
        this.usersService.deleteUserById(user, id);
        return this.usersService.queryUser(userName);
    }

    public DataSource getDatasource(String datasourceName, String type) {
        List dataSourceList = this.dataSourceMapper.queryDataSourceByName(datasourceName);
        if (dataSourceList == null || dataSourceList.isEmpty()) {
            String msg = String.format("Can not find any datasource by name %s", datasourceName);
            log.error(msg);
            throw new IllegalArgumentException(msg);
        }
        List dataSourceListMatchType = dataSourceList.stream().filter(dataSource -> type == null || StringUtils.equalsIgnoreCase((CharSequence)dataSource.getType().name(), (CharSequence)type)).collect(Collectors.toList());
        log.info("Get the datasource list match the type are: {}", dataSourceListMatchType);
        if (dataSourceListMatchType.size() > 1) {
            String msg = String.format("Get more than one datasource by name %s", datasourceName);
            log.error(msg);
            throw new IllegalArgumentException(msg);
        }
        return (DataSource)dataSourceListMatchType.stream().findFirst().orElseThrow(() -> {
            String msg = String.format("Can not find any datasource by name %s and type %s", datasourceName, type);
            log.error(msg);
            return new IllegalArgumentException(msg);
        });
    }

    public Map<String, Object> getWorkflowInfo(String userName, String projectName, String workflowName) {
        Project project;
        long projectCode;
        HashMap<String, Object> result = new HashMap<String, Object>();
        User user = this.usersService.queryUser(userName);
        WorkflowDefinition workflowDefinition = this.getWorkflow(user, projectCode = (project = (Project)this.projectService.queryByName(user, projectName).get("data")).getCode(), workflowName);
        if (workflowDefinition == null) {
            String msg = String.format("Can not find valid workflow by name %s", workflowName);
            log.error(msg);
            throw new IllegalArgumentException(msg);
        }
        this.workflowDefinitionService.onlineWorkflowDefinition(user, projectCode, workflowDefinition.getCode());
        result.put("id", workflowDefinition.getId());
        result.put("name", workflowDefinition.getName());
        result.put("code", workflowDefinition.getCode());
        return result;
    }

    public Map<String, Object> getDependentInfo(String projectName, String workflowName, String taskName) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        Project project = this.projectMapper.queryByName(projectName);
        if (project == null) {
            String msg = String.format("Can not find valid project by name %s", projectName);
            log.error(msg);
            throw new IllegalArgumentException(msg);
        }
        long projectCode = project.getCode();
        result.put("projectCode", projectCode);
        WorkflowDefinition workflowDefinition = this.workflowDefinitionMapper.queryByDefineName(projectCode, workflowName);
        if (workflowDefinition == null) {
            String msg = String.format("Can not find valid workflow by name %s", workflowName);
            log.error(msg);
            throw new IllegalArgumentException(msg);
        }
        result.put("workflowDefinitionCode", workflowDefinition.getCode());
        if (taskName != null) {
            TaskDefinition taskDefinition = this.taskDefinitionMapper.queryByName(projectCode, workflowDefinition.getCode(), taskName);
            result.put("taskDefinitionCode", taskDefinition.getCode());
        }
        return result;
    }

    public Map<String, Object> getResourcesFileInfo(String fullName) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        List<ResourceComponent> resourceComponents = this.resourceService.queryResourceFiles(this.dummyAdminUser, ResourceType.FILE);
        List namedResources = resourceComponents.stream().filter(s -> fullName.equals(s.getFullName())).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(namedResources)) {
            String msg = String.format("Can not find valid resource by name %s", fullName);
            log.error(msg);
            throw new IllegalArgumentException(msg);
        }
        result.put("name", ((ResourceComponent)namedResources.get(0)).getName());
        return result;
    }

    public Long getEnvironmentInfo(String environmentName) {
        Map<String, Object> result = this.environmentService.queryEnvironmentByName(environmentName);
        if (result.get("data") == null) {
            String msg = String.format("Can not find valid environment by name %s", environmentName);
            log.error(msg);
            throw new IllegalArgumentException(msg);
        }
        EnvironmentDto environmentDto = (EnvironmentDto)EnvironmentDto.class.cast(result.get("data"));
        return environmentDto.getCode();
    }

    public StorageEntity queryResourcesFileInfo(String userName, String fullName) throws Exception {
        return this.resourceService.queryFileStatus(userName, fullName);
    }

    public String getGatewayVersion() {
        return PythonGateway.class.getPackage().getImplementationVersion();
    }

    @PostConstruct
    public void init() {
        if (this.apiConfig.getPythonGateway().isEnabled()) {
            this.start();
        }
    }

    private void start() {
        try {
            ApiConfig.PythonGatewayConfiguration pythonGatewayConfiguration = this.apiConfig.getPythonGateway();
            InetAddress gatewayHost = InetAddress.getByName(pythonGatewayConfiguration.getGatewayServerAddress());
            GatewayServer.GatewayServerBuilder serverBuilder = new GatewayServer.GatewayServerBuilder().entryPoint((Object)this).javaAddress(gatewayHost).javaPort(pythonGatewayConfiguration.getGatewayServerPort()).connectTimeout(pythonGatewayConfiguration.getConnectTimeout()).readTimeout(pythonGatewayConfiguration.getReadTimeout());
            if (!StringUtils.isEmpty((CharSequence)pythonGatewayConfiguration.getAuthToken())) {
                serverBuilder.authToken(pythonGatewayConfiguration.getAuthToken());
            }
            GatewayServer.turnLoggingOn();
            log.info("PythonGatewayService started on: " + gatewayHost.toString());
            serverBuilder.build().start();
        }
        catch (UnknownHostException e) {
            log.error("exception occurred while constructing PythonGatewayService().", (Throwable)e);
        }
    }
}

