/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.api.validator.resource;

import com.google.common.io.Files;
import org.apache.commons.lang3.StringUtils;
import org.apache.dolphinscheduler.api.dto.resources.CreateDirectoryDto;
import org.apache.dolphinscheduler.api.exceptions.ServiceException;
import org.apache.dolphinscheduler.api.validator.resource.AbstractResourceValidator;
import org.apache.dolphinscheduler.dao.repository.TenantDao;
import org.apache.dolphinscheduler.plugin.storage.api.StorageOperator;
import org.springframework.stereotype.Component;

@Component
public class CreateDirectoryDtoValidator
extends AbstractResourceValidator<CreateDirectoryDto> {
    public CreateDirectoryDtoValidator(StorageOperator storageOperator, TenantDao tenantDao) {
        super(storageOperator, tenantDao);
    }

    @Override
    public void validate(CreateDirectoryDto createDirectoryDto) {
        String directoryAbsolutePath = createDirectoryDto.getDirectoryAbsolutePath();
        this.exceptionResourceAbsolutePathInvalidated(directoryAbsolutePath);
        this.exceptionResourceExists(directoryAbsolutePath);
        this.exceptionUserNoResourcePermission(createDirectoryDto.getLoginUser(), directoryAbsolutePath);
        this.exceptionResourceIsNotDirectory(directoryAbsolutePath);
        if (StringUtils.isNotEmpty((CharSequence)Files.getFileExtension((String)directoryAbsolutePath))) {
            throw new ServiceException("The path is not a directory: " + directoryAbsolutePath);
        }
    }
}

