/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.compute.fluent.models;

import com.azure.resourcemanager.compute.models.RunCommandInputParameter;
import com.azure.resourcemanager.compute.models.VirtualMachineRunCommandInstanceView;
import com.azure.resourcemanager.compute.models.VirtualMachineRunCommandScriptSource;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;

public final class VirtualMachineRunCommandProperties {
    @JsonProperty(value="source")
    private VirtualMachineRunCommandScriptSource source;
    @JsonProperty(value="parameters")
    private List<RunCommandInputParameter> parameters;
    @JsonProperty(value="protectedParameters")
    private List<RunCommandInputParameter> protectedParameters;
    @JsonProperty(value="asyncExecution")
    private Boolean asyncExecution;
    @JsonProperty(value="runAsUser")
    private String runAsUser;
    @JsonProperty(value="runAsPassword")
    private String runAsPassword;
    @JsonProperty(value="timeoutInSeconds")
    private Integer timeoutInSeconds;
    @JsonProperty(value="outputBlobUri")
    private String outputBlobUri;
    @JsonProperty(value="errorBlobUri")
    private String errorBlobUri;
    @JsonProperty(value="provisioningState", access=JsonProperty.Access.WRITE_ONLY)
    private String provisioningState;
    @JsonProperty(value="instanceView", access=JsonProperty.Access.WRITE_ONLY)
    private VirtualMachineRunCommandInstanceView instanceView;

    public VirtualMachineRunCommandScriptSource source() {
        return this.source;
    }

    public VirtualMachineRunCommandProperties withSource(VirtualMachineRunCommandScriptSource source) {
        this.source = source;
        return this;
    }

    public List<RunCommandInputParameter> parameters() {
        return this.parameters;
    }

    public VirtualMachineRunCommandProperties withParameters(List<RunCommandInputParameter> parameters) {
        this.parameters = parameters;
        return this;
    }

    public List<RunCommandInputParameter> protectedParameters() {
        return this.protectedParameters;
    }

    public VirtualMachineRunCommandProperties withProtectedParameters(List<RunCommandInputParameter> protectedParameters) {
        this.protectedParameters = protectedParameters;
        return this;
    }

    public Boolean asyncExecution() {
        return this.asyncExecution;
    }

    public VirtualMachineRunCommandProperties withAsyncExecution(Boolean asyncExecution) {
        this.asyncExecution = asyncExecution;
        return this;
    }

    public String runAsUser() {
        return this.runAsUser;
    }

    public VirtualMachineRunCommandProperties withRunAsUser(String runAsUser) {
        this.runAsUser = runAsUser;
        return this;
    }

    public String runAsPassword() {
        return this.runAsPassword;
    }

    public VirtualMachineRunCommandProperties withRunAsPassword(String runAsPassword) {
        this.runAsPassword = runAsPassword;
        return this;
    }

    public Integer timeoutInSeconds() {
        return this.timeoutInSeconds;
    }

    public VirtualMachineRunCommandProperties withTimeoutInSeconds(Integer timeoutInSeconds) {
        this.timeoutInSeconds = timeoutInSeconds;
        return this;
    }

    public String outputBlobUri() {
        return this.outputBlobUri;
    }

    public VirtualMachineRunCommandProperties withOutputBlobUri(String outputBlobUri) {
        this.outputBlobUri = outputBlobUri;
        return this;
    }

    public String errorBlobUri() {
        return this.errorBlobUri;
    }

    public VirtualMachineRunCommandProperties withErrorBlobUri(String errorBlobUri) {
        this.errorBlobUri = errorBlobUri;
        return this;
    }

    public String provisioningState() {
        return this.provisioningState;
    }

    public VirtualMachineRunCommandInstanceView instanceView() {
        return this.instanceView;
    }

    public void validate() {
        if (this.source() != null) {
            this.source().validate();
        }
        if (this.parameters() != null) {
            this.parameters().forEach(e -> e.validate());
        }
        if (this.protectedParameters() != null) {
            this.protectedParameters().forEach(e -> e.validate());
        }
        if (this.instanceView() != null) {
            this.instanceView().validate();
        }
    }
}

