/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.authentication.aws;

import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.AWSStaticCredentialsProvider;
import com.amazonaws.auth.BasicAWSCredentials;
import com.amazonaws.auth.InstanceProfileCredentialsProvider;
import java.util.Map;
import lombok.Generated;
import org.apache.dolphinscheduler.authentication.aws.AWSCredentialsProviderType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class AWSCredentialsProviderFactor {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AWSCredentialsProviderFactor.class);

    public static AWSCredentialsProvider credentialsProvider(Map<String, String> awsProperties) {
        String awsAuthenticationType = awsProperties.getOrDefault("credentials.provider.type", AWSCredentialsProviderType.STATIC_CREDENTIALS_PROVIDER.getName());
        AWSCredentialsProviderType awsCredentialsProviderType = AWSCredentialsProviderType.of(awsAuthenticationType).orElse(null);
        if (awsCredentialsProviderType == null) {
            throw new IllegalArgumentException("The aws.credentials.provider.type: " + awsAuthenticationType + " is invalidated");
        }
        switch (awsCredentialsProviderType) {
            case STATIC_CREDENTIALS_PROVIDER: {
                return AWSCredentialsProviderFactor.createAWSStaticCredentialsProvider(awsProperties);
            }
            case INSTANCE_PROFILE_CREDENTIALS_PROVIDER: {
                return AWSCredentialsProviderFactor.createInstanceProfileCredentialsProvider();
            }
        }
        throw new IllegalArgumentException("The aws.credentials.provider.type: " + awsAuthenticationType + " is invalidated");
    }

    private static AWSCredentialsProvider createAWSStaticCredentialsProvider(Map<String, String> awsProperties) {
        String awsAccessKeyId = awsProperties.get("access.key.id");
        String awsSecretAccessKey = awsProperties.get("access.key.secret");
        BasicAWSCredentials basicAWSCredentials = new BasicAWSCredentials(awsAccessKeyId, awsSecretAccessKey);
        AWSStaticCredentialsProvider awsStaticCredentialsProvider = new AWSStaticCredentialsProvider((AWSCredentials)basicAWSCredentials);
        log.info("AWSStaticCredentialsProvider created successfully");
        return awsStaticCredentialsProvider;
    }

    private static AWSCredentialsProvider createInstanceProfileCredentialsProvider() {
        InstanceProfileCredentialsProvider instanceProfileCredentialsProvider = InstanceProfileCredentialsProvider.getInstance();
        log.info("InstanceProfileCredentialsProvider created successfully");
        return instanceProfileCredentialsProvider;
    }

    @Generated
    private AWSCredentialsProviderFactor() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

