/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.search.implementation;

import com.azure.core.annotation.ServiceClient;
import com.azure.core.http.HttpPipeline;
import com.azure.core.management.AzureEnvironment;
import com.azure.core.util.serializer.SerializerAdapter;
import com.azure.resourcemanager.resources.fluentcore.AzureServiceClient;
import com.azure.resourcemanager.search.fluent.AdminKeysClient;
import com.azure.resourcemanager.search.fluent.OperationsClient;
import com.azure.resourcemanager.search.fluent.PrivateEndpointConnectionsClient;
import com.azure.resourcemanager.search.fluent.PrivateLinkResourcesClient;
import com.azure.resourcemanager.search.fluent.QueryKeysClient;
import com.azure.resourcemanager.search.fluent.SearchManagementClient;
import com.azure.resourcemanager.search.fluent.ServicesClient;
import com.azure.resourcemanager.search.fluent.SharedPrivateLinkResourcesClient;
import com.azure.resourcemanager.search.implementation.AdminKeysClientImpl;
import com.azure.resourcemanager.search.implementation.OperationsClientImpl;
import com.azure.resourcemanager.search.implementation.PrivateEndpointConnectionsClientImpl;
import com.azure.resourcemanager.search.implementation.PrivateLinkResourcesClientImpl;
import com.azure.resourcemanager.search.implementation.QueryKeysClientImpl;
import com.azure.resourcemanager.search.implementation.SearchManagementClientBuilder;
import com.azure.resourcemanager.search.implementation.ServicesClientImpl;
import com.azure.resourcemanager.search.implementation.SharedPrivateLinkResourcesClientImpl;
import java.time.Duration;

@ServiceClient(builder=SearchManagementClientBuilder.class)
public final class SearchManagementClientImpl
extends AzureServiceClient
implements SearchManagementClient {
    private final String subscriptionId;
    private final String endpoint;
    private final String apiVersion;
    private final HttpPipeline httpPipeline;
    private final SerializerAdapter serializerAdapter;
    private final Duration defaultPollInterval;
    private final OperationsClient operations;
    private final AdminKeysClient adminKeys;
    private final QueryKeysClient queryKeys;
    private final ServicesClient services;
    private final PrivateLinkResourcesClient privateLinkResources;
    private final PrivateEndpointConnectionsClient privateEndpointConnections;
    private final SharedPrivateLinkResourcesClient sharedPrivateLinkResources;

    @Override
    public String getSubscriptionId() {
        return this.subscriptionId;
    }

    @Override
    public String getEndpoint() {
        return this.endpoint;
    }

    @Override
    public String getApiVersion() {
        return this.apiVersion;
    }

    @Override
    public HttpPipeline getHttpPipeline() {
        return this.httpPipeline;
    }

    SerializerAdapter getSerializerAdapter() {
        return this.serializerAdapter;
    }

    @Override
    public Duration getDefaultPollInterval() {
        return this.defaultPollInterval;
    }

    @Override
    public OperationsClient getOperations() {
        return this.operations;
    }

    @Override
    public AdminKeysClient getAdminKeys() {
        return this.adminKeys;
    }

    @Override
    public QueryKeysClient getQueryKeys() {
        return this.queryKeys;
    }

    @Override
    public ServicesClient getServices() {
        return this.services;
    }

    @Override
    public PrivateLinkResourcesClient getPrivateLinkResources() {
        return this.privateLinkResources;
    }

    @Override
    public PrivateEndpointConnectionsClient getPrivateEndpointConnections() {
        return this.privateEndpointConnections;
    }

    @Override
    public SharedPrivateLinkResourcesClient getSharedPrivateLinkResources() {
        return this.sharedPrivateLinkResources;
    }

    SearchManagementClientImpl(HttpPipeline httpPipeline, SerializerAdapter serializerAdapter, Duration defaultPollInterval, AzureEnvironment environment, String subscriptionId, String endpoint) {
        super(httpPipeline, serializerAdapter, environment);
        this.httpPipeline = httpPipeline;
        this.serializerAdapter = serializerAdapter;
        this.defaultPollInterval = defaultPollInterval;
        this.subscriptionId = subscriptionId;
        this.endpoint = endpoint;
        this.apiVersion = "2020-08-01";
        this.operations = new OperationsClientImpl(this);
        this.adminKeys = new AdminKeysClientImpl(this);
        this.queryKeys = new QueryKeysClientImpl(this);
        this.services = new ServicesClientImpl(this);
        this.privateLinkResources = new PrivateLinkResourcesClientImpl(this);
        this.privateEndpointConnections = new PrivateEndpointConnectionsClientImpl(this);
        this.sharedPrivateLinkResources = new SharedPrivateLinkResourcesClientImpl(this);
    }
}

