/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.extract.base.client;

import com.google.common.base.Preconditions;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.UndeclaredThrowableException;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import lombok.Generated;
import org.apache.dolphinscheduler.extract.base.RpcMethod;
import org.apache.dolphinscheduler.extract.base.client.ClientMethodInvoker;
import org.apache.dolphinscheduler.extract.base.client.NettyRemotingClient;
import org.apache.dolphinscheduler.extract.base.client.SyncClientMethodInvoker;
import org.apache.dolphinscheduler.extract.base.utils.Host;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class ClientInvocationHandler
implements InvocationHandler {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ClientInvocationHandler.class);
    private final NettyRemotingClient nettyRemotingClient;
    private final Map<String, ClientMethodInvoker> methodInvokerMap;
    private final Host serverHost;

    ClientInvocationHandler(Host serverHost, NettyRemotingClient nettyRemotingClient) {
        this.serverHost = (Host)Preconditions.checkNotNull((Object)serverHost);
        this.nettyRemotingClient = (NettyRemotingClient)Preconditions.checkNotNull((Object)nettyRemotingClient);
        this.methodInvokerMap = new ConcurrentHashMap<String, ClientMethodInvoker>();
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        if (method.getAnnotation(RpcMethod.class) == null) {
            return method.invoke(proxy, args);
        }
        ClientMethodInvoker methodInvoker = this.methodInvokerMap.computeIfAbsent(method.toGenericString(), m -> new SyncClientMethodInvoker(this.serverHost, method, this.nettyRemotingClient));
        try {
            return methodInvoker.invoke(proxy, method, args);
        }
        catch (UndeclaredThrowableException undeclaredThrowableException) {
            throw undeclaredThrowableException.getCause();
        }
        catch (Throwable throwable) {
            throw throwable;
        }
    }
}

