/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.xds;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.errorprone.annotations.DoNotCall;
import io.grpc.Attributes;
import io.grpc.ExperimentalApi;
import io.grpc.ForwardingServerBuilder;
import io.grpc.Internal;
import io.grpc.Server;
import io.grpc.ServerBuilder;
import io.grpc.ServerCredentials;
import io.grpc.netty.shaded.io.grpc.netty.InternalNettyServerBuilder;
import io.grpc.netty.shaded.io.grpc.netty.InternalNettyServerCredentials;
import io.grpc.netty.shaded.io.grpc.netty.InternalProtocolNegotiator;
import io.grpc.netty.shaded.io.grpc.netty.NettyServerBuilder;
import io.grpc.xds.FilterChainMatchingProtocolNegotiators;
import io.grpc.xds.FilterChainSelectorManager;
import io.grpc.xds.FilterRegistry;
import io.grpc.xds.InternalXdsAttributes;
import io.grpc.xds.SharedXdsClientPoolProvider;
import io.grpc.xds.XdsNameResolverProvider;
import io.grpc.xds.XdsServerWrapper;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Logger;

@ExperimentalApi(value="https://github.com/grpc/grpc-java/issues/7514")
public final class XdsServerBuilder
extends ForwardingServerBuilder<XdsServerBuilder> {
    private static final long AS_LARGE_AS_INFINITE = TimeUnit.DAYS.toNanos(1000L);
    private final NettyServerBuilder delegate;
    private final int port;
    private XdsServingStatusListener xdsServingStatusListener;
    private AtomicBoolean isServerBuilt = new AtomicBoolean(false);
    private final FilterRegistry filterRegistry = FilterRegistry.getDefaultRegistry();
    private XdsNameResolverProvider.XdsClientPoolFactory xdsClientPoolFactory = SharedXdsClientPoolProvider.getDefaultProvider();
    private long drainGraceTime = 10L;
    private TimeUnit drainGraceTimeUnit = TimeUnit.MINUTES;

    private XdsServerBuilder(NettyServerBuilder nettyDelegate, int port) {
        this.delegate = nettyDelegate;
        this.port = port;
        this.xdsServingStatusListener = new DefaultListener("port:" + port);
    }

    @Internal
    protected ServerBuilder<?> delegate() {
        Preconditions.checkState((!this.isServerBuilt.get() ? 1 : 0) != 0, (Object)"Server already built!");
        return this.delegate;
    }

    public XdsServerBuilder xdsServingStatusListener(XdsServingStatusListener xdsServingStatusListener) {
        this.xdsServingStatusListener = (XdsServingStatusListener)Preconditions.checkNotNull((Object)xdsServingStatusListener, (Object)"xdsServingStatusListener");
        return this;
    }

    public XdsServerBuilder drainGraceTime(long drainGraceTime, TimeUnit drainGraceTimeUnit) {
        Preconditions.checkArgument((drainGraceTime >= 0L ? 1 : 0) != 0, (String)"drain grace time must be non-negative: %s", (long)drainGraceTime);
        Preconditions.checkNotNull((Object)((Object)drainGraceTimeUnit), (Object)"drainGraceTimeUnit");
        if (drainGraceTimeUnit.toNanos(drainGraceTime) >= AS_LARGE_AS_INFINITE) {
            drainGraceTimeUnit = null;
        }
        this.drainGraceTime = drainGraceTime;
        this.drainGraceTimeUnit = drainGraceTimeUnit;
        return this;
    }

    @DoNotCall(value="Unsupported. Use forPort(int, ServerCredentials) instead")
    public static ServerBuilder<?> forPort(int port) {
        throw new UnsupportedOperationException("Unsupported call - use forPort(int, ServerCredentials)");
    }

    public static XdsServerBuilder forPort(int port, ServerCredentials serverCredentials) {
        Preconditions.checkNotNull((Object)serverCredentials, (Object)"serverCredentials");
        InternalProtocolNegotiator.ServerFactory originalNegotiatorFactory = InternalNettyServerCredentials.toNegotiator((ServerCredentials)serverCredentials);
        ServerCredentials wrappedCredentials = InternalNettyServerCredentials.create((InternalProtocolNegotiator.ServerFactory)new FilterChainMatchingProtocolNegotiators.FilterChainMatchingNegotiatorServerFactory(originalNegotiatorFactory));
        NettyServerBuilder nettyDelegate = NettyServerBuilder.forPort((int)port, (ServerCredentials)wrappedCredentials);
        return new XdsServerBuilder(nettyDelegate, port);
    }

    public Server build() {
        Preconditions.checkState((boolean)this.isServerBuilt.compareAndSet(false, true), (Object)"Server already built!");
        FilterChainSelectorManager filterChainSelectorManager = new FilterChainSelectorManager();
        Attributes.Builder builder = Attributes.newBuilder().set(InternalXdsAttributes.ATTR_FILTER_CHAIN_SELECTOR_MANAGER, (Object)filterChainSelectorManager);
        if (this.drainGraceTimeUnit != null) {
            builder.set(InternalXdsAttributes.ATTR_DRAIN_GRACE_NANOS, (Object)this.drainGraceTimeUnit.toNanos(this.drainGraceTime));
        }
        InternalNettyServerBuilder.eagAttributes((NettyServerBuilder)this.delegate, (Attributes)builder.build());
        return new XdsServerWrapper("0.0.0.0:" + this.port, (ServerBuilder<?>)this.delegate, this.xdsServingStatusListener, filterChainSelectorManager, this.xdsClientPoolFactory, this.filterRegistry);
    }

    @VisibleForTesting
    XdsServerBuilder xdsClientPoolFactory(XdsNameResolverProvider.XdsClientPoolFactory xdsClientPoolFactory) {
        this.xdsClientPoolFactory = (XdsNameResolverProvider.XdsClientPoolFactory)Preconditions.checkNotNull((Object)xdsClientPoolFactory, (Object)"xdsClientPoolFactory");
        return this;
    }

    public ServerBuilder<?> transportBuilder() {
        return this.delegate;
    }

    private static class DefaultListener
    implements XdsServingStatusListener {
        private final Logger logger = Logger.getLogger(DefaultListener.class.getName());
        private final String prefix;
        boolean notServing;

        DefaultListener(String prefix) {
            this.prefix = prefix;
            this.notServing = true;
        }

        @Override
        public void onServing() {
            if (this.notServing) {
                this.notServing = false;
                this.logger.warning("[" + this.prefix + "] Entering serving state.");
            }
        }

        @Override
        public void onNotServing(Throwable throwable) {
            this.logger.warning("[" + this.prefix + "] " + throwable.getMessage());
            this.notServing = true;
        }
    }

    public static interface XdsServingStatusListener {
        public void onServing();

        public void onNotServing(Throwable var1);
    }
}

