/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.common.model;

import lombok.Generated;
import org.apache.dolphinscheduler.common.model.HeartBeat;
import org.apache.dolphinscheduler.common.thread.BaseDaemonThread;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BaseHeartBeatTask<T extends HeartBeat>
extends BaseDaemonThread {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(BaseHeartBeatTask.class);
    private static final long DEFAULT_HEARTBEAT_SCAN_INTERVAL = 1000L;
    private final String threadName;
    private final long heartBeatInterval;
    protected boolean runningFlag;
    protected long lastWriteTime = 0L;
    protected T lastHeartBeat = null;

    public BaseHeartBeatTask(String threadName, long heartBeatInterval) {
        super(threadName);
        this.threadName = threadName;
        this.heartBeatInterval = heartBeatInterval;
        this.runningFlag = true;
    }

    @Override
    public synchronized void start() {
        log.info("Starting {}...", (Object)this.threadName);
        super.start();
        log.info("Started {}, heartBeatInterval: {}...", (Object)this.threadName, (Object)this.heartBeatInterval);
    }

    @Override
    public void run() {
        while (this.runningFlag) {
            try {
                T heartBeat = this.getHeartBeat();
                if (System.currentTimeMillis() - this.lastWriteTime < this.heartBeatInterval && this.lastHeartBeat.getServerStatus().equals((Object)heartBeat.getServerStatus())) continue;
                this.lastHeartBeat = heartBeat;
                this.writeHeartBeat(heartBeat);
                this.lastWriteTime = System.currentTimeMillis();
            }
            catch (Exception ex) {
                log.error("{} task execute failed", (Object)this.threadName, (Object)ex);
            }
            finally {
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException e) {
                    this.handleInterruptException(e);
                }
            }
        }
    }

    public void shutdown() {
        this.runningFlag = false;
        log.warn("{} finished...", (Object)this.threadName);
    }

    private void handleInterruptException(InterruptedException ex) {
        log.warn("{} has been interrupted", (Object)this.threadName, (Object)ex);
        Thread.currentThread().interrupt();
    }

    public abstract T getHeartBeat();

    public abstract void writeHeartBeat(T var1);
}

