/*
 * Decompiled with CFR 0.152.
 */
package com.obs.services.model;

import com.obs.services.internal.utils.ServiceUtils;
import com.obs.services.model.AbstractTemporarySignatureRequest;
import com.obs.services.model.HttpMethodEnum;
import com.obs.services.model.SpecialParamEnum;
import java.util.Date;

public class TemporarySignatureRequest
extends AbstractTemporarySignatureRequest {
    private long expires = 300L;
    private Date requestDate;

    public TemporarySignatureRequest() {
    }

    public TemporarySignatureRequest(HttpMethodEnum method, long expires) {
        this(method, null, null, null, expires);
    }

    public TemporarySignatureRequest(HttpMethodEnum method, String bucketName, String objectKey, SpecialParamEnum specialParam, long expires) {
        this(method, bucketName, objectKey, specialParam, expires, null);
    }

    public TemporarySignatureRequest(HttpMethodEnum method, String bucketName, String objectKey, SpecialParamEnum specialParam, long expires, Date requestDate) {
        this.method = method;
        this.bucketName = bucketName;
        this.objectKey = objectKey;
        this.specialParam = specialParam;
        this.expires = expires;
        this.requestDate = ServiceUtils.cloneDateIgnoreNull(requestDate);
    }

    public long getExpires() {
        return this.expires;
    }

    public void setExpires(long expires) {
        this.expires = expires;
    }

    public Date getRequestDate() {
        return ServiceUtils.cloneDateIgnoreNull(this.requestDate);
    }

    public void setRequestDate(Date requestDate) {
        this.requestDate = null != requestDate ? (Date)requestDate.clone() : null;
    }

    public String toString() {
        return "TemporarySignatureRequest [method=" + (Object)((Object)this.method) + ", bucketName=" + this.bucketName + ", objectKey=" + this.objectKey + ", specialParam=" + (Object)((Object)this.specialParam) + ", expires=" + this.expires + ", requestDate=" + this.requestDate + ", headers=" + this.getHeaders() + ", queryParams=" + this.getQueryParams() + "]";
    }
}

