/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.server.master.cluster.loadbalancer;

import lombok.Generated;
import org.apache.dolphinscheduler.server.master.cluster.loadbalancer.WorkerLoadBalancerType;
import org.springframework.validation.Errors;

public class WorkerLoadBalancerConfigurationProperties {
    private WorkerLoadBalancerType type = WorkerLoadBalancerType.ROUND_ROBIN;
    private DynamicWeightConfigProperties dynamicWeightConfigProperties = new DynamicWeightConfigProperties();

    public void validate(Errors errors) {
        this.dynamicWeightConfigProperties.validated(errors);
    }

    @Generated
    public WorkerLoadBalancerConfigurationProperties() {
    }

    @Generated
    public WorkerLoadBalancerType getType() {
        return this.type;
    }

    @Generated
    public DynamicWeightConfigProperties getDynamicWeightConfigProperties() {
        return this.dynamicWeightConfigProperties;
    }

    @Generated
    public void setType(WorkerLoadBalancerType type) {
        this.type = type;
    }

    @Generated
    public void setDynamicWeightConfigProperties(DynamicWeightConfigProperties dynamicWeightConfigProperties) {
        this.dynamicWeightConfigProperties = dynamicWeightConfigProperties;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof WorkerLoadBalancerConfigurationProperties)) {
            return false;
        }
        WorkerLoadBalancerConfigurationProperties other = (WorkerLoadBalancerConfigurationProperties)o;
        if (!other.canEqual(this)) {
            return false;
        }
        WorkerLoadBalancerType this$type = this.getType();
        WorkerLoadBalancerType other$type = other.getType();
        if (this$type == null ? other$type != null : !((Object)((Object)this$type)).equals((Object)other$type)) {
            return false;
        }
        DynamicWeightConfigProperties this$dynamicWeightConfigProperties = this.getDynamicWeightConfigProperties();
        DynamicWeightConfigProperties other$dynamicWeightConfigProperties = other.getDynamicWeightConfigProperties();
        return !(this$dynamicWeightConfigProperties == null ? other$dynamicWeightConfigProperties != null : !((Object)this$dynamicWeightConfigProperties).equals(other$dynamicWeightConfigProperties));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof WorkerLoadBalancerConfigurationProperties;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        WorkerLoadBalancerType $type = this.getType();
        result = result * 59 + ($type == null ? 43 : ((Object)((Object)$type)).hashCode());
        DynamicWeightConfigProperties $dynamicWeightConfigProperties = this.getDynamicWeightConfigProperties();
        result = result * 59 + ($dynamicWeightConfigProperties == null ? 43 : ((Object)$dynamicWeightConfigProperties).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "WorkerLoadBalancerConfigurationProperties(type=" + (Object)((Object)this.getType()) + ", dynamicWeightConfigProperties=" + this.getDynamicWeightConfigProperties() + ")";
    }

    public static class DynamicWeightConfigProperties {
        private int cpuUsageWeight = 30;
        private int memoryUsageWeight = 30;
        private int taskThreadPoolUsageWeight = 40;

        public void validated(Errors errors) {
            if (this.cpuUsageWeight < 0) {
                errors.rejectValue("cpuUsageWeight", "cpuUsageWeight", "cpuUsageWeight must >= 0");
            }
            if (this.memoryUsageWeight < 0) {
                errors.rejectValue("memoryUsageWeight", "memoryUsageWeight", "memoryUsageWeight must >= 0");
            }
            if (this.taskThreadPoolUsageWeight < 0) {
                errors.rejectValue("threadUsageWeight", "threadUsageWeight", "threadUsageWeight must >= 0");
            }
            if (this.cpuUsageWeight + this.memoryUsageWeight + this.taskThreadPoolUsageWeight != 100) {
                errors.rejectValue("cpuUsageWeight", "cpuUsageWeight", "cpuUsageWeight + memoryUsageWeight + threadUsageWeight must be 100");
            }
        }

        @Generated
        public DynamicWeightConfigProperties() {
        }

        @Generated
        public int getCpuUsageWeight() {
            return this.cpuUsageWeight;
        }

        @Generated
        public int getMemoryUsageWeight() {
            return this.memoryUsageWeight;
        }

        @Generated
        public int getTaskThreadPoolUsageWeight() {
            return this.taskThreadPoolUsageWeight;
        }

        @Generated
        public void setCpuUsageWeight(int cpuUsageWeight) {
            this.cpuUsageWeight = cpuUsageWeight;
        }

        @Generated
        public void setMemoryUsageWeight(int memoryUsageWeight) {
            this.memoryUsageWeight = memoryUsageWeight;
        }

        @Generated
        public void setTaskThreadPoolUsageWeight(int taskThreadPoolUsageWeight) {
            this.taskThreadPoolUsageWeight = taskThreadPoolUsageWeight;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof DynamicWeightConfigProperties)) {
                return false;
            }
            DynamicWeightConfigProperties other = (DynamicWeightConfigProperties)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.getCpuUsageWeight() != other.getCpuUsageWeight()) {
                return false;
            }
            if (this.getMemoryUsageWeight() != other.getMemoryUsageWeight()) {
                return false;
            }
            return this.getTaskThreadPoolUsageWeight() == other.getTaskThreadPoolUsageWeight();
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof DynamicWeightConfigProperties;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + this.getCpuUsageWeight();
            result = result * 59 + this.getMemoryUsageWeight();
            result = result * 59 + this.getTaskThreadPoolUsageWeight();
            return result;
        }

        @Generated
        public String toString() {
            return "WorkerLoadBalancerConfigurationProperties.DynamicWeightConfigProperties(cpuUsageWeight=" + this.getCpuUsageWeight() + ", memoryUsageWeight=" + this.getMemoryUsageWeight() + ", taskThreadPoolUsageWeight=" + this.getTaskThreadPoolUsageWeight() + ")";
        }
    }
}

