/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.server.master.engine.task.client;

import com.google.common.base.Preconditions;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apache.dolphinscheduler.dao.entity.TaskInstance;
import org.apache.dolphinscheduler.plugin.task.api.utils.TaskTypeUtils;
import org.apache.dolphinscheduler.server.master.engine.exceptions.TaskKillException;
import org.apache.dolphinscheduler.server.master.engine.exceptions.TaskPauseException;
import org.apache.dolphinscheduler.server.master.engine.exceptions.TaskReassignMasterHostException;
import org.apache.dolphinscheduler.server.master.engine.task.client.ITaskExecutorClient;
import org.apache.dolphinscheduler.server.master.engine.task.client.ITaskExecutorClientDelegator;
import org.apache.dolphinscheduler.server.master.engine.task.client.LogicTaskExecutorClientDelegator;
import org.apache.dolphinscheduler.server.master.engine.task.client.PhysicalTaskExecutorClientDelegator;
import org.apache.dolphinscheduler.server.master.engine.task.runnable.ITaskExecutionRunnable;
import org.apache.dolphinscheduler.server.master.exception.dispatch.TaskDispatchException;
import org.apache.dolphinscheduler.task.executor.eventbus.ITaskExecutorLifecycleEventReporter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class TaskExecutorClient
implements ITaskExecutorClient {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(TaskExecutorClient.class);
    @Autowired
    private LogicTaskExecutorClientDelegator logicTaskExecutorClientDelegator;
    @Autowired
    private PhysicalTaskExecutorClientDelegator physicalTaskExecutorClientDelegator;

    @Override
    public void dispatch(ITaskExecutionRunnable taskExecutionRunnable) throws TaskDispatchException {
        try {
            this.getTaskExecutorClientDelegator(taskExecutionRunnable).dispatch(taskExecutionRunnable);
        }
        catch (TaskDispatchException taskDispatchException) {
            throw taskDispatchException;
        }
        catch (Exception ex) {
            throw new TaskDispatchException("Dispatch task: " + taskExecutionRunnable.getName() + " to executor failed", ex);
        }
    }

    @Override
    public boolean reassignWorkflowInstanceHost(ITaskExecutionRunnable taskExecutionRunnable) throws TaskReassignMasterHostException {
        try {
            return this.getTaskExecutorClientDelegator(taskExecutionRunnable).reassignMasterHost(taskExecutionRunnable);
        }
        catch (Exception ex) {
            throw new TaskReassignMasterHostException("Take over task: " + taskExecutionRunnable.getName() + " from executor failed", ex);
        }
    }

    @Override
    public void pause(ITaskExecutionRunnable taskExecutionRunnable) throws TaskPauseException {
        try {
            this.getTaskExecutorClientDelegator(taskExecutionRunnable).pause(taskExecutionRunnable);
        }
        catch (Exception ex) {
            throw new TaskPauseException("Pause task: " + taskExecutionRunnable.getName() + " from executor failed", ex);
        }
    }

    @Override
    public void kill(ITaskExecutionRunnable taskExecutionRunnable) throws TaskKillException {
        try {
            this.getTaskExecutorClientDelegator(taskExecutionRunnable).kill(taskExecutionRunnable);
        }
        catch (Exception ex) {
            throw new TaskKillException("Kill task: " + taskExecutionRunnable.getName() + " from executor failed", ex);
        }
    }

    @Override
    public void ackTaskExecutorLifecycleEvent(ITaskExecutionRunnable taskExecutionRunnable, ITaskExecutorLifecycleEventReporter.TaskExecutorLifecycleEventAck taskExecutorLifecycleEventAck) {
        try {
            if (StringUtils.isEmpty((CharSequence)taskExecutionRunnable.getTaskInstance().getHost())) {
                log.info("The task: {} is didn't dispatched to executor, skip ack taskExecutorLifecycleEventAck: {}", (Object)taskExecutionRunnable.getName(), (Object)taskExecutorLifecycleEventAck);
                return;
            }
            this.getTaskExecutorClientDelegator(taskExecutionRunnable).ackTaskExecutorLifecycleEvent(taskExecutionRunnable, taskExecutorLifecycleEventAck);
        }
        catch (Exception ex) {
            log.error("Send taskExecutorLifecycleEventAck: {} failed", (Object)taskExecutorLifecycleEventAck, (Object)ex);
        }
    }

    private ITaskExecutorClientDelegator getTaskExecutorClientDelegator(ITaskExecutionRunnable taskExecutionRunnable) {
        TaskInstance taskInstance = taskExecutionRunnable.getTaskInstance();
        Preconditions.checkArgument((taskInstance != null ? 1 : 0) != 0, (Object)"taskType cannot be empty");
        if (TaskTypeUtils.isLogicTask((String)taskInstance.getTaskType())) {
            return this.logicTaskExecutorClientDelegator;
        }
        return this.physicalTaskExecutorClientDelegator;
    }
}

