/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.server.master.engine.task.runnable;

import java.util.Date;
import org.apache.dolphinscheduler.common.enums.Flag;
import org.apache.dolphinscheduler.dao.entity.TaskInstance;
import org.apache.dolphinscheduler.dao.repository.TaskInstanceDao;
import org.apache.dolphinscheduler.plugin.task.api.enums.TaskExecutionStatus;
import org.apache.dolphinscheduler.server.master.engine.task.runnable.AbstractTaskInstanceFactory;
import org.apache.dolphinscheduler.server.master.engine.task.runnable.ITaskInstanceFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

@Component
public class RetryTaskInstanceFactory
extends AbstractTaskInstanceFactory<RetryTaskInstanceBuilder> {
    @Autowired
    private TaskInstanceDao taskInstanceDao;

    @Override
    public RetryTaskInstanceBuilder builder() {
        return new RetryTaskInstanceBuilder(this);
    }

    @Override
    @Transactional
    public TaskInstance createTaskInstance(RetryTaskInstanceBuilder builder) {
        TaskInstance needRetryTaskInstance = builder.taskInstance;
        TaskInstance taskInstance = this.cloneTaskInstance(needRetryTaskInstance);
        taskInstance.setId(null);
        taskInstance.setState(TaskExecutionStatus.SUBMITTED_SUCCESS);
        taskInstance.setPid(0);
        taskInstance.setHost(null);
        taskInstance.setExecutePath(null);
        taskInstance.setLogPath(null);
        taskInstance.setStartTime(null);
        taskInstance.setEndTime(null);
        taskInstance.setSubmitTime(new Date());
        taskInstance.setRetryTimes(taskInstance.getRetryTimes() + 1);
        this.taskInstanceDao.insert((Object)taskInstance);
        needRetryTaskInstance.setFlag(Flag.NO);
        this.taskInstanceDao.updateById((Object)needRetryTaskInstance);
        return taskInstance;
    }

    public static class RetryTaskInstanceBuilder
    implements ITaskInstanceFactory.ITaskInstanceBuilder {
        private final RetryTaskInstanceFactory retryTaskInstanceFactory;
        private TaskInstance taskInstance;

        public RetryTaskInstanceBuilder(RetryTaskInstanceFactory retryTaskInstanceFactory) {
            this.retryTaskInstanceFactory = retryTaskInstanceFactory;
        }

        public RetryTaskInstanceBuilder withTaskInstance(TaskInstance taskInstance) {
            this.taskInstance = taskInstance;
            return this;
        }

        @Override
        public TaskInstance build() {
            return this.retryTaskInstanceFactory.createTaskInstance(this);
        }
    }
}

