/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.dns.fluent.models;

import com.azure.core.management.SubResource;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.dns.models.ARecord;
import com.azure.resourcemanager.dns.models.AaaaRecord;
import com.azure.resourcemanager.dns.models.CaaRecord;
import com.azure.resourcemanager.dns.models.CnameRecord;
import com.azure.resourcemanager.dns.models.MxRecord;
import com.azure.resourcemanager.dns.models.NsRecord;
import com.azure.resourcemanager.dns.models.PtrRecord;
import com.azure.resourcemanager.dns.models.SoaRecord;
import com.azure.resourcemanager.dns.models.SrvRecord;
import com.azure.resourcemanager.dns.models.TxtRecord;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;
import java.util.Map;

public final class RecordSetProperties {
    @JsonIgnore
    private final ClientLogger logger = new ClientLogger(RecordSetProperties.class);
    @JsonProperty(value="metadata")
    @JsonInclude(value=JsonInclude.Include.NON_NULL, content=JsonInclude.Include.ALWAYS)
    private Map<String, String> metadata;
    @JsonProperty(value="TTL")
    private Long ttl;
    @JsonProperty(value="fqdn", access=JsonProperty.Access.WRITE_ONLY)
    private String fqdn;
    @JsonProperty(value="provisioningState", access=JsonProperty.Access.WRITE_ONLY)
    private String provisioningState;
    @JsonProperty(value="targetResource")
    private SubResource targetResource;
    @JsonProperty(value="ARecords")
    private List<ARecord> aRecords;
    @JsonProperty(value="AAAARecords")
    private List<AaaaRecord> aaaaRecords;
    @JsonProperty(value="MXRecords")
    private List<MxRecord> mxRecords;
    @JsonProperty(value="NSRecords")
    private List<NsRecord> nsRecords;
    @JsonProperty(value="PTRRecords")
    private List<PtrRecord> ptrRecords;
    @JsonProperty(value="SRVRecords")
    private List<SrvRecord> srvRecords;
    @JsonProperty(value="TXTRecords")
    private List<TxtRecord> txtRecords;
    @JsonProperty(value="CNAMERecord")
    private CnameRecord cnameRecord;
    @JsonProperty(value="SOARecord")
    private SoaRecord soaRecord;
    @JsonProperty(value="caaRecords")
    private List<CaaRecord> caaRecords;

    public Map<String, String> metadata() {
        return this.metadata;
    }

    public RecordSetProperties withMetadata(Map<String, String> metadata) {
        this.metadata = metadata;
        return this;
    }

    public Long ttl() {
        return this.ttl;
    }

    public RecordSetProperties withTtl(Long ttl) {
        this.ttl = ttl;
        return this;
    }

    public String fqdn() {
        return this.fqdn;
    }

    public String provisioningState() {
        return this.provisioningState;
    }

    public SubResource targetResource() {
        return this.targetResource;
    }

    public RecordSetProperties withTargetResource(SubResource targetResource) {
        this.targetResource = targetResource;
        return this;
    }

    public List<ARecord> aRecords() {
        return this.aRecords;
    }

    public RecordSetProperties withARecords(List<ARecord> aRecords) {
        this.aRecords = aRecords;
        return this;
    }

    public List<AaaaRecord> aaaaRecords() {
        return this.aaaaRecords;
    }

    public RecordSetProperties withAaaaRecords(List<AaaaRecord> aaaaRecords) {
        this.aaaaRecords = aaaaRecords;
        return this;
    }

    public List<MxRecord> mxRecords() {
        return this.mxRecords;
    }

    public RecordSetProperties withMxRecords(List<MxRecord> mxRecords) {
        this.mxRecords = mxRecords;
        return this;
    }

    public List<NsRecord> nsRecords() {
        return this.nsRecords;
    }

    public RecordSetProperties withNsRecords(List<NsRecord> nsRecords) {
        this.nsRecords = nsRecords;
        return this;
    }

    public List<PtrRecord> ptrRecords() {
        return this.ptrRecords;
    }

    public RecordSetProperties withPtrRecords(List<PtrRecord> ptrRecords) {
        this.ptrRecords = ptrRecords;
        return this;
    }

    public List<SrvRecord> srvRecords() {
        return this.srvRecords;
    }

    public RecordSetProperties withSrvRecords(List<SrvRecord> srvRecords) {
        this.srvRecords = srvRecords;
        return this;
    }

    public List<TxtRecord> txtRecords() {
        return this.txtRecords;
    }

    public RecordSetProperties withTxtRecords(List<TxtRecord> txtRecords) {
        this.txtRecords = txtRecords;
        return this;
    }

    public CnameRecord cnameRecord() {
        return this.cnameRecord;
    }

    public RecordSetProperties withCnameRecord(CnameRecord cnameRecord) {
        this.cnameRecord = cnameRecord;
        return this;
    }

    public SoaRecord soaRecord() {
        return this.soaRecord;
    }

    public RecordSetProperties withSoaRecord(SoaRecord soaRecord) {
        this.soaRecord = soaRecord;
        return this;
    }

    public List<CaaRecord> caaRecords() {
        return this.caaRecords;
    }

    public RecordSetProperties withCaaRecords(List<CaaRecord> caaRecords) {
        this.caaRecords = caaRecords;
        return this;
    }

    public void validate() {
        if (this.aRecords() != null) {
            this.aRecords().forEach(e -> e.validate());
        }
        if (this.aaaaRecords() != null) {
            this.aaaaRecords().forEach(e -> e.validate());
        }
        if (this.mxRecords() != null) {
            this.mxRecords().forEach(e -> e.validate());
        }
        if (this.nsRecords() != null) {
            this.nsRecords().forEach(e -> e.validate());
        }
        if (this.ptrRecords() != null) {
            this.ptrRecords().forEach(e -> e.validate());
        }
        if (this.srvRecords() != null) {
            this.srvRecords().forEach(e -> e.validate());
        }
        if (this.txtRecords() != null) {
            this.txtRecords().forEach(e -> e.validate());
        }
        if (this.cnameRecord() != null) {
            this.cnameRecord().validate();
        }
        if (this.soaRecord() != null) {
            this.soaRecord().validate();
        }
        if (this.caaRecords() != null) {
            this.caaRecords().forEach(e -> e.validate());
        }
    }
}

