/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.openapi.models;

import io.kubernetes.client.fluent.BaseFluent;
import io.kubernetes.client.fluent.Nested;
import io.kubernetes.client.openapi.models.V1ObjectMeta;
import io.kubernetes.client.openapi.models.V1ObjectMetaBuilder;
import io.kubernetes.client.openapi.models.V1ObjectMetaFluentImpl;
import io.kubernetes.client.openapi.models.V1ResourceQuota;
import io.kubernetes.client.openapi.models.V1ResourceQuotaFluent;
import io.kubernetes.client.openapi.models.V1ResourceQuotaSpec;
import io.kubernetes.client.openapi.models.V1ResourceQuotaSpecBuilder;
import io.kubernetes.client.openapi.models.V1ResourceQuotaSpecFluentImpl;
import io.kubernetes.client.openapi.models.V1ResourceQuotaStatus;
import io.kubernetes.client.openapi.models.V1ResourceQuotaStatusBuilder;
import io.kubernetes.client.openapi.models.V1ResourceQuotaStatusFluentImpl;
import java.util.Objects;

public class V1ResourceQuotaFluentImpl<A extends V1ResourceQuotaFluent<A>>
extends BaseFluent<A>
implements V1ResourceQuotaFluent<A> {
    private String apiVersion;
    private String kind;
    private V1ObjectMetaBuilder metadata;
    private V1ResourceQuotaSpecBuilder spec;
    private V1ResourceQuotaStatusBuilder status;

    public V1ResourceQuotaFluentImpl() {
    }

    public V1ResourceQuotaFluentImpl(V1ResourceQuota instance) {
        this.withApiVersion(instance.getApiVersion());
        this.withKind(instance.getKind());
        this.withMetadata(instance.getMetadata());
        this.withSpec(instance.getSpec());
        this.withStatus(instance.getStatus());
    }

    @Override
    public String getApiVersion() {
        return this.apiVersion;
    }

    @Override
    public A withApiVersion(String apiVersion) {
        this.apiVersion = apiVersion;
        return (A)this;
    }

    @Override
    public Boolean hasApiVersion() {
        return this.apiVersion != null;
    }

    @Override
    @Deprecated
    public A withNewApiVersion(String original) {
        return this.withApiVersion(new String(original));
    }

    @Override
    public String getKind() {
        return this.kind;
    }

    @Override
    public A withKind(String kind) {
        this.kind = kind;
        return (A)this;
    }

    @Override
    public Boolean hasKind() {
        return this.kind != null;
    }

    @Override
    @Deprecated
    public A withNewKind(String original) {
        return this.withKind(new String(original));
    }

    @Override
    @Deprecated
    public V1ObjectMeta getMetadata() {
        return this.metadata != null ? this.metadata.build() : null;
    }

    @Override
    public V1ObjectMeta buildMetadata() {
        return this.metadata != null ? this.metadata.build() : null;
    }

    @Override
    public A withMetadata(V1ObjectMeta metadata) {
        this._visitables.get("metadata").remove(this.metadata);
        if (metadata != null) {
            this.metadata = new V1ObjectMetaBuilder(metadata);
            this._visitables.get("metadata").add(this.metadata);
        }
        return (A)this;
    }

    @Override
    public Boolean hasMetadata() {
        return this.metadata != null;
    }

    @Override
    public V1ResourceQuotaFluent.MetadataNested<A> withNewMetadata() {
        return new MetadataNestedImpl();
    }

    @Override
    public V1ResourceQuotaFluent.MetadataNested<A> withNewMetadataLike(V1ObjectMeta item) {
        return new MetadataNestedImpl(item);
    }

    @Override
    public V1ResourceQuotaFluent.MetadataNested<A> editMetadata() {
        return this.withNewMetadataLike(this.getMetadata());
    }

    @Override
    public V1ResourceQuotaFluent.MetadataNested<A> editOrNewMetadata() {
        return this.withNewMetadataLike(this.getMetadata() != null ? this.getMetadata() : new V1ObjectMetaBuilder().build());
    }

    @Override
    public V1ResourceQuotaFluent.MetadataNested<A> editOrNewMetadataLike(V1ObjectMeta item) {
        return this.withNewMetadataLike(this.getMetadata() != null ? this.getMetadata() : item);
    }

    @Override
    @Deprecated
    public V1ResourceQuotaSpec getSpec() {
        return this.spec != null ? this.spec.build() : null;
    }

    @Override
    public V1ResourceQuotaSpec buildSpec() {
        return this.spec != null ? this.spec.build() : null;
    }

    @Override
    public A withSpec(V1ResourceQuotaSpec spec) {
        this._visitables.get("spec").remove(this.spec);
        if (spec != null) {
            this.spec = new V1ResourceQuotaSpecBuilder(spec);
            this._visitables.get("spec").add(this.spec);
        }
        return (A)this;
    }

    @Override
    public Boolean hasSpec() {
        return this.spec != null;
    }

    @Override
    public V1ResourceQuotaFluent.SpecNested<A> withNewSpec() {
        return new SpecNestedImpl();
    }

    @Override
    public V1ResourceQuotaFluent.SpecNested<A> withNewSpecLike(V1ResourceQuotaSpec item) {
        return new SpecNestedImpl(item);
    }

    @Override
    public V1ResourceQuotaFluent.SpecNested<A> editSpec() {
        return this.withNewSpecLike(this.getSpec());
    }

    @Override
    public V1ResourceQuotaFluent.SpecNested<A> editOrNewSpec() {
        return this.withNewSpecLike(this.getSpec() != null ? this.getSpec() : new V1ResourceQuotaSpecBuilder().build());
    }

    @Override
    public V1ResourceQuotaFluent.SpecNested<A> editOrNewSpecLike(V1ResourceQuotaSpec item) {
        return this.withNewSpecLike(this.getSpec() != null ? this.getSpec() : item);
    }

    @Override
    @Deprecated
    public V1ResourceQuotaStatus getStatus() {
        return this.status != null ? this.status.build() : null;
    }

    @Override
    public V1ResourceQuotaStatus buildStatus() {
        return this.status != null ? this.status.build() : null;
    }

    @Override
    public A withStatus(V1ResourceQuotaStatus status) {
        this._visitables.get("status").remove(this.status);
        if (status != null) {
            this.status = new V1ResourceQuotaStatusBuilder(status);
            this._visitables.get("status").add(this.status);
        }
        return (A)this;
    }

    @Override
    public Boolean hasStatus() {
        return this.status != null;
    }

    @Override
    public V1ResourceQuotaFluent.StatusNested<A> withNewStatus() {
        return new StatusNestedImpl();
    }

    @Override
    public V1ResourceQuotaFluent.StatusNested<A> withNewStatusLike(V1ResourceQuotaStatus item) {
        return new StatusNestedImpl(item);
    }

    @Override
    public V1ResourceQuotaFluent.StatusNested<A> editStatus() {
        return this.withNewStatusLike(this.getStatus());
    }

    @Override
    public V1ResourceQuotaFluent.StatusNested<A> editOrNewStatus() {
        return this.withNewStatusLike(this.getStatus() != null ? this.getStatus() : new V1ResourceQuotaStatusBuilder().build());
    }

    @Override
    public V1ResourceQuotaFluent.StatusNested<A> editOrNewStatusLike(V1ResourceQuotaStatus item) {
        return this.withNewStatusLike(this.getStatus() != null ? this.getStatus() : item);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        V1ResourceQuotaFluentImpl that = (V1ResourceQuotaFluentImpl)o;
        if (this.apiVersion != null ? !this.apiVersion.equals(that.apiVersion) : that.apiVersion != null) {
            return false;
        }
        if (this.kind != null ? !this.kind.equals(that.kind) : that.kind != null) {
            return false;
        }
        if (this.metadata != null ? !this.metadata.equals(that.metadata) : that.metadata != null) {
            return false;
        }
        if (this.spec != null ? !this.spec.equals(that.spec) : that.spec != null) {
            return false;
        }
        return !(this.status != null ? !this.status.equals(that.status) : that.status != null);
    }

    public int hashCode() {
        return Objects.hash(this.apiVersion, this.kind, this.metadata, this.spec, this.status, super.hashCode());
    }

    public class StatusNestedImpl<N>
    extends V1ResourceQuotaStatusFluentImpl<V1ResourceQuotaFluent.StatusNested<N>>
    implements V1ResourceQuotaFluent.StatusNested<N>,
    Nested<N> {
        private final V1ResourceQuotaStatusBuilder builder;

        StatusNestedImpl(V1ResourceQuotaStatus item) {
            this.builder = new V1ResourceQuotaStatusBuilder(this, item);
        }

        StatusNestedImpl() {
            this.builder = new V1ResourceQuotaStatusBuilder(this);
        }

        @Override
        public N and() {
            return (N)V1ResourceQuotaFluentImpl.this.withStatus(this.builder.build());
        }

        @Override
        public N endStatus() {
            return this.and();
        }
    }

    public class SpecNestedImpl<N>
    extends V1ResourceQuotaSpecFluentImpl<V1ResourceQuotaFluent.SpecNested<N>>
    implements V1ResourceQuotaFluent.SpecNested<N>,
    Nested<N> {
        private final V1ResourceQuotaSpecBuilder builder;

        SpecNestedImpl(V1ResourceQuotaSpec item) {
            this.builder = new V1ResourceQuotaSpecBuilder(this, item);
        }

        SpecNestedImpl() {
            this.builder = new V1ResourceQuotaSpecBuilder(this);
        }

        @Override
        public N and() {
            return (N)V1ResourceQuotaFluentImpl.this.withSpec(this.builder.build());
        }

        @Override
        public N endSpec() {
            return this.and();
        }
    }

    public class MetadataNestedImpl<N>
    extends V1ObjectMetaFluentImpl<V1ResourceQuotaFluent.MetadataNested<N>>
    implements V1ResourceQuotaFluent.MetadataNested<N>,
    Nested<N> {
        private final V1ObjectMetaBuilder builder;

        MetadataNestedImpl(V1ObjectMeta item) {
            this.builder = new V1ObjectMetaBuilder(this, item);
        }

        MetadataNestedImpl() {
            this.builder = new V1ObjectMetaBuilder(this);
        }

        @Override
        public N and() {
            return (N)V1ResourceQuotaFluentImpl.this.withMetadata(this.builder.build());
        }

        @Override
        public N endMetadata() {
            return this.and();
        }
    }
}

