/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.openapi.models;

import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;

@ApiModel(description="ServerAddressByClientCIDR helps the client to determine the server address that they should use, depending on the clientCIDR that they match.")
public class V1ServerAddressByClientCIDR {
    public static final String SERIALIZED_NAME_CLIENT_C_I_D_R = "clientCIDR";
    @SerializedName(value="clientCIDR")
    private String clientCIDR;
    public static final String SERIALIZED_NAME_SERVER_ADDRESS = "serverAddress";
    @SerializedName(value="serverAddress")
    private String serverAddress;

    public V1ServerAddressByClientCIDR clientCIDR(String clientCIDR) {
        this.clientCIDR = clientCIDR;
        return this;
    }

    @ApiModelProperty(required=true, value="The CIDR with which clients can match their IP to figure out the server address that they should use.")
    public String getClientCIDR() {
        return this.clientCIDR;
    }

    public void setClientCIDR(String clientCIDR) {
        this.clientCIDR = clientCIDR;
    }

    public V1ServerAddressByClientCIDR serverAddress(String serverAddress) {
        this.serverAddress = serverAddress;
        return this;
    }

    @ApiModelProperty(required=true, value="Address of this server, suitable for a client that matches the above CIDR. This can be a hostname, hostname:port, IP or IP:port.")
    public String getServerAddress() {
        return this.serverAddress;
    }

    public void setServerAddress(String serverAddress) {
        this.serverAddress = serverAddress;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        V1ServerAddressByClientCIDR v1ServerAddressByClientCIDR = (V1ServerAddressByClientCIDR)o;
        return Objects.equals(this.clientCIDR, v1ServerAddressByClientCIDR.clientCIDR) && Objects.equals(this.serverAddress, v1ServerAddressByClientCIDR.serverAddress);
    }

    public int hashCode() {
        return Objects.hash(this.clientCIDR, this.serverAddress);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class V1ServerAddressByClientCIDR {\n");
        sb.append("    clientCIDR: ").append(this.toIndentedString(this.clientCIDR)).append("\n");
        sb.append("    serverAddress: ").append(this.toIndentedString(this.serverAddress)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

