/*
 * Decompiled with CFR 0.152.
 */
package io.github.bucket4j;

import io.github.bucket4j.Bandwidth;
import io.github.bucket4j.BucketExceptions;
import io.github.bucket4j.serialization.DeserializationAdapter;
import io.github.bucket4j.serialization.SerializationAdapter;
import io.github.bucket4j.serialization.SerializationHandle;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;

public final class BucketConfiguration
implements Serializable {
    private static final long serialVersionUID = 42L;
    private final Bandwidth[] bandwidths;
    public static final SerializationHandle<BucketConfiguration> SERIALIZATION_HANDLE = new SerializationHandle<BucketConfiguration>(){

        @Override
        public <S> BucketConfiguration deserialize(DeserializationAdapter<S> adapter, S input) throws IOException {
            int bandwidthAmount = adapter.readInt(input);
            ArrayList<Bandwidth> bandwidths = new ArrayList<Bandwidth>(bandwidthAmount);
            for (int ii = 0; ii < bandwidthAmount; ++ii) {
                Bandwidth bandwidth = adapter.readObject(input, Bandwidth.class);
                bandwidths.add(bandwidth);
            }
            return new BucketConfiguration(bandwidths);
        }

        @Override
        public <O> void serialize(SerializationAdapter<O> adapter, O output, BucketConfiguration configuration) throws IOException {
            adapter.writeInt(output, configuration.bandwidths.length);
            for (Bandwidth bandwidth : configuration.bandwidths) {
                adapter.writeObject(output, bandwidth);
            }
        }

        @Override
        public int getTypeId() {
            return 2;
        }

        @Override
        public Class<BucketConfiguration> getSerializedType() {
            return BucketConfiguration.class;
        }
    };

    public BucketConfiguration(List<Bandwidth> bandwidths) {
        int i;
        Objects.requireNonNull(bandwidths);
        if (bandwidths.isEmpty()) {
            throw BucketExceptions.restrictionsNotSpecified();
        }
        this.bandwidths = new Bandwidth[bandwidths.size()];
        for (i = 0; i < bandwidths.size(); ++i) {
            this.bandwidths[i] = Objects.requireNonNull(bandwidths.get(i));
        }
        for (i = 0; i < this.bandwidths.length; ++i) {
            if (this.bandwidths[i].getId() == Bandwidth.UNDEFINED_ID) continue;
            for (int j = i + 1; j < this.bandwidths.length; ++j) {
                if (!Objects.equals(this.bandwidths[i].getId(), this.bandwidths[j].getId())) continue;
                throw BucketExceptions.foundTwoBandwidthsWithSameId(i, j, this.bandwidths[i].getId());
            }
        }
    }

    public Bandwidth[] getBandwidths() {
        return this.bandwidths;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BucketConfiguration that = (BucketConfiguration)o;
        return Arrays.equals(this.bandwidths, that.bandwidths);
    }

    public int hashCode() {
        return Arrays.hashCode(this.bandwidths);
    }

    public String toString() {
        return "BucketConfiguration{bandwidths=" + Arrays.toString(this.bandwidths) + '}';
    }
}

