/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.spring.extended.manifests;

import io.kubernetes.client.common.KubernetesObject;
import io.kubernetes.client.extended.kubectl.Kubectl;
import io.kubernetes.client.extended.kubectl.exception.KubectlException;
import io.kubernetes.client.openapi.ApiClient;
import io.kubernetes.client.spring.extended.manifests.annotation.KubectlApply;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanCreationException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.beans.factory.ListableBeanFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.config.BeanPostProcessor;

public class KubernetesKubectlApplyProcessor
implements BeanPostProcessor,
BeanFactoryAware {
    private static final Logger log = LoggerFactory.getLogger(KubernetesKubectlApplyProcessor.class);
    private ListableBeanFactory beanFactory;
    @Autowired
    private ApiClient apiClient;

    public Object postProcessAfterInitialization(Object bean, String beanName) throws BeansException {
        if (!(bean instanceof KubernetesObject)) {
            return bean;
        }
        KubectlApply apply = (KubectlApply)this.beanFactory.findAnnotationOnBean(beanName, KubectlApply.class);
        if (apply == null) {
            return bean;
        }
        Class<?> apiTypeClass = bean.getClass();
        try {
            log.info("@KubectlApply ensuring resource upon bean {}", (Object)beanName);
            return this.apply(apiTypeClass, bean);
        }
        catch (KubectlException e) {
            log.error("Failed ensuring resource from @KubectlApply", (Throwable)e);
            throw new BeanCreationException("Failed ensuring resource from @KubectlApply", (Throwable)e);
        }
    }

    public <ApiType extends KubernetesObject> ApiType apply(Class<ApiType> apiTypeClass, Object obj) throws KubectlException {
        return (ApiType)((io.kubernetes.client.extended.kubectl.KubectlApply)Kubectl.apply(apiTypeClass).apiClient(this.apiClient)).resource((KubernetesObject)obj).execute();
    }

    public void setBeanFactory(BeanFactory beanFactory) throws BeansException {
        this.beanFactory = (ListableBeanFactory)beanFactory;
    }
}

