/*
 * Decompiled with CFR 0.152.
 */
package com.azure.storage.blob.specialized;

import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceClient;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.RequestConditions;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.SimpleResponse;
import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.logging.ClientLogger;
import com.azure.storage.blob.implementation.AzureBlobStorageImpl;
import com.azure.storage.blob.implementation.AzureBlobStorageImplBuilder;
import com.azure.storage.blob.implementation.models.BlobsAcquireLeaseHeaders;
import com.azure.storage.blob.implementation.models.BlobsBreakLeaseHeaders;
import com.azure.storage.blob.implementation.models.BlobsChangeLeaseHeaders;
import com.azure.storage.blob.implementation.models.BlobsRenewLeaseHeaders;
import com.azure.storage.blob.implementation.models.ContainersAcquireLeaseHeaders;
import com.azure.storage.blob.implementation.models.ContainersBreakLeaseHeaders;
import com.azure.storage.blob.implementation.models.ContainersChangeLeaseHeaders;
import com.azure.storage.blob.implementation.models.ContainersRenewLeaseHeaders;
import com.azure.storage.blob.implementation.util.ModelHelper;
import com.azure.storage.blob.models.BlobLeaseRequestConditions;
import com.azure.storage.blob.options.BlobAcquireLeaseOptions;
import com.azure.storage.blob.options.BlobBreakLeaseOptions;
import com.azure.storage.blob.options.BlobChangeLeaseOptions;
import com.azure.storage.blob.options.BlobReleaseLeaseOptions;
import com.azure.storage.blob.options.BlobRenewLeaseOptions;
import com.azure.storage.blob.specialized.BlobLeaseClientBuilder;
import com.azure.storage.common.implementation.StorageImplUtils;
import java.time.Duration;
import reactor.core.publisher.Mono;

@ServiceClient(builder=BlobLeaseClientBuilder.class, isAsync=true)
public final class BlobLeaseAsyncClient {
    private static final ClientLogger LOGGER = new ClientLogger(BlobLeaseAsyncClient.class);
    private final String containerName;
    private final String blobName;
    private final boolean isBlob;
    private final AzureBlobStorageImpl client;
    private final String accountName;
    private volatile String leaseId;

    BlobLeaseAsyncClient(HttpPipeline pipeline, String url, String containerName, String blobName, String leaseId, boolean isBlob, String accountName, String serviceVersion) {
        this.isBlob = isBlob;
        this.leaseId = leaseId;
        this.client = new AzureBlobStorageImplBuilder().pipeline(pipeline).url(url).version(serviceVersion).buildClient();
        this.accountName = accountName;
        this.containerName = containerName;
        this.blobName = blobName;
    }

    public String getResourceUrl() {
        if (this.isBlob) {
            return this.client.getUrl() + "/" + this.containerName + "/" + this.blobName;
        }
        return this.client.getUrl() + "/" + this.containerName;
    }

    public String getLeaseId() {
        return this.leaseId;
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<String> acquireLease(int durationInSeconds) {
        return this.acquireLeaseWithResponse(durationInSeconds, null).flatMap(FluxUtil::toMono);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<String>> acquireLeaseWithResponse(int durationInSeconds, RequestConditions modifiedRequestConditions) {
        return this.acquireLeaseWithResponse(new BlobAcquireLeaseOptions(durationInSeconds).setRequestConditions(ModelHelper.populateBlobLeaseRequestConditions(modifiedRequestConditions)));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<String>> acquireLeaseWithResponse(BlobAcquireLeaseOptions options) {
        try {
            return FluxUtil.withContext(context -> this.acquireLeaseWithResponse(options, (Context)context));
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)LOGGER, (RuntimeException)ex);
        }
    }

    Mono<Response<String>> acquireLeaseWithResponse(BlobAcquireLeaseOptions options, Context context) {
        StorageImplUtils.assertNotNull((String)"options", (Object)options);
        BlobLeaseRequestConditions requestConditions = options.getRequestConditions() == null ? new BlobLeaseRequestConditions() : options.getRequestConditions();
        context = context == null ? Context.NONE : context;
        Mono response = this.isBlob ? this.client.getBlobs().acquireLeaseWithResponseAsync(this.containerName, this.blobName, null, options.getDuration(), this.leaseId, requestConditions.getIfModifiedSince(), requestConditions.getIfUnmodifiedSince(), requestConditions.getIfMatch(), requestConditions.getIfNoneMatch(), requestConditions.getTagsConditions(), null, context.addData((Object)"az.namespace", (Object)"Microsoft.Storage")).map(rb -> new SimpleResponse((Response)rb, (Object)((BlobsAcquireLeaseHeaders)rb.getDeserializedHeaders()).getXMsLeaseId())) : this.client.getContainers().acquireLeaseWithResponseAsync(this.containerName, null, options.getDuration(), this.leaseId, requestConditions.getIfModifiedSince(), requestConditions.getIfUnmodifiedSince(), null, context).map(rb -> new SimpleResponse((Response)rb, (Object)((ContainersAcquireLeaseHeaders)rb.getDeserializedHeaders()).getXMsLeaseId()));
        response = response.doOnSuccess(r -> {
            this.leaseId = (String)r.getValue();
        });
        return response;
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<String> renewLease() {
        return this.renewLeaseWithResponse((RequestConditions)null).flatMap(FluxUtil::toMono);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<String>> renewLeaseWithResponse(RequestConditions modifiedRequestConditions) {
        return this.renewLeaseWithResponse(new BlobRenewLeaseOptions().setRequestConditions(ModelHelper.populateBlobLeaseRequestConditions(modifiedRequestConditions)));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<String>> renewLeaseWithResponse(BlobRenewLeaseOptions options) {
        try {
            return FluxUtil.withContext(context -> this.renewLeaseWithResponse(options, (Context)context));
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)LOGGER, (RuntimeException)ex);
        }
    }

    Mono<Response<String>> renewLeaseWithResponse(BlobRenewLeaseOptions options, Context context) {
        options = options == null ? new BlobRenewLeaseOptions() : options;
        BlobLeaseRequestConditions requestConditions = options.getRequestConditions() == null ? new BlobLeaseRequestConditions() : options.getRequestConditions();
        context = context == null ? Context.NONE : context;
        Mono response = this.isBlob ? this.client.getBlobs().renewLeaseWithResponseAsync(this.containerName, this.blobName, this.leaseId, null, requestConditions.getIfModifiedSince(), requestConditions.getIfUnmodifiedSince(), requestConditions.getIfMatch(), requestConditions.getIfNoneMatch(), requestConditions.getTagsConditions(), null, context.addData((Object)"az.namespace", (Object)"Microsoft.Storage")).map(rb -> new SimpleResponse((Response)rb, (Object)((BlobsRenewLeaseHeaders)rb.getDeserializedHeaders()).getXMsLeaseId())) : this.client.getContainers().renewLeaseWithResponseAsync(this.containerName, this.leaseId, null, requestConditions.getIfModifiedSince(), requestConditions.getIfUnmodifiedSince(), null, context.addData((Object)"az.namespace", (Object)"Microsoft.Storage")).map(rb -> new SimpleResponse((Response)rb, (Object)((ContainersRenewLeaseHeaders)rb.getDeserializedHeaders()).getXMsLeaseId()));
        response = response.doOnSuccess(r -> {
            this.leaseId = (String)r.getValue();
        });
        return response;
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> releaseLease() {
        return this.releaseLeaseWithResponse((RequestConditions)null).flatMap(FluxUtil::toMono);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> releaseLeaseWithResponse(RequestConditions modifiedRequestConditions) {
        return this.releaseLeaseWithResponse(new BlobReleaseLeaseOptions().setRequestConditions(ModelHelper.populateBlobLeaseRequestConditions(modifiedRequestConditions)));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> releaseLeaseWithResponse(BlobReleaseLeaseOptions options) {
        try {
            return FluxUtil.withContext(context -> this.releaseLeaseWithResponse(options, (Context)context));
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)LOGGER, (RuntimeException)ex);
        }
    }

    Mono<Response<Void>> releaseLeaseWithResponse(BlobReleaseLeaseOptions options, Context context) {
        options = options == null ? new BlobReleaseLeaseOptions() : options;
        BlobLeaseRequestConditions requestConditions = options.getRequestConditions() == null ? new BlobLeaseRequestConditions() : options.getRequestConditions();
        Context context2 = context = context == null ? Context.NONE : context;
        if (this.isBlob) {
            return this.client.getBlobs().releaseLeaseWithResponseAsync(this.containerName, this.blobName, this.leaseId, null, requestConditions.getIfModifiedSince(), requestConditions.getIfUnmodifiedSince(), requestConditions.getIfMatch(), requestConditions.getIfNoneMatch(), requestConditions.getTagsConditions(), null, context.addData((Object)"az.namespace", (Object)"Microsoft.Storage")).map(response -> new SimpleResponse((Response)response, null));
        }
        return this.client.getContainers().releaseLeaseWithResponseAsync(this.containerName, this.leaseId, null, requestConditions.getIfModifiedSince(), requestConditions.getIfUnmodifiedSince(), null, context.addData((Object)"az.namespace", (Object)"Microsoft.Storage")).map(response -> new SimpleResponse((Response)response, null));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Integer> breakLease() {
        return this.breakLeaseWithResponse((Integer)null, null).flatMap(FluxUtil::toMono);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Integer>> breakLeaseWithResponse(Integer breakPeriodInSeconds, RequestConditions modifiedRequestConditions) {
        return this.breakLeaseWithResponse(new BlobBreakLeaseOptions().setBreakPeriod(breakPeriodInSeconds == null ? null : Duration.ofSeconds(breakPeriodInSeconds.intValue())).setRequestConditions(ModelHelper.populateBlobLeaseRequestConditions(modifiedRequestConditions)));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Integer>> breakLeaseWithResponse(BlobBreakLeaseOptions options) {
        try {
            return FluxUtil.withContext(context -> this.breakLeaseWithResponse(options, (Context)context));
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)LOGGER, (RuntimeException)ex);
        }
    }

    Mono<Response<Integer>> breakLeaseWithResponse(BlobBreakLeaseOptions options, Context context) {
        Integer breakPeriod;
        options = options == null ? new BlobBreakLeaseOptions() : options;
        BlobLeaseRequestConditions requestConditions = options.getRequestConditions() == null ? new BlobLeaseRequestConditions() : options.getRequestConditions();
        context = context == null ? Context.NONE : context;
        Integer n = breakPeriod = options.getBreakPeriod() == null ? null : Integer.valueOf(Math.toIntExact(options.getBreakPeriod().getSeconds()));
        if (this.isBlob) {
            return this.client.getBlobs().breakLeaseWithResponseAsync(this.containerName, this.blobName, null, breakPeriod, requestConditions.getIfModifiedSince(), requestConditions.getIfUnmodifiedSince(), requestConditions.getIfMatch(), requestConditions.getIfNoneMatch(), requestConditions.getTagsConditions(), null, context.addData((Object)"az.namespace", (Object)"Microsoft.Storage")).map(rb -> new SimpleResponse((Response)rb, (Object)((BlobsBreakLeaseHeaders)rb.getDeserializedHeaders()).getXMsLeaseTime()));
        }
        return this.client.getContainers().breakLeaseWithResponseAsync(this.containerName, null, breakPeriod, requestConditions.getIfModifiedSince(), requestConditions.getIfUnmodifiedSince(), null, context).map(rb -> new SimpleResponse((Response)rb, (Object)((ContainersBreakLeaseHeaders)rb.getDeserializedHeaders()).getXMsLeaseTime()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<String> changeLease(String proposedId) {
        return this.changeLeaseWithResponse(proposedId, null).flatMap(FluxUtil::toMono);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<String>> changeLeaseWithResponse(String proposedId, RequestConditions modifiedRequestConditions) {
        return this.changeLeaseWithResponse(new BlobChangeLeaseOptions(proposedId).setRequestConditions(ModelHelper.populateBlobLeaseRequestConditions(modifiedRequestConditions)));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<String>> changeLeaseWithResponse(BlobChangeLeaseOptions options) {
        try {
            return FluxUtil.withContext(context -> this.changeLeaseWithResponse(options, (Context)context));
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)LOGGER, (RuntimeException)ex);
        }
    }

    Mono<Response<String>> changeLeaseWithResponse(BlobChangeLeaseOptions options, Context context) {
        StorageImplUtils.assertNotNull((String)"options", (Object)options);
        BlobLeaseRequestConditions requestConditions = options.getRequestConditions() == null ? new BlobLeaseRequestConditions() : options.getRequestConditions();
        context = context == null ? Context.NONE : context;
        Mono response = this.isBlob ? this.client.getBlobs().changeLeaseWithResponseAsync(this.containerName, this.blobName, this.leaseId, options.getProposedId(), null, requestConditions.getIfModifiedSince(), requestConditions.getIfUnmodifiedSince(), requestConditions.getIfMatch(), requestConditions.getIfNoneMatch(), requestConditions.getTagsConditions(), null, context.addData((Object)"az.namespace", (Object)"Microsoft.Storage")).map(rb -> new SimpleResponse((Response)rb, (Object)((BlobsChangeLeaseHeaders)rb.getDeserializedHeaders()).getXMsLeaseId())) : this.client.getContainers().changeLeaseWithResponseAsync(this.containerName, this.leaseId, options.getProposedId(), null, requestConditions.getIfModifiedSince(), requestConditions.getIfUnmodifiedSince(), null, context.addData((Object)"az.namespace", (Object)"Microsoft.Storage")).map(rb -> new SimpleResponse((Response)rb, (Object)((ContainersChangeLeaseHeaders)rb.getDeserializedHeaders()).getXMsLeaseId()));
        response = response.doOnSuccess(r -> {
            this.leaseId = (String)r.getValue();
        });
        return response;
    }

    public String getAccountName() {
        return this.accountName;
    }
}

