/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.openapi.models;

import io.kubernetes.client.fluent.BaseFluent;
import io.kubernetes.client.fluent.Nested;
import io.kubernetes.client.openapi.models.V1CustomResourceConversion;
import io.kubernetes.client.openapi.models.V1CustomResourceConversionBuilder;
import io.kubernetes.client.openapi.models.V1CustomResourceConversionFluentImpl;
import io.kubernetes.client.openapi.models.V1CustomResourceDefinitionNames;
import io.kubernetes.client.openapi.models.V1CustomResourceDefinitionNamesBuilder;
import io.kubernetes.client.openapi.models.V1CustomResourceDefinitionNamesFluentImpl;
import io.kubernetes.client.openapi.models.V1CustomResourceDefinitionSpec;
import io.kubernetes.client.openapi.models.V1CustomResourceDefinitionSpecFluent;
import io.kubernetes.client.openapi.models.V1CustomResourceDefinitionVersion;
import io.kubernetes.client.openapi.models.V1CustomResourceDefinitionVersionBuilder;
import io.kubernetes.client.openapi.models.V1CustomResourceDefinitionVersionFluentImpl;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;

public class V1CustomResourceDefinitionSpecFluentImpl<A extends V1CustomResourceDefinitionSpecFluent<A>>
extends BaseFluent<A>
implements V1CustomResourceDefinitionSpecFluent<A> {
    private V1CustomResourceConversionBuilder conversion;
    private String group;
    private V1CustomResourceDefinitionNamesBuilder names;
    private Boolean preserveUnknownFields;
    private String scope;
    private List<V1CustomResourceDefinitionVersionBuilder> versions;

    public V1CustomResourceDefinitionSpecFluentImpl() {
    }

    public V1CustomResourceDefinitionSpecFluentImpl(V1CustomResourceDefinitionSpec instance) {
        this.withConversion(instance.getConversion());
        this.withGroup(instance.getGroup());
        this.withNames(instance.getNames());
        this.withPreserveUnknownFields(instance.getPreserveUnknownFields());
        this.withScope(instance.getScope());
        this.withVersions(instance.getVersions());
    }

    @Override
    @Deprecated
    public V1CustomResourceConversion getConversion() {
        return this.conversion != null ? this.conversion.build() : null;
    }

    @Override
    public V1CustomResourceConversion buildConversion() {
        return this.conversion != null ? this.conversion.build() : null;
    }

    @Override
    public A withConversion(V1CustomResourceConversion conversion) {
        this._visitables.get("conversion").remove(this.conversion);
        if (conversion != null) {
            this.conversion = new V1CustomResourceConversionBuilder(conversion);
            this._visitables.get("conversion").add(this.conversion);
        }
        return (A)this;
    }

    @Override
    public Boolean hasConversion() {
        return this.conversion != null;
    }

    @Override
    public V1CustomResourceDefinitionSpecFluent.ConversionNested<A> withNewConversion() {
        return new ConversionNestedImpl();
    }

    @Override
    public V1CustomResourceDefinitionSpecFluent.ConversionNested<A> withNewConversionLike(V1CustomResourceConversion item) {
        return new ConversionNestedImpl(item);
    }

    @Override
    public V1CustomResourceDefinitionSpecFluent.ConversionNested<A> editConversion() {
        return this.withNewConversionLike(this.getConversion());
    }

    @Override
    public V1CustomResourceDefinitionSpecFluent.ConversionNested<A> editOrNewConversion() {
        return this.withNewConversionLike(this.getConversion() != null ? this.getConversion() : new V1CustomResourceConversionBuilder().build());
    }

    @Override
    public V1CustomResourceDefinitionSpecFluent.ConversionNested<A> editOrNewConversionLike(V1CustomResourceConversion item) {
        return this.withNewConversionLike(this.getConversion() != null ? this.getConversion() : item);
    }

    @Override
    public String getGroup() {
        return this.group;
    }

    @Override
    public A withGroup(String group) {
        this.group = group;
        return (A)this;
    }

    @Override
    public Boolean hasGroup() {
        return this.group != null;
    }

    @Override
    @Deprecated
    public A withNewGroup(String original) {
        return this.withGroup(new String(original));
    }

    @Override
    @Deprecated
    public V1CustomResourceDefinitionNames getNames() {
        return this.names != null ? this.names.build() : null;
    }

    @Override
    public V1CustomResourceDefinitionNames buildNames() {
        return this.names != null ? this.names.build() : null;
    }

    @Override
    public A withNames(V1CustomResourceDefinitionNames names) {
        this._visitables.get("names").remove(this.names);
        if (names != null) {
            this.names = new V1CustomResourceDefinitionNamesBuilder(names);
            this._visitables.get("names").add(this.names);
        }
        return (A)this;
    }

    @Override
    public Boolean hasNames() {
        return this.names != null;
    }

    @Override
    public V1CustomResourceDefinitionSpecFluent.NamesNested<A> withNewNames() {
        return new NamesNestedImpl();
    }

    @Override
    public V1CustomResourceDefinitionSpecFluent.NamesNested<A> withNewNamesLike(V1CustomResourceDefinitionNames item) {
        return new NamesNestedImpl(item);
    }

    @Override
    public V1CustomResourceDefinitionSpecFluent.NamesNested<A> editNames() {
        return this.withNewNamesLike(this.getNames());
    }

    @Override
    public V1CustomResourceDefinitionSpecFluent.NamesNested<A> editOrNewNames() {
        return this.withNewNamesLike(this.getNames() != null ? this.getNames() : new V1CustomResourceDefinitionNamesBuilder().build());
    }

    @Override
    public V1CustomResourceDefinitionSpecFluent.NamesNested<A> editOrNewNamesLike(V1CustomResourceDefinitionNames item) {
        return this.withNewNamesLike(this.getNames() != null ? this.getNames() : item);
    }

    @Override
    public Boolean getPreserveUnknownFields() {
        return this.preserveUnknownFields;
    }

    @Override
    public A withPreserveUnknownFields(Boolean preserveUnknownFields) {
        this.preserveUnknownFields = preserveUnknownFields;
        return (A)this;
    }

    @Override
    public Boolean hasPreserveUnknownFields() {
        return this.preserveUnknownFields != null;
    }

    @Override
    public String getScope() {
        return this.scope;
    }

    @Override
    public A withScope(String scope) {
        this.scope = scope;
        return (A)this;
    }

    @Override
    public Boolean hasScope() {
        return this.scope != null;
    }

    @Override
    @Deprecated
    public A withNewScope(String original) {
        return this.withScope(new String(original));
    }

    @Override
    public A addToVersions(int index, V1CustomResourceDefinitionVersion item) {
        if (this.versions == null) {
            this.versions = new ArrayList<V1CustomResourceDefinitionVersionBuilder>();
        }
        V1CustomResourceDefinitionVersionBuilder builder = new V1CustomResourceDefinitionVersionBuilder(item);
        this._visitables.get("versions").add(index >= 0 ? index : this._visitables.get("versions").size(), builder);
        this.versions.add(index >= 0 ? index : this.versions.size(), builder);
        return (A)this;
    }

    @Override
    public A setToVersions(int index, V1CustomResourceDefinitionVersion item) {
        if (this.versions == null) {
            this.versions = new ArrayList<V1CustomResourceDefinitionVersionBuilder>();
        }
        V1CustomResourceDefinitionVersionBuilder builder = new V1CustomResourceDefinitionVersionBuilder(item);
        if (index < 0 || index >= this._visitables.get("versions").size()) {
            this._visitables.get("versions").add(builder);
        } else {
            this._visitables.get("versions").set(index, builder);
        }
        if (index < 0 || index >= this.versions.size()) {
            this.versions.add(builder);
        } else {
            this.versions.set(index, builder);
        }
        return (A)this;
    }

    @Override
    public A addToVersions(V1CustomResourceDefinitionVersion ... items) {
        if (this.versions == null) {
            this.versions = new ArrayList<V1CustomResourceDefinitionVersionBuilder>();
        }
        for (V1CustomResourceDefinitionVersion item : items) {
            V1CustomResourceDefinitionVersionBuilder builder = new V1CustomResourceDefinitionVersionBuilder(item);
            this._visitables.get("versions").add(builder);
            this.versions.add(builder);
        }
        return (A)this;
    }

    @Override
    public A addAllToVersions(Collection<V1CustomResourceDefinitionVersion> items) {
        if (this.versions == null) {
            this.versions = new ArrayList<V1CustomResourceDefinitionVersionBuilder>();
        }
        for (V1CustomResourceDefinitionVersion item : items) {
            V1CustomResourceDefinitionVersionBuilder builder = new V1CustomResourceDefinitionVersionBuilder(item);
            this._visitables.get("versions").add(builder);
            this.versions.add(builder);
        }
        return (A)this;
    }

    @Override
    public A removeFromVersions(V1CustomResourceDefinitionVersion ... items) {
        for (V1CustomResourceDefinitionVersion item : items) {
            V1CustomResourceDefinitionVersionBuilder builder = new V1CustomResourceDefinitionVersionBuilder(item);
            this._visitables.get("versions").remove(builder);
            if (this.versions == null) continue;
            this.versions.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromVersions(Collection<V1CustomResourceDefinitionVersion> items) {
        for (V1CustomResourceDefinitionVersion item : items) {
            V1CustomResourceDefinitionVersionBuilder builder = new V1CustomResourceDefinitionVersionBuilder(item);
            this._visitables.get("versions").remove(builder);
            if (this.versions == null) continue;
            this.versions.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeMatchingFromVersions(Predicate<V1CustomResourceDefinitionVersionBuilder> predicate) {
        if (this.versions == null) {
            return (A)this;
        }
        Iterator<V1CustomResourceDefinitionVersionBuilder> each = this.versions.iterator();
        Object visitables = this._visitables.get("versions");
        while (each.hasNext()) {
            V1CustomResourceDefinitionVersionBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    @Override
    @Deprecated
    public List<V1CustomResourceDefinitionVersion> getVersions() {
        return V1CustomResourceDefinitionSpecFluentImpl.build(this.versions);
    }

    @Override
    public List<V1CustomResourceDefinitionVersion> buildVersions() {
        return V1CustomResourceDefinitionSpecFluentImpl.build(this.versions);
    }

    @Override
    public V1CustomResourceDefinitionVersion buildVersion(int index) {
        return this.versions.get(index).build();
    }

    @Override
    public V1CustomResourceDefinitionVersion buildFirstVersion() {
        return this.versions.get(0).build();
    }

    @Override
    public V1CustomResourceDefinitionVersion buildLastVersion() {
        return this.versions.get(this.versions.size() - 1).build();
    }

    @Override
    public V1CustomResourceDefinitionVersion buildMatchingVersion(Predicate<V1CustomResourceDefinitionVersionBuilder> predicate) {
        for (V1CustomResourceDefinitionVersionBuilder item : this.versions) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    @Override
    public Boolean hasMatchingVersion(Predicate<V1CustomResourceDefinitionVersionBuilder> predicate) {
        for (V1CustomResourceDefinitionVersionBuilder item : this.versions) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withVersions(List<V1CustomResourceDefinitionVersion> versions) {
        if (this.versions != null) {
            this._visitables.get("versions").removeAll(this.versions);
        }
        if (versions != null) {
            this.versions = new ArrayList<V1CustomResourceDefinitionVersionBuilder>();
            for (V1CustomResourceDefinitionVersion item : versions) {
                this.addToVersions(item);
            }
        } else {
            this.versions = null;
        }
        return (A)this;
    }

    @Override
    public A withVersions(V1CustomResourceDefinitionVersion ... versions) {
        if (this.versions != null) {
            this.versions.clear();
        }
        if (versions != null) {
            for (V1CustomResourceDefinitionVersion item : versions) {
                this.addToVersions(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasVersions() {
        return this.versions != null && !this.versions.isEmpty();
    }

    @Override
    public V1CustomResourceDefinitionSpecFluent.VersionsNested<A> addNewVersion() {
        return new VersionsNestedImpl();
    }

    @Override
    public V1CustomResourceDefinitionSpecFluent.VersionsNested<A> addNewVersionLike(V1CustomResourceDefinitionVersion item) {
        return new VersionsNestedImpl(-1, item);
    }

    @Override
    public V1CustomResourceDefinitionSpecFluent.VersionsNested<A> setNewVersionLike(int index, V1CustomResourceDefinitionVersion item) {
        return new VersionsNestedImpl(index, item);
    }

    @Override
    public V1CustomResourceDefinitionSpecFluent.VersionsNested<A> editVersion(int index) {
        if (this.versions.size() <= index) {
            throw new RuntimeException("Can't edit versions. Index exceeds size.");
        }
        return this.setNewVersionLike(index, this.buildVersion(index));
    }

    @Override
    public V1CustomResourceDefinitionSpecFluent.VersionsNested<A> editFirstVersion() {
        if (this.versions.size() == 0) {
            throw new RuntimeException("Can't edit first versions. The list is empty.");
        }
        return this.setNewVersionLike(0, this.buildVersion(0));
    }

    @Override
    public V1CustomResourceDefinitionSpecFluent.VersionsNested<A> editLastVersion() {
        int index = this.versions.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last versions. The list is empty.");
        }
        return this.setNewVersionLike(index, this.buildVersion(index));
    }

    @Override
    public V1CustomResourceDefinitionSpecFluent.VersionsNested<A> editMatchingVersion(Predicate<V1CustomResourceDefinitionVersionBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.versions.size(); ++i) {
            if (!predicate.test(this.versions.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching versions. No match found.");
        }
        return this.setNewVersionLike(index, this.buildVersion(index));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        V1CustomResourceDefinitionSpecFluentImpl that = (V1CustomResourceDefinitionSpecFluentImpl)o;
        if (this.conversion != null ? !this.conversion.equals(that.conversion) : that.conversion != null) {
            return false;
        }
        if (this.group != null ? !this.group.equals(that.group) : that.group != null) {
            return false;
        }
        if (this.names != null ? !this.names.equals(that.names) : that.names != null) {
            return false;
        }
        if (this.preserveUnknownFields != null ? !this.preserveUnknownFields.equals(that.preserveUnknownFields) : that.preserveUnknownFields != null) {
            return false;
        }
        if (this.scope != null ? !this.scope.equals(that.scope) : that.scope != null) {
            return false;
        }
        return !(this.versions != null ? !this.versions.equals(that.versions) : that.versions != null);
    }

    public int hashCode() {
        return Objects.hash(this.conversion, this.group, this.names, this.preserveUnknownFields, this.scope, this.versions, super.hashCode());
    }

    public class VersionsNestedImpl<N>
    extends V1CustomResourceDefinitionVersionFluentImpl<V1CustomResourceDefinitionSpecFluent.VersionsNested<N>>
    implements V1CustomResourceDefinitionSpecFluent.VersionsNested<N>,
    Nested<N> {
        private final V1CustomResourceDefinitionVersionBuilder builder;
        private final int index;

        VersionsNestedImpl(int index, V1CustomResourceDefinitionVersion item) {
            this.index = index;
            this.builder = new V1CustomResourceDefinitionVersionBuilder(this, item);
        }

        VersionsNestedImpl() {
            this.index = -1;
            this.builder = new V1CustomResourceDefinitionVersionBuilder(this);
        }

        @Override
        public N and() {
            return (N)V1CustomResourceDefinitionSpecFluentImpl.this.setToVersions(this.index, this.builder.build());
        }

        @Override
        public N endVersion() {
            return this.and();
        }
    }

    public class NamesNestedImpl<N>
    extends V1CustomResourceDefinitionNamesFluentImpl<V1CustomResourceDefinitionSpecFluent.NamesNested<N>>
    implements V1CustomResourceDefinitionSpecFluent.NamesNested<N>,
    Nested<N> {
        private final V1CustomResourceDefinitionNamesBuilder builder;

        NamesNestedImpl(V1CustomResourceDefinitionNames item) {
            this.builder = new V1CustomResourceDefinitionNamesBuilder(this, item);
        }

        NamesNestedImpl() {
            this.builder = new V1CustomResourceDefinitionNamesBuilder(this);
        }

        @Override
        public N and() {
            return (N)V1CustomResourceDefinitionSpecFluentImpl.this.withNames(this.builder.build());
        }

        @Override
        public N endNames() {
            return this.and();
        }
    }

    public class ConversionNestedImpl<N>
    extends V1CustomResourceConversionFluentImpl<V1CustomResourceDefinitionSpecFluent.ConversionNested<N>>
    implements V1CustomResourceDefinitionSpecFluent.ConversionNested<N>,
    Nested<N> {
        private final V1CustomResourceConversionBuilder builder;

        ConversionNestedImpl(V1CustomResourceConversion item) {
            this.builder = new V1CustomResourceConversionBuilder(this, item);
        }

        ConversionNestedImpl() {
            this.builder = new V1CustomResourceConversionBuilder(this);
        }

        @Override
        public N and() {
            return (N)V1CustomResourceDefinitionSpecFluentImpl.this.withConversion(this.builder.build());
        }

        @Override
        public N endConversion() {
            return this.and();
        }
    }
}

