/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.servicebus.fluent.models;

import com.azure.core.management.Resource;
import com.azure.core.management.SystemData;
import com.azure.resourcemanager.servicebus.fluent.models.PrivateEndpointConnectionInner;
import com.azure.resourcemanager.servicebus.fluent.models.SBNamespaceProperties;
import com.azure.resourcemanager.servicebus.models.Encryption;
import com.azure.resourcemanager.servicebus.models.Identity;
import com.azure.resourcemanager.servicebus.models.SBSku;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.time.OffsetDateTime;
import java.util.List;
import java.util.Map;

public final class SBNamespaceInner
extends Resource {
    @JsonProperty(value="sku")
    private SBSku sku;
    @JsonProperty(value="identity")
    private Identity identity;
    @JsonProperty(value="systemData", access=JsonProperty.Access.WRITE_ONLY)
    private SystemData systemData;
    @JsonProperty(value="properties")
    private SBNamespaceProperties innerProperties;

    public SBSku sku() {
        return this.sku;
    }

    public SBNamespaceInner withSku(SBSku sku) {
        this.sku = sku;
        return this;
    }

    public Identity identity() {
        return this.identity;
    }

    public SBNamespaceInner withIdentity(Identity identity) {
        this.identity = identity;
        return this;
    }

    public SystemData systemData() {
        return this.systemData;
    }

    private SBNamespaceProperties innerProperties() {
        return this.innerProperties;
    }

    public SBNamespaceInner withLocation(String location) {
        super.withLocation(location);
        return this;
    }

    public SBNamespaceInner withTags(Map<String, String> tags) {
        super.withTags(tags);
        return this;
    }

    public String provisioningState() {
        return this.innerProperties() == null ? null : this.innerProperties().provisioningState();
    }

    public String status() {
        return this.innerProperties() == null ? null : this.innerProperties().status();
    }

    public OffsetDateTime createdAt() {
        return this.innerProperties() == null ? null : this.innerProperties().createdAt();
    }

    public OffsetDateTime updatedAt() {
        return this.innerProperties() == null ? null : this.innerProperties().updatedAt();
    }

    public String serviceBusEndpoint() {
        return this.innerProperties() == null ? null : this.innerProperties().serviceBusEndpoint();
    }

    public String metricId() {
        return this.innerProperties() == null ? null : this.innerProperties().metricId();
    }

    public Boolean zoneRedundant() {
        return this.innerProperties() == null ? null : this.innerProperties().zoneRedundant();
    }

    public SBNamespaceInner withZoneRedundant(Boolean zoneRedundant) {
        if (this.innerProperties() == null) {
            this.innerProperties = new SBNamespaceProperties();
        }
        this.innerProperties().withZoneRedundant(zoneRedundant);
        return this;
    }

    public Encryption encryption() {
        return this.innerProperties() == null ? null : this.innerProperties().encryption();
    }

    public SBNamespaceInner withEncryption(Encryption encryption) {
        if (this.innerProperties() == null) {
            this.innerProperties = new SBNamespaceProperties();
        }
        this.innerProperties().withEncryption(encryption);
        return this;
    }

    public List<PrivateEndpointConnectionInner> privateEndpointConnections() {
        return this.innerProperties() == null ? null : this.innerProperties().privateEndpointConnections();
    }

    public SBNamespaceInner withPrivateEndpointConnections(List<PrivateEndpointConnectionInner> privateEndpointConnections) {
        if (this.innerProperties() == null) {
            this.innerProperties = new SBNamespaceProperties();
        }
        this.innerProperties().withPrivateEndpointConnections(privateEndpointConnections);
        return this;
    }

    public Boolean disableLocalAuth() {
        return this.innerProperties() == null ? null : this.innerProperties().disableLocalAuth();
    }

    public SBNamespaceInner withDisableLocalAuth(Boolean disableLocalAuth) {
        if (this.innerProperties() == null) {
            this.innerProperties = new SBNamespaceProperties();
        }
        this.innerProperties().withDisableLocalAuth(disableLocalAuth);
        return this;
    }

    public String alternateName() {
        return this.innerProperties() == null ? null : this.innerProperties().alternateName();
    }

    public SBNamespaceInner withAlternateName(String alternateName) {
        if (this.innerProperties() == null) {
            this.innerProperties = new SBNamespaceProperties();
        }
        this.innerProperties().withAlternateName(alternateName);
        return this;
    }

    public void validate() {
        if (this.sku() != null) {
            this.sku().validate();
        }
        if (this.identity() != null) {
            this.identity().validate();
        }
        if (this.innerProperties() != null) {
            this.innerProperties().validate();
        }
    }
}

