/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.client.circuitbreaker;

import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;

public interface Customizer<TOCUSTOMIZE> {
    public void customize(TOCUSTOMIZE var1);

    public static <T, K> Customizer<T> once(Customizer<T> customizer, Function<? super T, ? extends K> keyMapper) {
        ConcurrentHashMap customized = new ConcurrentHashMap();
        return t -> {
            Object key = keyMapper.apply(t);
            customized.computeIfAbsent(key, k -> {
                customizer.customize(t);
                return true;
            });
        };
    }
}

