/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.dao.plugin.h2;

import com.baomidou.mybatisplus.annotation.DbType;
import javax.sql.DataSource;
import org.apache.dolphinscheduler.dao.plugin.api.DaoPluginConfiguration;
import org.apache.dolphinscheduler.dao.plugin.api.dialect.DatabaseDialect;
import org.apache.dolphinscheduler.dao.plugin.api.monitor.DatabaseMonitor;
import org.apache.dolphinscheduler.dao.plugin.h2.H2DatabaseEnvironmentCondition;
import org.apache.dolphinscheduler.dao.plugin.h2.dialect.H2Dialect;
import org.apache.dolphinscheduler.dao.plugin.h2.monitor.H2Monitor;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Conditional;
import org.springframework.context.annotation.Configuration;

@Conditional(value={H2DatabaseEnvironmentCondition.class})
@Configuration(proxyBeanMethods=false)
public class H2DaoPluginAutoConfiguration
implements DaoPluginConfiguration {
    @Autowired
    private DataSource dataSource;

    public DbType dbType() {
        return DbType.H2;
    }

    public DatabaseMonitor databaseMonitor() {
        return new H2Monitor(this.dataSource);
    }

    public DatabaseDialect databaseDialect() {
        return new H2Dialect();
    }
}

