/*
 * Decompiled with CFR 0.152.
 */
package com.qcloud.cos.internal;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.qcloud.cos.exception.CosServiceException;
import com.qcloud.cos.exception.CosServiceExceptionBuilder;
import com.qcloud.cos.http.CosHttpResponse;
import com.qcloud.cos.http.HttpMethodName;
import com.qcloud.cos.http.HttpResponseHandler;
import com.qcloud.cos.utils.IOUtils;
import com.qcloud.cos.utils.StringUtils;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CosErrorResponseHandler
implements HttpResponseHandler<CosServiceException> {
    private static final Logger log = LoggerFactory.getLogger(CosErrorResponseHandler.class);
    private static final XMLInputFactory xmlInputFactory = CosErrorResponseHandler.createXMLInputFactory();

    private static XMLInputFactory createXMLInputFactory() {
        XMLInputFactory inputFactory = XMLInputFactory.newInstance();
        inputFactory.setProperty("javax.xml.stream.supportDTD", false);
        inputFactory.setProperty("javax.xml.stream.isSupportingExternalEntities", false);
        return inputFactory;
    }

    private CosServiceException createExceptionFromHeaders(CosHttpResponse errorResponse, String errorResponseXml) {
        Map<String, String> headers = errorResponse.getHeaders();
        int statusCode = errorResponse.getStatusCode();
        CosServiceExceptionBuilder exceptionBuilder = new CosServiceExceptionBuilder();
        exceptionBuilder.setErrorMessage(errorResponse.getStatusText());
        exceptionBuilder.setErrorResponseXml(errorResponseXml);
        exceptionBuilder.setStatusCode(statusCode);
        exceptionBuilder.setTraceId(headers.get("x-cos-trace-id"));
        String requestId = headers.get("x-cos-request-id");
        exceptionBuilder.setErrorCode(statusCode + " " + errorResponse.getStatusText());
        if (requestId == null || requestId.isEmpty()) {
            requestId = headers.get("x-ci-request-id");
        }
        exceptionBuilder.setRequestId(requestId);
        return exceptionBuilder.build();
    }

    @Override
    public CosServiceException handle(CosHttpResponse httpResponse) throws XMLStreamException, IOException {
        InputStream is = httpResponse.getContent();
        Map<String, String> headers = httpResponse.getHeaders();
        if ("application/json".equalsIgnoreCase(headers.get("Content-Type"))) {
            return this.handleJsonErrorResponse(httpResponse, is);
        }
        return this.handleXmlErrorResponse(httpResponse, is);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CosServiceException handleXmlErrorResponse(CosHttpResponse httpResponse, InputStream is) throws XMLStreamException {
        XMLStreamReader reader;
        String xmlContent = null;
        if (is == null || httpResponse.getRequest().getHttpMethod() == HttpMethodName.HEAD) {
            return this.createExceptionFromHeaders(httpResponse, null);
        }
        String content = null;
        try {
            content = IOUtils.toString(is);
        }
        catch (IOException ioe) {
            log.debug("Failed in parsing the error response : ", (Throwable)ioe);
            return this.createExceptionFromHeaders(httpResponse, null);
        }
        XMLInputFactory xMLInputFactory = xmlInputFactory;
        synchronized (xMLInputFactory) {
            reader = xmlInputFactory.createXMLStreamReader(new ByteArrayInputStream(content.getBytes(StringUtils.UTF8)));
        }
        try {
            int targetDepth = 0;
            CosServiceExceptionBuilder exceptionBuilder = new CosServiceExceptionBuilder();
            exceptionBuilder.setErrorResponseXml(content);
            exceptionBuilder.setStatusCode(httpResponse.getStatusCode());
            boolean hasErrorTagVisited = false;
            block13: while (reader.hasNext()) {
                int event = reader.next();
                switch (event) {
                    case 1: {
                        String tagName = reader.getLocalName();
                        if (++targetDepth == 1 && !COSErrorTags.Error.toString().equals(tagName)) {
                            return this.createExceptionFromHeaders(httpResponse, "Unable to parse error response. Error XML Not in proper format." + content);
                        }
                        if (!COSErrorTags.Error.toString().equals(tagName)) continue block13;
                        hasErrorTagVisited = true;
                        continue block13;
                    }
                    case 4: {
                        xmlContent = reader.getText();
                        if (xmlContent == null) continue block13;
                        xmlContent = xmlContent.trim();
                        continue block13;
                    }
                    case 2: {
                        String tagName = reader.getLocalName();
                        if (!hasErrorTagVisited || --targetDepth > 1) {
                            return this.createExceptionFromHeaders(httpResponse, "Unable to parse error response. Error XML Not in proper format." + content);
                        }
                        if (COSErrorTags.Message.toString().equals(tagName)) {
                            exceptionBuilder.setErrorMessage(xmlContent);
                            continue block13;
                        }
                        if (COSErrorTags.Code.toString().equals(tagName)) {
                            exceptionBuilder.setErrorCode(xmlContent);
                            continue block13;
                        }
                        if (COSErrorTags.RequestId.toString().equals(tagName)) {
                            exceptionBuilder.setRequestId(xmlContent);
                            continue block13;
                        }
                        if (COSErrorTags.TraceId.toString().equals(tagName)) {
                            exceptionBuilder.setTraceId(xmlContent);
                            continue block13;
                        }
                        exceptionBuilder.addAdditionalDetail(tagName, xmlContent);
                        continue block13;
                    }
                    case 8: {
                        return exceptionBuilder.build();
                    }
                }
            }
        }
        catch (Exception e) {
            log.debug("Failed in parsing the error response : " + content, (Throwable)e);
        }
        return this.createExceptionFromHeaders(httpResponse, content);
    }

    private CosServiceException handleJsonErrorResponse(CosHttpResponse httpResponse, InputStream is) throws IOException {
        ObjectMapper objectMapper = new ObjectMapper();
        JsonNode jsonNode = objectMapper.readTree(is);
        if (jsonNode.has("Message")) {
            httpResponse.setStatusText(jsonNode.get("Message").asText());
        }
        return this.createExceptionFromHeaders(httpResponse, null);
    }

    @Override
    public boolean needsConnectionLeftOpen() {
        return false;
    }

    private static enum COSErrorTags {
        Error,
        Code,
        Message,
        Resource,
        RequestId,
        TraceId;

    }
}

