/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.tools.datasource.upgrader;

import com.baomidou.mybatisplus.annotation.DbType;
import java.io.FileNotFoundException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import javax.sql.DataSource;
import lombok.Generated;
import org.apache.dolphinscheduler.common.sql.SqlScriptRunner;
import org.apache.dolphinscheduler.dao.plugin.api.dialect.DatabaseDialect;
import org.apache.dolphinscheduler.tools.datasource.utils.SchemaUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class UpgradeDao {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(UpgradeDao.class);
    private static final String T_VERSION_NAME = "t_escheduler_version";
    private static final String T_NEW_VERSION_NAME = "t_ds_version";
    @Autowired
    private DataSource dataSource;
    @Autowired
    private DbType dbType;
    @Autowired
    private DatabaseDialect databaseDialect;

    public void initSchema() {
        String sqlFilePath = String.format("sql/dolphinscheduler_%s.sql", this.dbType.getDb());
        SqlScriptRunner sqlScriptRunner = new SqlScriptRunner(this.dataSource, sqlFilePath);
        try {
            sqlScriptRunner.execute();
            log.info("Success execute the sql initialize file: {}", (Object)sqlFilePath);
        }
        catch (Exception ex) {
            throw new RuntimeException("Execute initialize sql file: " + sqlFilePath + " error", ex);
        }
    }

    /*
     * Exception decompiling
     */
    public String getCurrentVersion(String versionName) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 5 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public void upgradeDolphinScheduler(String schemaDir) {
        this.upgradeDolphinSchedulerDDL(schemaDir, "dolphinscheduler_ddl.sql");
        this.upgradeDolphinSchedulerDML(schemaDir, "dolphinscheduler_dml.sql");
    }

    private void upgradeDolphinSchedulerDML(String schemaDir, String scriptFile) {
        String schemaVersion = schemaDir.split("_")[0];
        String sqlFilePath = String.format("sql/upgrade/%s/%s/%s", schemaDir, this.dbType.getDb(), scriptFile);
        try {
            SqlScriptRunner sqlScriptRunner = new SqlScriptRunner(this.dataSource, sqlFilePath);
            sqlScriptRunner.execute();
            try (Connection connection = this.dataSource.getConnection();){
                String upgradeSQL;
                if (this.databaseDialect.tableExists(T_VERSION_NAME)) {
                    upgradeSQL = String.format("update %s set version = ?", T_VERSION_NAME);
                } else if (this.databaseDialect.tableExists(T_NEW_VERSION_NAME)) {
                    upgradeSQL = String.format("update %s set version = ?", T_NEW_VERSION_NAME);
                } else {
                    throw new RuntimeException("The version table does not exist");
                }
                try (PreparedStatement pstmt = connection.prepareStatement(upgradeSQL);){
                    pstmt.setString(1, schemaVersion);
                    pstmt.executeUpdate();
                }
            }
            log.info("Success execute the dml file, schemaDir:  {}, ddlScript: {}", (Object)schemaDir, (Object)scriptFile);
        }
        catch (FileNotFoundException e) {
            log.error("Cannot find the DDL file, schemaDir:  {}, ddlScript: {}", new Object[]{schemaDir, scriptFile, e});
            throw new RuntimeException("sql file not found ", e);
        }
        catch (Exception e) {
            log.error("Execute ddl file failed, meet an unknown exception, schemaDir:  {}, ddlScript: {}", new Object[]{schemaDir, scriptFile, e});
            throw new RuntimeException("Execute ddl file failed, meet an unknown exception", e);
        }
    }

    public void upgradeDolphinSchedulerDDL(String schemaDir, String scriptFile) {
        String sqlFilePath = String.format("sql/upgrade/%s/%s/%s", schemaDir, this.dbType.getDb(), scriptFile);
        SqlScriptRunner sqlScriptRunner = new SqlScriptRunner(this.dataSource, sqlFilePath);
        try {
            sqlScriptRunner.execute();
            log.info("Success execute the ddl file, schemaDir:  {}, ddlScript: {}", (Object)schemaDir, (Object)scriptFile);
        }
        catch (FileNotFoundException e) {
            log.error("Cannot find the DDL file, schemaDir:  {}, ddlScript: {}", new Object[]{schemaDir, scriptFile, e});
            throw new RuntimeException("sql file not found ", e);
        }
        catch (Exception e) {
            log.error("Execute ddl file failed, meet an unknown exception, schemaDir:  {}, ddlScript: {}", new Object[]{schemaDir, scriptFile, e});
            throw new RuntimeException("Execute ddl file failed, meet an unknown exception", e);
        }
    }

    public void updateVersion(String version) {
        String versionName = T_VERSION_NAME;
        if (!SchemaUtils.isAGreatVersion("1.2.0", version)) {
            versionName = T_NEW_VERSION_NAME;
        }
        String upgradeSQL = String.format("update %s set version = ?", versionName);
        try (Connection conn = this.dataSource.getConnection();
             PreparedStatement pstmt = conn.prepareStatement(upgradeSQL);){
            pstmt.setString(1, version);
            pstmt.executeUpdate();
        }
        catch (SQLException e) {
            log.error("Update version error, sql: {}", (Object)upgradeSQL, (Object)e);
            throw new RuntimeException("Upgrade version error, sql: " + upgradeSQL, e);
        }
    }
}

