/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.server.master.engine;

import java.util.concurrent.atomic.AtomicInteger;
import lombok.Generated;
import org.apache.dolphinscheduler.eventbus.AbstractDelayEvent;
import org.apache.dolphinscheduler.eventbus.AbstractDelayEventBus;
import org.apache.dolphinscheduler.server.master.engine.AbstractLifecycleEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WorkflowEventBus
extends AbstractDelayEventBus<AbstractLifecycleEvent> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(WorkflowEventBus.class);
    private final WorkflowEventBusSummary workflowEventBusSummary = new WorkflowEventBusSummary();

    public void publish(AbstractLifecycleEvent event) {
        super.publish((AbstractDelayEvent)event);
        this.workflowEventBusSummary.increaseEventCount();
        log.info("Publish event: {}", (Object)event);
    }

    @Generated
    public WorkflowEventBusSummary getWorkflowEventBusSummary() {
        return this.workflowEventBusSummary;
    }

    public static final class WorkflowEventBusSummary {
        private AtomicInteger eventCount = new AtomicInteger();
        private AtomicInteger fireSuccessEventCount = new AtomicInteger();
        private AtomicInteger fireFailedEventCount = new AtomicInteger();

        public Integer increaseEventCount() {
            return this.eventCount.incrementAndGet();
        }

        public Integer increaseFireSuccessEventCount() {
            return this.fireSuccessEventCount.incrementAndGet();
        }

        public Integer decreaseFireSuccessEventCount() {
            return this.fireSuccessEventCount.decrementAndGet();
        }

        public Integer increaseFireFailedEventCount() {
            return this.fireFailedEventCount.incrementAndGet();
        }

        public String toString() {
            return "WorkflowEventBusSummary{eventCount=" + this.eventCount + ", fireSuccessEventCount=" + this.fireSuccessEventCount + ", fireFailedEventCount=" + this.fireFailedEventCount + '}';
        }

        @Generated
        public AtomicInteger getEventCount() {
            return this.eventCount;
        }

        @Generated
        public AtomicInteger getFireSuccessEventCount() {
            return this.fireSuccessEventCount;
        }

        @Generated
        public AtomicInteger getFireFailedEventCount() {
            return this.fireFailedEventCount;
        }

        @Generated
        public void setEventCount(AtomicInteger eventCount) {
            this.eventCount = eventCount;
        }

        @Generated
        public void setFireSuccessEventCount(AtomicInteger fireSuccessEventCount) {
            this.fireSuccessEventCount = fireSuccessEventCount;
        }

        @Generated
        public void setFireFailedEventCount(AtomicInteger fireFailedEventCount) {
            this.fireFailedEventCount = fireFailedEventCount;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof WorkflowEventBusSummary)) {
                return false;
            }
            WorkflowEventBusSummary other = (WorkflowEventBusSummary)o;
            AtomicInteger this$eventCount = this.getEventCount();
            AtomicInteger other$eventCount = other.getEventCount();
            if (this$eventCount == null ? other$eventCount != null : !this$eventCount.equals(other$eventCount)) {
                return false;
            }
            AtomicInteger this$fireSuccessEventCount = this.getFireSuccessEventCount();
            AtomicInteger other$fireSuccessEventCount = other.getFireSuccessEventCount();
            if (this$fireSuccessEventCount == null ? other$fireSuccessEventCount != null : !this$fireSuccessEventCount.equals(other$fireSuccessEventCount)) {
                return false;
            }
            AtomicInteger this$fireFailedEventCount = this.getFireFailedEventCount();
            AtomicInteger other$fireFailedEventCount = other.getFireFailedEventCount();
            return !(this$fireFailedEventCount == null ? other$fireFailedEventCount != null : !this$fireFailedEventCount.equals(other$fireFailedEventCount));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            AtomicInteger $eventCount = this.getEventCount();
            result = result * 59 + ($eventCount == null ? 43 : $eventCount.hashCode());
            AtomicInteger $fireSuccessEventCount = this.getFireSuccessEventCount();
            result = result * 59 + ($fireSuccessEventCount == null ? 43 : $fireSuccessEventCount.hashCode());
            AtomicInteger $fireFailedEventCount = this.getFireFailedEventCount();
            result = result * 59 + ($fireFailedEventCount == null ? 43 : $fireFailedEventCount.hashCode());
            return result;
        }

        @Generated
        public WorkflowEventBusSummary() {
        }
    }
}

