/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.server.master.engine.task.dispatcher.event;

import com.google.common.base.Preconditions;
import java.util.concurrent.Delayed;
import lombok.Generated;
import org.apache.dolphinscheduler.eventbus.AbstractDelayEvent;

public class TaskDispatchableEvent<V extends Comparable<V>>
extends AbstractDelayEvent {
    protected final V data;
    protected final int dispatchTimes;

    public TaskDispatchableEvent(long delayTimeMills, V data) {
        this(delayTimeMills, data, 0);
    }

    public TaskDispatchableEvent(long delayTimeMills, V data, int dispatchTimes) {
        super(delayTimeMills);
        this.data = (Comparable)Preconditions.checkNotNull(data, (Object)"data is null");
        this.dispatchTimes = dispatchTimes;
    }

    public int compareTo(Delayed other) {
        if (!(other instanceof TaskDispatchableEvent)) {
            throw new RuntimeException("The object being compared is not a TaskReadyForDispatchEvent.");
        }
        TaskDispatchableEvent otherEvent = (TaskDispatchableEvent)((Object)other);
        if (this.dispatchTimes > 0 && otherEvent.dispatchTimes > 0) {
            int priorityCompareResult = this.data.compareTo(otherEvent.data);
            if (priorityCompareResult != 0) {
                return priorityCompareResult;
            }
            return super.compareTo((Delayed)((Object)otherEvent));
        }
        int delayTimeCompareResult = super.compareTo((Delayed)((Object)otherEvent));
        if (delayTimeCompareResult != 0) {
            return delayTimeCompareResult;
        }
        return this.data.compareTo(otherEvent.data);
    }

    @Generated
    public V getData() {
        return this.data;
    }

    @Generated
    public int getDispatchTimes() {
        return this.dispatchTimes;
    }
}

