/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.datafactory.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.datafactory.models.ActivityDependency;
import com.azure.resourcemanager.datafactory.models.ControlActivity;
import com.azure.resourcemanager.datafactory.models.ExecuteWranglingDataflowActivity;
import com.azure.resourcemanager.datafactory.models.ExecutionActivity;
import com.azure.resourcemanager.datafactory.models.UserProperty;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.annotation.JsonTypeName;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY, property="type", defaultImpl=Activity.class)
@JsonTypeName(value="Activity")
@JsonSubTypes(value={@JsonSubTypes.Type(name="Container", value=ControlActivity.class), @JsonSubTypes.Type(name="Execution", value=ExecutionActivity.class), @JsonSubTypes.Type(name="ExecuteWranglingDataflow", value=ExecuteWranglingDataflowActivity.class)})
public class Activity {
    @JsonProperty(value="name", required=true)
    private String name;
    @JsonProperty(value="description")
    private String description;
    @JsonProperty(value="dependsOn")
    private List<ActivityDependency> dependsOn;
    @JsonProperty(value="userProperties")
    private List<UserProperty> userProperties;
    @JsonIgnore
    private Map<String, Object> additionalProperties;
    private static final ClientLogger LOGGER = new ClientLogger(Activity.class);

    public String name() {
        return this.name;
    }

    public Activity withName(String name) {
        this.name = name;
        return this;
    }

    public String description() {
        return this.description;
    }

    public Activity withDescription(String description) {
        this.description = description;
        return this;
    }

    public List<ActivityDependency> dependsOn() {
        return this.dependsOn;
    }

    public Activity withDependsOn(List<ActivityDependency> dependsOn) {
        this.dependsOn = dependsOn;
        return this;
    }

    public List<UserProperty> userProperties() {
        return this.userProperties;
    }

    public Activity withUserProperties(List<UserProperty> userProperties) {
        this.userProperties = userProperties;
        return this;
    }

    @JsonAnyGetter
    public Map<String, Object> additionalProperties() {
        return this.additionalProperties;
    }

    public Activity withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties;
        return this;
    }

    @JsonAnySetter
    void withAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null) {
            this.additionalProperties = new HashMap<String, Object>();
        }
        this.additionalProperties.put(key, value);
    }

    public void validate() {
        if (this.name() == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException("Missing required property name in model Activity"));
        }
        if (this.dependsOn() != null) {
            this.dependsOn().forEach(e -> e.validate());
        }
        if (this.userProperties() != null) {
            this.userProperties().forEach(e -> e.validate());
        }
    }
}

