/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.api.dto.workflow;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.Date;
import lombok.Generated;
import org.apache.dolphinscheduler.common.enums.ReleaseState;
import org.apache.dolphinscheduler.common.enums.WorkflowExecutionTypeEnum;
import org.apache.dolphinscheduler.common.utils.JSONUtils;
import org.apache.dolphinscheduler.dao.entity.WorkflowDefinition;

@JsonIgnoreProperties(ignoreUnknown=true)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class WorkflowUpdateRequest {
    @Schema(example="workflow's name")
    private String name;
    @Schema(example="workflow's description")
    private String description;
    @Schema(allowableValues={"ONLINE / OFFLINE"}, example="OFFLINE")
    private String releaseState;
    @Schema(example="[{\"prop\":\"key\",\"value\":\"value\",\"direct\":\"IN\",\"type\":\"VARCHAR\"}]")
    private String globalParams;
    @Schema(example="2")
    private int warningGroupId;
    @Schema(example="60")
    private int timeout;
    @Schema(allowableValues={"PARALLEL / SERIAL_WAIT / SERIAL_DISCARD / SERIAL_PRIORITY"}, example="PARALLEL", description="default PARALLEL if not provide.")
    private String executionType;
    @Schema(example="[{\\\"taskCode\\\":7009653961024,\\\"x\\\":312,\\\"y\\\":196}]")
    private String location;

    public WorkflowDefinition mergeIntoWorkflowDefinition(WorkflowDefinition workflowDefinition) {
        WorkflowDefinition workflowDefinitionDeepCopy = (WorkflowDefinition)JSONUtils.parseObject((String)JSONUtils.toJsonString((Object)workflowDefinition), WorkflowDefinition.class);
        assert (workflowDefinitionDeepCopy != null);
        if (this.name != null) {
            workflowDefinitionDeepCopy.setName(this.name);
        }
        if (this.description != null) {
            workflowDefinitionDeepCopy.setDescription(this.description);
        }
        if (this.releaseState != null) {
            workflowDefinitionDeepCopy.setReleaseState(ReleaseState.valueOf((String)this.releaseState));
        }
        if (this.globalParams != null) {
            workflowDefinitionDeepCopy.setGlobalParams(this.globalParams);
        }
        if (this.warningGroupId != 0) {
            workflowDefinitionDeepCopy.setWarningGroupId(Integer.valueOf(this.warningGroupId));
        }
        if (this.timeout != 0) {
            workflowDefinitionDeepCopy.setTimeout(this.timeout);
        }
        if (this.executionType != null) {
            workflowDefinitionDeepCopy.setExecutionType(WorkflowExecutionTypeEnum.valueOf((String)this.executionType));
        }
        if (this.location != null) {
            workflowDefinitionDeepCopy.setLocations(this.location);
        }
        workflowDefinitionDeepCopy.setUpdateTime(new Date());
        return workflowDefinitionDeepCopy;
    }

    @Generated
    public WorkflowUpdateRequest() {
    }

    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public String getDescription() {
        return this.description;
    }

    @Generated
    public String getReleaseState() {
        return this.releaseState;
    }

    @Generated
    public String getGlobalParams() {
        return this.globalParams;
    }

    @Generated
    public int getWarningGroupId() {
        return this.warningGroupId;
    }

    @Generated
    public int getTimeout() {
        return this.timeout;
    }

    @Generated
    public String getExecutionType() {
        return this.executionType;
    }

    @Generated
    public String getLocation() {
        return this.location;
    }

    @Generated
    public void setName(String name) {
        this.name = name;
    }

    @Generated
    public void setDescription(String description) {
        this.description = description;
    }

    @Generated
    public void setReleaseState(String releaseState) {
        this.releaseState = releaseState;
    }

    @Generated
    public void setGlobalParams(String globalParams) {
        this.globalParams = globalParams;
    }

    @Generated
    public void setWarningGroupId(int warningGroupId) {
        this.warningGroupId = warningGroupId;
    }

    @Generated
    public void setTimeout(int timeout) {
        this.timeout = timeout;
    }

    @Generated
    public void setExecutionType(String executionType) {
        this.executionType = executionType;
    }

    @Generated
    public void setLocation(String location) {
        this.location = location;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof WorkflowUpdateRequest)) {
            return false;
        }
        WorkflowUpdateRequest other = (WorkflowUpdateRequest)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getWarningGroupId() != other.getWarningGroupId()) {
            return false;
        }
        if (this.getTimeout() != other.getTimeout()) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        String this$description = this.getDescription();
        String other$description = other.getDescription();
        if (this$description == null ? other$description != null : !this$description.equals(other$description)) {
            return false;
        }
        String this$releaseState = this.getReleaseState();
        String other$releaseState = other.getReleaseState();
        if (this$releaseState == null ? other$releaseState != null : !this$releaseState.equals(other$releaseState)) {
            return false;
        }
        String this$globalParams = this.getGlobalParams();
        String other$globalParams = other.getGlobalParams();
        if (this$globalParams == null ? other$globalParams != null : !this$globalParams.equals(other$globalParams)) {
            return false;
        }
        String this$executionType = this.getExecutionType();
        String other$executionType = other.getExecutionType();
        if (this$executionType == null ? other$executionType != null : !this$executionType.equals(other$executionType)) {
            return false;
        }
        String this$location = this.getLocation();
        String other$location = other.getLocation();
        return !(this$location == null ? other$location != null : !this$location.equals(other$location));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof WorkflowUpdateRequest;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getWarningGroupId();
        result = result * 59 + this.getTimeout();
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        String $description = this.getDescription();
        result = result * 59 + ($description == null ? 43 : $description.hashCode());
        String $releaseState = this.getReleaseState();
        result = result * 59 + ($releaseState == null ? 43 : $releaseState.hashCode());
        String $globalParams = this.getGlobalParams();
        result = result * 59 + ($globalParams == null ? 43 : $globalParams.hashCode());
        String $executionType = this.getExecutionType();
        result = result * 59 + ($executionType == null ? 43 : $executionType.hashCode());
        String $location = this.getLocation();
        result = result * 59 + ($location == null ? 43 : $location.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "WorkflowUpdateRequest(name=" + this.getName() + ", description=" + this.getDescription() + ", releaseState=" + this.getReleaseState() + ", globalParams=" + this.getGlobalParams() + ", warningGroupId=" + this.getWarningGroupId() + ", timeout=" + this.getTimeout() + ", executionType=" + this.getExecutionType() + ", location=" + this.getLocation() + ")";
    }
}

