/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.api.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.google.common.base.Strings;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.dolphinscheduler.api.enums.Status;
import org.apache.dolphinscheduler.api.exceptions.ServiceException;
import org.apache.dolphinscheduler.api.service.WorkerGroupService;
import org.apache.dolphinscheduler.api.service.impl.BaseServiceImpl;
import org.apache.dolphinscheduler.api.utils.PageInfo;
import org.apache.dolphinscheduler.api.utils.Result;
import org.apache.dolphinscheduler.common.enums.AuthorizationType;
import org.apache.dolphinscheduler.common.enums.UserType;
import org.apache.dolphinscheduler.common.enums.WorkerGroupSource;
import org.apache.dolphinscheduler.common.enums.WorkflowExecutionStatus;
import org.apache.dolphinscheduler.common.model.Server;
import org.apache.dolphinscheduler.common.model.WorkerHeartBeat;
import org.apache.dolphinscheduler.common.utils.DateUtils;
import org.apache.dolphinscheduler.common.utils.JSONUtils;
import org.apache.dolphinscheduler.dao.entity.EnvironmentWorkerGroupRelation;
import org.apache.dolphinscheduler.dao.entity.Schedule;
import org.apache.dolphinscheduler.dao.entity.TaskDefinition;
import org.apache.dolphinscheduler.dao.entity.User;
import org.apache.dolphinscheduler.dao.entity.WorkerGroup;
import org.apache.dolphinscheduler.dao.entity.WorkerGroupPageDetail;
import org.apache.dolphinscheduler.dao.entity.WorkflowInstance;
import org.apache.dolphinscheduler.dao.mapper.EnvironmentWorkerGroupRelationMapper;
import org.apache.dolphinscheduler.dao.mapper.ScheduleMapper;
import org.apache.dolphinscheduler.dao.mapper.TaskDefinitionMapper;
import org.apache.dolphinscheduler.dao.mapper.WorkflowDefinitionMapper;
import org.apache.dolphinscheduler.dao.mapper.WorkflowInstanceMapper;
import org.apache.dolphinscheduler.dao.repository.WorkerGroupDao;
import org.apache.dolphinscheduler.extract.base.client.Clients;
import org.apache.dolphinscheduler.extract.master.IMasterContainerService;
import org.apache.dolphinscheduler.registry.api.RegistryClient;
import org.apache.dolphinscheduler.registry.api.enums.RegistryNodeType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.dao.DuplicateKeyException;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class WorkerGroupServiceImpl
extends BaseServiceImpl
implements WorkerGroupService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(WorkerGroupServiceImpl.class);
    @Autowired
    private WorkerGroupDao workerGroupDao;
    @Autowired
    private WorkflowInstanceMapper workflowInstanceMapper;
    @Autowired
    private RegistryClient registryClient;
    @Autowired
    private EnvironmentWorkerGroupRelationMapper environmentWorkerGroupRelationMapper;
    @Autowired
    private ScheduleMapper scheduleMapper;
    @Autowired
    private TaskDefinitionMapper taskDefinitionMapper;
    @Autowired
    private WorkflowDefinitionMapper workflowDefinitionMapper;

    @Override
    public WorkerGroup saveWorkerGroup(User loginUser, int id, String name, String addrList, String description) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        if (!this.canOperatorPermissions(loginUser, null, AuthorizationType.WORKER_GROUP, "security:worker-group:create")) {
            throw new ServiceException(Status.USER_NO_OPERATION_PERM);
        }
        if (StringUtils.isEmpty((CharSequence)name)) {
            throw new ServiceException(Status.NAME_NULL);
        }
        this.checkWorkerGroupAddrList(addrList);
        Date now = new Date();
        try {
            WorkerGroup workerGroup;
            if (id == 0) {
                workerGroup = new WorkerGroup();
                workerGroup.setCreateTime(now);
                workerGroup.setName(name);
                workerGroup.setAddrList(addrList);
                workerGroup.setUpdateTime(now);
                workerGroup.setDescription(description);
                this.workerGroupDao.insert((Object)workerGroup);
            } else {
                workerGroup = (WorkerGroup)this.workerGroupDao.queryById((Serializable)Integer.valueOf(id));
                if (workerGroup == null) {
                    throw new ServiceException(Status.WORKER_GROUP_NOT_EXIST, id);
                }
                if (!workerGroup.getName().equals(name)) {
                    this.checkWorkerGroupDependencies(workerGroup, result);
                }
                workerGroup.setName(name);
                workerGroup.setAddrList(addrList);
                workerGroup.setUpdateTime(now);
                workerGroup.setDescription(description);
                this.workerGroupDao.updateById((Object)workerGroup);
                log.info("Update worker group: {} success .", (Object)workerGroup);
            }
            this.boardCastToMasterThatWorkerGroupChanged();
            return workerGroup;
        }
        catch (DuplicateKeyException duplicateKeyException) {
            throw new ServiceException(Status.NAME_EXIST, name);
        }
    }

    private boolean checkWorkerGroupDependencies(WorkerGroup workerGroup, Map<String, Object> result) {
        List taskDefinitions = this.taskDefinitionMapper.selectList((Wrapper)new QueryWrapper().lambda().eq(TaskDefinition::getWorkerGroup, (Object)workerGroup.getName()));
        if (CollectionUtils.isNotEmpty((Collection)taskDefinitions)) {
            List taskNames = taskDefinitions.stream().limit(3L).map(taskDefinition -> taskDefinition.getName()).collect(Collectors.toList());
            this.putMsg(result, Status.WORKER_GROUP_DEPENDENT_TASK_EXISTS, taskDefinitions.size(), JSONUtils.toJsonString(taskNames));
            return true;
        }
        List schedules = this.scheduleMapper.selectList((Wrapper)new QueryWrapper().lambda().eq(Schedule::getWorkerGroup, (Object)workerGroup.getName()));
        if (CollectionUtils.isNotEmpty((Collection)schedules)) {
            List workflowDefinitionNames = schedules.stream().limit(3L).map(schedule -> this.workflowDefinitionMapper.queryByCode(schedule.getWorkflowDefinitionCode()).getName()).collect(Collectors.toList());
            this.putMsg(result, Status.WORKER_GROUP_DEPENDENT_SCHEDULER_EXISTS, schedules.size(), JSONUtils.toJsonString(workflowDefinitionNames));
            return true;
        }
        List environmentWorkerGroupRelations = this.environmentWorkerGroupRelationMapper.selectList((Wrapper)new QueryWrapper().lambda().eq(EnvironmentWorkerGroupRelation::getWorkerGroup, (Object)workerGroup.getName()));
        if (CollectionUtils.isNotEmpty((Collection)environmentWorkerGroupRelations)) {
            this.putMsg(result, Status.WORKER_GROUP_DEPENDENT_ENVIRONMENT_EXISTS, environmentWorkerGroupRelations.size());
            return true;
        }
        return false;
    }

    private void checkWorkerGroupAddrList(String workerGroupAddress) {
        if (Strings.isNullOrEmpty((String)workerGroupAddress)) {
            return;
        }
        Map serverMaps = this.registryClient.getServerMaps(RegistryNodeType.WORKER);
        for (String addr : workerGroupAddress.split(",")) {
            if (serverMaps.containsKey(addr)) continue;
            throw new ServiceException(Status.WORKER_ADDRESS_INVALID);
        }
    }

    @Override
    public Result queryAllGroupPaging(User loginUser, Integer pageNo, Integer pageSize, String searchVal) {
        Set ids;
        int fromIndex = (pageNo - 1) * pageSize;
        int toIndex = (pageNo - 1) * pageSize + pageSize;
        Result result = new Result();
        List<WorkerGroupPageDetail> workerGroupPageDetails = loginUser.getUserType().equals((Object)UserType.ADMIN_USER) ? this.getUiWorkerGroupPageDetails(null) : this.getUiWorkerGroupPageDetails((ids = this.resourcePermissionCheckService.userOwnedResourceIdsAcquisition(AuthorizationType.WORKER_GROUP, loginUser.getId(), log)).isEmpty() ? Collections.emptyList() : new ArrayList(ids));
        List<Object> resultDataList = new ArrayList();
        int total = 0;
        if (CollectionUtils.isNotEmpty(workerGroupPageDetails)) {
            List<Object> searchValDataList = new ArrayList();
            if (!StringUtils.isEmpty((CharSequence)searchVal)) {
                for (WorkerGroupPageDetail workerGroup : workerGroupPageDetails) {
                    if (!workerGroup.getName().contains(searchVal)) continue;
                    searchValDataList.add(workerGroup);
                }
            } else {
                searchValDataList = workerGroupPageDetails;
            }
            total = searchValDataList.size();
            if (fromIndex < searchValDataList.size()) {
                if (toIndex > searchValDataList.size()) {
                    toIndex = searchValDataList.size();
                }
                resultDataList = searchValDataList.subList(fromIndex, toIndex);
            }
        }
        List<WorkerGroupPageDetail> configWorkerGroupPageDetails = this.getConfigWorkerGroupPageDetail();
        configWorkerGroupPageDetails.addAll(resultDataList);
        PageInfo<WorkerGroupPageDetail> pageInfo = new PageInfo<WorkerGroupPageDetail>(pageNo, pageSize);
        pageInfo.setTotal(total);
        pageInfo.setTotalList(configWorkerGroupPageDetails);
        result.setData(pageInfo);
        this.putMsg(result, Status.SUCCESS, new Object[0]);
        return result;
    }

    @Override
    public Map<String, Object> queryAllGroup(User loginUser) {
        Set ids;
        HashMap<String, Object> result = new HashMap<String, Object>();
        List<WorkerGroupPageDetail> workerGroups = loginUser.getUserType().equals((Object)UserType.ADMIN_USER) ? this.getUiWorkerGroupPageDetails(null) : this.getUiWorkerGroupPageDetails((ids = this.resourcePermissionCheckService.userOwnedResourceIdsAcquisition(AuthorizationType.WORKER_GROUP, loginUser.getId(), log)).isEmpty() ? Collections.emptyList() : new ArrayList(ids));
        List configWorkerGroupNames = this.getConfigWorkerGroupPageDetail().stream().map(WorkerGroup::getName).collect(Collectors.toList());
        List availableWorkerGroupList = workerGroups.stream().map(WorkerGroup::getName).collect(Collectors.toList());
        availableWorkerGroupList.addAll(configWorkerGroupNames);
        result.put("data", availableWorkerGroupList.stream().distinct().collect(Collectors.toList()));
        this.putMsg(result, Status.SUCCESS, new Object[0]);
        return result;
    }

    private List<WorkerGroupPageDetail> getUiWorkerGroupPageDetails(List<Integer> ids) {
        List workerGroups = ids != null ? (ids.isEmpty() ? new ArrayList() : this.workerGroupDao.queryByIds(ids)) : this.workerGroupDao.queryAllWorkerGroup();
        return workerGroups.stream().map(workerGroup -> {
            WorkerGroupPageDetail workerGroupPageDetail = new WorkerGroupPageDetail(workerGroup);
            workerGroupPageDetail.setSource(WorkerGroupSource.UI);
            workerGroupPageDetail.setSystemDefault(false);
            return workerGroupPageDetail;
        }).collect(Collectors.toList());
    }

    @Override
    @Transactional
    public Map<String, Object> deleteWorkerGroupById(User loginUser, Integer id) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        if (!this.canOperatorPermissions(loginUser, null, AuthorizationType.WORKER_GROUP, "security:worker-group:delete")) {
            this.putMsg(result, Status.USER_NO_OPERATION_PERM, new Object[0]);
            return result;
        }
        WorkerGroup workerGroup = (WorkerGroup)this.workerGroupDao.queryById((Serializable)id);
        if (workerGroup == null) {
            log.error("Worker group does not exist, workerGroupId:{}.", (Object)id);
            this.putMsg(result, Status.DELETE_WORKER_GROUP_NOT_EXIST, new Object[0]);
            return result;
        }
        List workflowInstances = this.workflowInstanceMapper.queryByWorkerGroupNameAndStatus(workerGroup.getName(), WorkflowExecutionStatus.NOT_TERMINAL_STATES);
        if (CollectionUtils.isNotEmpty((Collection)workflowInstances)) {
            List workflowInstanceIds = workflowInstances.stream().map(WorkflowInstance::getId).collect(Collectors.toList());
            log.warn("Delete worker group failed because there are {} workflowInstances are using it, workflowInstanceIds:{}.", (Object)workflowInstances.size(), workflowInstanceIds);
            this.putMsg(result, Status.DELETE_WORKER_GROUP_BY_ID_FAIL, workflowInstances.size());
            return result;
        }
        if (this.checkWorkerGroupDependencies(workerGroup, result)) {
            return result;
        }
        this.workerGroupDao.deleteById((Serializable)id);
        this.boardCastToMasterThatWorkerGroupChanged();
        log.info("Delete worker group complete, workerGroupName:{}.", (Object)workerGroup.getName());
        this.putMsg(result, Status.SUCCESS, new Object[0]);
        return result;
    }

    @Override
    public Map<String, Object> getWorkerAddressList() {
        HashMap<String, Object> result = new HashMap<String, Object>();
        Set serverNodeList = this.registryClient.getServerNodeSet(RegistryNodeType.WORKER);
        result.put("data", serverNodeList);
        this.putMsg(result, Status.SUCCESS, new Object[0]);
        return result;
    }

    @Override
    public Map<Long, String> queryWorkerGroupByWorkflowDefinitionCodes(List<Long> workflowDefinitionCodeList) {
        List workflowDefinitionScheduleList = this.scheduleMapper.querySchedulesByWorkflowDefinitionCodes(workflowDefinitionCodeList);
        return workflowDefinitionScheduleList.stream().collect(Collectors.toMap(Schedule::getWorkflowDefinitionCode, Schedule::getWorkerGroup));
    }

    private void boardCastToMasterThatWorkerGroupChanged() {
        List masters = this.registryClient.getServerList(RegistryNodeType.MASTER);
        if (CollectionUtils.isEmpty((Collection)masters)) {
            return;
        }
        for (Server master : masters) {
            try {
                ((IMasterContainerService)Clients.withService(IMasterContainerService.class).withHost(master.getHost() + ":" + master.getPort())).refreshWorkerGroup();
            }
            catch (Exception e) {
                log.error("Broadcast to master: {} that worker group changed failed", (Object)master, (Object)e);
            }
        }
    }

    @Override
    public List<WorkerGroupPageDetail> getConfigWorkerGroupPageDetail() {
        ArrayList<WorkerGroupPageDetail> workerGroupPageDetails = new ArrayList<WorkerGroupPageDetail>();
        this.registryClient.getServerList(RegistryNodeType.WORKER).forEach(server -> {
            WorkerGroupPageDetail workerGroupPageDetail = new WorkerGroupPageDetail();
            WorkerHeartBeat workerHeartBeat = (WorkerHeartBeat)JSONUtils.parseObject((String)server.getHeartBeatInfo(), WorkerHeartBeat.class);
            workerGroupPageDetail.setName(workerHeartBeat.getWorkerGroup());
            workerGroupPageDetail.setAddrList(workerHeartBeat.getHost() + ":" + workerHeartBeat.getPort());
            workerGroupPageDetail.setSource(WorkerGroupSource.CONFIG);
            workerGroupPageDetail.setCreateTime(DateUtils.timeStampToDate((long)workerHeartBeat.getStartupTime()));
            workerGroupPageDetail.setUpdateTime(DateUtils.timeStampToDate((long)workerHeartBeat.getReportTime()));
            workerGroupPageDetail.setSystemDefault(true);
            workerGroupPageDetails.add(workerGroupPageDetail);
        });
        return workerGroupPageDetails;
    }
}

