/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.cdn.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.cdn.fluent.models.DeepCreatedOriginGroupProperties;
import com.azure.resourcemanager.cdn.models.HealthProbeParameters;
import com.azure.resourcemanager.cdn.models.ResourceReference;
import com.azure.resourcemanager.cdn.models.ResponseBasedOriginErrorDetectionParameters;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;

public final class DeepCreatedOriginGroup {
    @JsonProperty(value="name", required=true)
    private String name;
    @JsonProperty(value="properties")
    private DeepCreatedOriginGroupProperties innerProperties;
    private static final ClientLogger LOGGER = new ClientLogger(DeepCreatedOriginGroup.class);

    public String name() {
        return this.name;
    }

    public DeepCreatedOriginGroup withName(String name) {
        this.name = name;
        return this;
    }

    private DeepCreatedOriginGroupProperties innerProperties() {
        return this.innerProperties;
    }

    public HealthProbeParameters healthProbeSettings() {
        return this.innerProperties() == null ? null : this.innerProperties().healthProbeSettings();
    }

    public DeepCreatedOriginGroup withHealthProbeSettings(HealthProbeParameters healthProbeSettings) {
        if (this.innerProperties() == null) {
            this.innerProperties = new DeepCreatedOriginGroupProperties();
        }
        this.innerProperties().withHealthProbeSettings(healthProbeSettings);
        return this;
    }

    public List<ResourceReference> origins() {
        return this.innerProperties() == null ? null : this.innerProperties().origins();
    }

    public DeepCreatedOriginGroup withOrigins(List<ResourceReference> origins) {
        if (this.innerProperties() == null) {
            this.innerProperties = new DeepCreatedOriginGroupProperties();
        }
        this.innerProperties().withOrigins(origins);
        return this;
    }

    public Integer trafficRestorationTimeToHealedOrNewEndpointsInMinutes() {
        return this.innerProperties() == null ? null : this.innerProperties().trafficRestorationTimeToHealedOrNewEndpointsInMinutes();
    }

    public DeepCreatedOriginGroup withTrafficRestorationTimeToHealedOrNewEndpointsInMinutes(Integer trafficRestorationTimeToHealedOrNewEndpointsInMinutes) {
        if (this.innerProperties() == null) {
            this.innerProperties = new DeepCreatedOriginGroupProperties();
        }
        this.innerProperties().withTrafficRestorationTimeToHealedOrNewEndpointsInMinutes(trafficRestorationTimeToHealedOrNewEndpointsInMinutes);
        return this;
    }

    public ResponseBasedOriginErrorDetectionParameters responseBasedOriginErrorDetectionSettings() {
        return this.innerProperties() == null ? null : this.innerProperties().responseBasedOriginErrorDetectionSettings();
    }

    public DeepCreatedOriginGroup withResponseBasedOriginErrorDetectionSettings(ResponseBasedOriginErrorDetectionParameters responseBasedOriginErrorDetectionSettings) {
        if (this.innerProperties() == null) {
            this.innerProperties = new DeepCreatedOriginGroupProperties();
        }
        this.innerProperties().withResponseBasedOriginErrorDetectionSettings(responseBasedOriginErrorDetectionSettings);
        return this;
    }

    public void validate() {
        if (this.name() == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException("Missing required property name in model DeepCreatedOriginGroup"));
        }
        if (this.innerProperties() != null) {
            this.innerProperties().validate();
        }
    }
}

