/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.aop;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.util.Collections;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.api.records.ApplicationReport;
import org.apache.hadoop.yarn.api.records.ApplicationSubmissionContext;
import org.aspectj.lang.NoAspectBoundException;
import org.aspectj.lang.annotation.AfterReturning;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.runtime.internal.CFlowCounter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Aspect
public class YarnClientAspect {
    private ApplicationReport currentApplicationReport = null;
    private final String appInfoFilePath;
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    private static /* synthetic */ Throwable ajc$initFailureCause;
    public static /* synthetic */ YarnClientAspect ajc$perSingletonInstance;
    public static /* synthetic */ CFlowCounter ajc$cflowCounter$0;

    public YarnClientAspect() {
        this.appInfoFilePath = String.format("%s/%s", System.getProperty("user.dir"), "appInfo.log");
    }

    @AfterReturning(pointcut="execution(ApplicationId org.apache.hadoop.yarn.client.api.impl.YarnClientImpl.submitApplication(ApplicationSubmissionContext)) && args(appContext)", returning="submittedAppId", argNames="appContext,submittedAppId")
    public void registerApplicationInfo(ApplicationSubmissionContext appContext, ApplicationId submittedAppId) {
        if (this.appInfoFilePath != null) {
            try {
                Files.write(Paths.get(this.appInfoFilePath, new String[0]), Collections.singletonList(submittedAppId.toString()), StandardOpenOption.CREATE, StandardOpenOption.WRITE, StandardOpenOption.APPEND);
            }
            catch (IOException ioException) {
                this.logger.error("YarnClientAspect[registerAppInfo]: can't output current application information, because {}", (Object)ioException.getMessage());
            }
        }
        this.logger.info("YarnClientAspect[submitApplication]: current application context {}", (Object)appContext);
        this.logger.info("YarnClientAspect[submitApplication]: submitted application id {}", (Object)submittedAppId);
        this.logger.info("YarnClientAspect[submitApplication]: current application report {}", (Object)this.currentApplicationReport);
    }

    @AfterReturning(pointcut="cflow(execution(ApplicationId org.apache.hadoop.yarn.client.api.impl.YarnClientImpl.submitApplication(ApplicationSubmissionContext))) && !within(YarnClientAspect) && execution(ApplicationReport org.apache.hadoop.yarn.client.api.impl.YarnClientImpl.getApplicationReport(ApplicationId)) && args(appId)", returning="appReport", argNames="appReport,appId")
    public void registerApplicationReport(ApplicationReport appReport, ApplicationId appId) {
        this.currentApplicationReport = appReport;
    }

    public static YarnClientAspect aspectOf() {
        if (ajc$perSingletonInstance == null) {
            throw new NoAspectBoundException("org.apache.dolphinscheduler.aop.YarnClientAspect", ajc$initFailureCause);
        }
        return ajc$perSingletonInstance;
    }

    public static boolean hasAspect() {
        return ajc$perSingletonInstance != null;
    }

    static {
        YarnClientAspect.ajc$cflowCounter$0 = new CFlowCounter();
        try {
            YarnClientAspect.ajc$perSingletonInstance = new YarnClientAspect();
        }
        catch (Throwable throwable) {
            ajc$initFailureCause = throwable;
        }
    }
}

