/*
 * Decompiled with CFR 0.152.
 */
package com.azure.core.implementation.util;

import com.azure.core.util.CoreUtils;
import com.azure.core.util.logging.ClientLogger;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.function.Function;

public final class Providers<TProvider, TInstance> {
    private static final ClientLogger LOGGER = new ClientLogger(Providers.class);
    private final TProvider defaultProvider;
    private final Map<String, TProvider> availableProviders;
    private final String defaultImplementation;
    private final boolean noDefaultImplementation;
    private final String noProviderMessage;
    private final Class<TProvider> providerClass;

    public Providers(Class<TProvider> providerClass, String defaultImplementationName, String noProviderErrorMessage) {
        this.providerClass = providerClass;
        ServiceLoader<TProvider> serviceLoader = ServiceLoader.load(providerClass, Providers.class.getClassLoader());
        this.availableProviders = new HashMap<String, TProvider>();
        Iterator<TProvider> it = serviceLoader.iterator();
        if (it.hasNext()) {
            this.defaultProvider = it.next();
            String defaultProviderName = this.defaultProvider.getClass().getName();
            this.availableProviders.put(defaultProviderName, this.defaultProvider);
            LOGGER.verbose("Using {} as the default {}.", defaultProviderName, providerClass.getName());
        } else {
            this.defaultProvider = null;
        }
        while (it.hasNext()) {
            TProvider additionalProvider = it.next();
            String additionalProviderName = additionalProvider.getClass().getName();
            this.availableProviders.put(additionalProviderName, additionalProvider);
            LOGGER.verbose("Additional provider found on the classpath: {}", additionalProviderName);
        }
        this.defaultImplementation = defaultImplementationName;
        this.noDefaultImplementation = CoreUtils.isNullOrEmpty(this.defaultImplementation);
        this.noProviderMessage = noProviderErrorMessage;
    }

    private String formatNoSpecificProviderErrorMessage(String selectedImplementation) {
        return String.format("A request was made to use a specific %s but it wasn't found on the classpath. If you're using a dependency manager ensure you're including the dependency that provides the specific implementation. If you're including the specific implementation ensure that the %s service it supplies is being included in the 'META-INF/services' file '%s'. The requested provider was: %s.", this.providerClass.getSimpleName(), this.providerClass.getSimpleName(), this.providerClass.getName(), selectedImplementation);
    }

    public TInstance create(Function<TProvider, TInstance> createInstance, TInstance fallbackInstance, Class<? extends TProvider> selectedImplementation) {
        TProvider provider;
        if (selectedImplementation == null && this.noDefaultImplementation) {
            provider = this.defaultProvider;
            if (provider == null) {
                if (fallbackInstance == null) {
                    throw LOGGER.logExceptionAsError(new IllegalStateException(this.noProviderMessage));
                }
                return fallbackInstance;
            }
        } else {
            String implementationName = selectedImplementation == null ? this.defaultImplementation : selectedImplementation.getName();
            provider = this.availableProviders.get(implementationName);
            if (provider == null) {
                throw LOGGER.logExceptionAsError(new IllegalStateException(this.formatNoSpecificProviderErrorMessage(implementationName)));
            }
        }
        return createInstance.apply(provider);
    }
}

