// Licensed to the Apache Software Foundation (ASF) under one
// or more contributor license agreements.  See the NOTICE file
// distributed with this work for additional information
// regarding copyright ownership.  The ASF licenses this file
// to you under the Apache License, Version 2.0 (the
// "License"); you may not use this file except in compliance
// with the License.  You may obtain a copy of the License at
//
//   http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing,
// software distributed under the License is distributed on an
// "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
// KIND, either express or implied.  See the License for the
// specific language governing permissions and limitations
// under the License.

suite("rqg471923") {
    sql(
    """
    DROP TABLE IF EXISTS `table_200_undef_partitions2_keys3_properties4_distributed_by59`;
    """)
    sql("""
    create table table_200_undef_partitions2_keys3_properties4_distributed_by59 (
col_date_undef_signed_not_null date  not null  ,
col_bigint_undef_signed_not_null_index_inverted bigint  not null  ,
col_bigint_undef_signed_not_null bigint  not null  ,
col_int_undef_signed int  null  ,
col_int_undef_signed_index_inverted int  null  ,
col_int_undef_signed_not_null int  not null  ,
col_int_undef_signed_not_null_index_inverted int  not null  ,
col_bigint_undef_signed bigint  null  ,
col_bigint_undef_signed_index_inverted bigint  null  ,
col_date_undef_signed date  null  ,
col_date_undef_signed_index_inverted date  null  ,
col_date_undef_signed_not_null_index_inverted date  not null  ,
col_varchar_10__undef_signed varchar(10)  null  ,
col_varchar_10__undef_signed_index_inverted varchar(10)  null  ,
col_varchar_10__undef_signed_not_null varchar(10)  not null  ,
col_varchar_10__undef_signed_not_null_index_inverted varchar(10)  not null  ,
col_varchar_1024__undef_signed varchar(1024)  null  ,
col_varchar_1024__undef_signed_index_inverted varchar(1024)  null  ,
col_varchar_1024__undef_signed_not_null varchar(1024)  not null  ,
col_varchar_1024__undef_signed_not_null_index_inverted varchar(1024)  not null  ,
pk int,
INDEX col_int_undef_signed_index_inverted_idx (`col_int_undef_signed_index_inverted`) USING INVERTED,
INDEX col_int_undef_signed_not_null_index_inverted_idx (`col_int_undef_signed_not_null_index_inverted`) USING INVERTED,
INDEX col_bigint_undef_signed_index_inverted_idx (`col_bigint_undef_signed_index_inverted`) USING INVERTED,
INDEX col_bigint_undef_signed_not_null_index_inverted_idx (`col_bigint_undef_signed_not_null_index_inverted`) USING INVERTED,
INDEX col_date_undef_signed_index_inverted_idx (`col_date_undef_signed_index_inverted`) USING INVERTED,
INDEX col_date_undef_signed_not_null_index_inverted_idx (`col_date_undef_signed_not_null_index_inverted`) USING INVERTED,
INDEX col_varchar_10__undef_signed_index_inverted_idx (`col_varchar_10__undef_signed_index_inverted`) USING INVERTED,
INDEX col_varchar_10__undef_signed_not_null_index_inverted_idx (`col_varchar_10__undef_signed_not_null_index_inverted`) USING INVERTED,
INDEX col_varchar_1024__undef_signed_index_inverted_idx (`col_varchar_1024__undef_signed_index_inverted`) USING INVERTED,
INDEX col_varchar_1024__undef_signed_not_null_index_inverted_idx (`col_varchar_1024__undef_signed_not_null_index_inverted`) USING INVERTED
) engine=olap
UNIQUE KEY(col_date_undef_signed_not_null, col_bigint_undef_signed_not_null_index_inverted, col_bigint_undef_signed_not_null)
PARTITION BY             RANGE(col_date_undef_signed_not_null) (
                FROM ('2023-12-08') TO ('2024-01-01') INTERVAL 1 DAY,
                FROM ('2024-01-01') TO ('2024-12-01') INTERVAL 1 MONTH,
                FROM ('2025-01-01') TO ('2027-01-01') INTERVAL 1 YEAR,
                FROM ('2027-01-01') TO ('2032-01-01') INTERVAL 2 YEAR
            )
distributed by hash(col_bigint_undef_signed_not_null_index_inverted)
properties("enable_unique_key_merge_on_write" = "true", "replication_num" = "1");
""")
sql("""
insert into table_200_undef_partitions2_keys3_properties4_distributed_by59(pk,col_int_undef_signed,col_int_undef_signed_index_inverted,col_int_undef_signed_not_null,col_int_undef_signed_not_null_index_inverted,col_bigint_undef_signed,col_bigint_undef_signed_index_inverted,col_bigint_undef_signed_not_null,col_bigint_undef_signed_not_null_index_inverted,col_date_undef_signed,col_date_undef_signed_index_inverted,col_date_undef_signed_not_null,col_date_undef_signed_not_null_index_inverted,col_varchar_10__undef_signed,col_varchar_10__undef_signed_index_inverted,col_varchar_10__undef_signed_not_null,col_varchar_10__undef_signed_not_null_index_inverted,col_varchar_1024__undef_signed,col_varchar_1024__undef_signed_index_inverted,col_varchar_1024__undef_signed_not_null,col_varchar_1024__undef_signed_not_null_index_inverted) values (0,-4,2,1,8,null,-926948872988719647,-3112957786393412879,-6172058410833647054,'2023-12-12','2023-12-15','2023-12-14','2024-02-18','t','e','w','x','t','c','p','w'),(1,6,6,0,-10,7114896725648524085,null,-9212688746270440608,-6149312161046309303,'2026-02-18','2024-02-18','2024-02-18','2023-12-15','n','l','b','r',null,'c','l','t'),(2,-10,9,-4,-10,1247345885158069553,-5025600727365410244,-7543097674607927427,-8370232585511631372,'2023-12-13','2025-02-18','2023-12-09','2023-12-12','r','a','n','r','d','a','q','x'),(3,2,1,9,3,-659098779238202248,null,-267917365551937375,-3635997079212660878,'2023-12-10','2024-01-17','2023-12-14','2023-12-18',null,null,'w','d','h','x','r','i'),(4,-10,8,8,-4,1475232666229381313,1204751431519291560,2927068247087186614,8034618020178074667,'2023-12-10','2023-12-11','2023-12-16','2026-02-18',null,'v','t','v','f','g','q','a'),(5,3,5,8,5,2009143839330082031,null,-8418482911890805544,735308902011536919,'2025-02-17','2025-02-17','2023-12-16','2027-01-16','p','v','j','v','j','n','d','m'),(6,4,8,5,7,6030899932992646344,null,-7972291437649418237,8820585768388198630,null,'2023-12-19','2024-01-09','2023-12-19','k',null,'u','l',null,'c','f','q'),(7,7,-10,-4,2,3323923974170004974,-6425691888629786529,5548050765277166458,9137529250416365269,'2023-12-16','2023-12-15','2023-12-09','2026-02-18','i',null,'h','a','z','w','n','e'),(8,3,0,-4,-10,1739831241492161355,null,204484851393142971,-6930554509743536030,'2023-12-19','2023-12-16','2025-02-17','2023-12-18','x','t','m','g','w','w','s','x'),(9,-4,-4,-10,7,3904700893851991521,null,-7672537657435053067,869462722132321007,'2023-12-15','2023-12-19','2023-12-09','2023-12-11','o','z','a','q',null,'b','u','z'),(10,6,-10,9,6,null,null,-8989140338865504631,-6469298077405810864,'2023-12-20','2023-12-18','2024-01-08','2026-02-18',null,'h','d','k',null,'f','n','m'),(11,2,-10,7,3,1328620898745457998,-7090976220273634925,-3599139190971849924,-2102435587224046901,'2023-12-14','2024-01-08','2024-02-18','2024-01-19','l','x','f','s',null,'k','l','z'),(12,6,-10,2,-4,9009271475208811423,8441689277606770546,8871831722410993972,1132283061754197788,'2024-01-09','2023-12-19','2023-12-18','2024-01-19','h','p','o','a','u','i','m','x'),(13,-10,null,-10,1,null,322929711992670366,-883630782066952379,-1413588726555591530,'2025-02-17','2024-01-08','2023-12-12','2024-01-17','k','y','w','t','h','r','m','y'),(14,1,2,-4,2,4312041564677603577,-2344356879656929940,-608025349860468606,6676031722719832864,'2025-02-17','2025-06-18','2024-02-18','2024-02-18','p',null,'h','u',null,'i','i','y'),(15,5,5,8,7,-7579753459085210612,-5204561985244551275,-8479232749371119584,4976495444181608651,'2027-01-16','2023-12-19','2027-01-16','2023-12-11','s','i','k','y','p',null,'j','i'),(16,null,8,3,4,-5085060258463774568,4042805991758172608,2635489319634915612,9083328219663211094,'2023-12-18','2023-12-10','2024-01-09','2023-12-13','u','l','c','s','l','y','o','y'),(17,3,9,-4,-4,-5950089126417892067,2159466453801097826,-8185286782898205830,-7060555192604520964,'2023-12-16','2024-01-17','2026-02-18','2025-06-18',null,'p','z','r','k','k','p','t'),(18,-10,null,1,2,null,4032424457388266895,-8265951206864158373,-67539414605010340,'2024-01-19',null,'2025-06-18','2023-12-16','c','z','n','u',null,'t','p','u'),(19,-4,-4,0,5,861449201729392633,1556352034575899013,-16311735035252646,563291268848853666,'2024-02-18','2025-06-18','2025-02-17','2026-02-18','e',null,'x','r','j','w','p','z'),(20,-4,4,-4,-4,null,null,-3694709686240537697,3316270576255029903,'2024-01-19','2023-12-10','2023-12-19','2024-01-17','g','e','z','p',null,'o','o','f'),(21,null,2,1,0,5263023698760808603,3874215824116943383,7055587054904097517,-5156075508671683583,null,'2025-02-18','2023-12-20','2024-01-09','p','l','x','i','u','f','j','z'),(22,-4,6,-10,9,-5894359904872889807,null,8493366068421010306,-8778470668799624907,'2024-01-19','2023-12-15','2023-12-09','2026-01-18','i',null,'i','g','w','z','q','v'),(23,null,0,-4,8,-1630740844105903150,null,-3944291460488848093,-7196598240063581070,'2025-02-18','2026-02-18','2023-12-20','2025-06-18',null,'t','h','t',null,'d','e','w'),(24,null,9,5,-4,-7160054670036922520,-5272841421834884069,5230024895180800243,-3541158864009046636,'2024-01-19','2024-02-18','2023-12-17','2023-12-13',null,'t','c','l',null,'p','d','b'),(25,-4,3,1,3,null,-7878692887121548954,-3255396897612089370,-2078240875599960387,'2023-12-18','2024-01-08','2023-12-10','2023-12-16','j','p','k','p','t','r','o','e'),(26,9,6,3,4,4136389603562233139,4596265110472467284,-1752751288572551507,5926046209022563746,'2024-01-09',null,'2024-01-08','2023-12-13','k',null,'n','k','b','n','a','e'),(27,2,null,2,7,215640655136253416,-6820010712952928918,1386217423464468763,-2523883186535664240,'2027-01-09','2024-01-08','2023-12-16','2026-01-18',null,'e','q','p',null,'u','i','t'),(28,0,7,-4,7,-4509060729623994721,2824627190851162516,-1440373064216352658,-5661598924964234877,'2023-12-18',null,'2024-02-18','2023-12-12','h','b','y','e','p','r','a','t'),(29,-10,null,2,-4,-271787779028597812,-446908606509171034,-9119096621370059269,6689549911515521678,'2026-01-18','2024-01-17','2023-12-15','2025-02-18',null,'s','z','a','y','y','h','w'),(30,8,-10,-10,0,2890520024241265015,6594724303733356080,-2198008391290180978,-532140916986023152,'2023-12-15','2024-01-08','2023-12-18','2026-02-18','j','b','d','z','i',null,'n','x'),(31,9,-4,5,-10,-4881720233602707604,null,7196217729756112234,6837311886456265548,'2027-01-09','2023-12-12','2023-12-13','2025-06-18','t','l','i','g','z','m','t','j'),(32,9,null,-10,-10,8182391834303721391,7379750140367246729,5026393428110261917,-2975063364572499436,null,null,'2025-06-18','2023-12-15','u','f','i','x','a','t','x','d'),(33,7,null,-4,2,-4398982183165331176,613467668495315101,-7683330830655242073,7676849019337262747,'2026-01-18',null,'2023-12-20','2023-12-16',null,'s','i','s','q',null,'a','p'),(34,5,null,-4,4,null,5654287610804195742,7681232309475513568,-2237379633403709812,'2024-01-19','2023-12-10','2023-12-14','2023-12-18',null,null,'k','u','s','i','y','n'),(35,1,-4,5,-4,null,null,6759534498340045704,-1588419233394202828,'2024-01-08','2024-01-09','2027-01-16','2023-12-14','d',null,'t','y','e','h','l','h'),(36,null,5,5,1,null,2943619147423060164,-2943059052815504132,-321144148792997118,'2025-02-18','2026-01-18','2027-01-09','2024-01-31',null,'i','p','s','s','y','x','l'),(37,9,7,6,4,5444212481252892161,null,6210776129729894324,7637629702811776501,'2025-06-18','2025-06-18','2023-12-20','2023-12-09','h','s','q','l',null,'n','x','z'),(38,-4,4,6,6,-4273522612672690241,-2163783139870002458,2987389896036671789,-4925922168584027535,'2025-02-17','2023-12-17','2023-12-10','2023-12-19','e','e','z','z','v','l','b','x'),(39,3,2,-4,-10,4218966967935358715,-3150403880248527224,-9060797394235616096,-6779136125595918812,null,'2023-12-11','2023-12-12','2023-12-17','l','y','d','v','b','p','n','d'),(40,-4,7,-10,-10,3612765945778453007,-6352243101940050149,-1750792478921863542,-4392148900831991869,null,'2023-12-17','2025-02-17','2024-01-31','b','s','v','g','a',null,'h','m'),(41,-4,-10,2,4,-1417537921690276411,null,-623687090702386072,-1418705868850998495,'2026-01-18','2023-12-10','2024-01-17','2023-12-19','k','q','t','i',null,'v','b','d'),(42,0,-10,-4,-10,2269075628477764608,-3426852249728677136,-6226076155502118114,-8916012764228980381,'2024-01-31','2024-02-18','2026-01-18','2023-12-17','j','s','q','n','u','o','n','s'),(43,-4,null,-4,6,-42660836300608157,null,9124731015399553639,-4739781695189757558,'2023-12-09','2023-12-19','2025-06-18','2023-12-15','s',null,'x','n',null,'i','o','x'),(44,-4,-4,9,4,6106729176363093387,-3809271088098577030,-4549568805185023748,3199859357222747400,'2024-01-17','2023-12-12','2025-06-18','2024-01-19','d',null,'t','g','s','u','u','w'),(45,1,8,9,4,5717424935878494451,5056428518109161660,6890078283055498488,-786477593585247651,null,'2023-12-13','2027-01-16','2026-01-18','k','p','t','j','p','t','s','y'),(46,5,9,4,2,-4013397412228554341,null,5665673753811958662,8724907299215146504,'2025-06-18','2024-02-18','2023-12-10','2023-12-16',null,'k','t','z',null,null,'t','h'),(47,-10,null,6,-10,8593342016531294477,null,-2967966864541715668,2974402110895392579,'2023-12-15',null,'2025-02-18','2027-01-09','c',null,'r','n','f','d','w','g'),(48,5,-10,5,4,8485714709644633086,-8931303117932343121,-2905580576080883226,8498475316101264973,'2026-02-18','2027-01-16','2024-02-18','2023-12-09','l','k','e','b','s','x','x','a'),(49,-4,4,3,1,null,7084206865987578085,-6982535735429272258,-4933403114625166581,'2025-02-17','2023-12-14','2023-12-18','2024-01-09','w','r','x','d','w','h','z','g'),(50,9,7,9,4,2418945360740328183,1855887612167207861,178250061979015434,1014638695615213500,'2023-12-18','2024-01-17','2023-12-12','2024-02-18',null,'n','e','o','y',null,'q','s'),(51,-10,-4,3,-4,7923994796842376047,1399411960732785363,7172778984403538278,8640484027022417926,'2023-12-18','2026-02-18','2023-12-19','2023-12-18','s',null,'h','s','p',null,'e','e'),(52,9,8,-4,8,null,null,-760737158477048083,-3951123005928653587,'2023-12-16','2025-06-18','2023-12-17','2027-01-16','z',null,'r','w','v',null,'x','f'),(53,-4,-10,5,8,null,-2623827713122861489,-7013844896396343677,2276480092313939745,'2023-12-19','2023-12-18','2027-01-16','2023-12-19','m','a','p','d','g',null,'k','v'),(54,1,0,5,4,5592396458386380592,-4894448088511402159,-3843159775495255456,-8242563182983768982,'2023-12-10','2024-02-18','2023-12-16','2024-02-18','d','u','d','k','q','u','j','g'),(55,-10,8,-10,4,-7254929590604226737,-5874824019347693244,-7642453758439884785,-4628882326150627868,'2024-01-17','2025-06-18','2023-12-10','2023-12-20','t','c','i','x','e','t','s','s'),(56,4,null,2,-4,-712805683658083997,-585351950665753733,-7198296549027841517,3991244175014717249,'2023-12-11','2024-01-17','2024-02-18','2023-12-11','x','k','u','u','e','b','l','c'),(57,null,null,9,0,-3785971940016429479,2712638004935205086,6487840498899215573,616481824995337555,'2027-01-16','2025-06-18','2023-12-16','2025-06-18','u','c','w','x',null,'q','f','v'),(58,-4,-4,6,-10,-8672862345351649856,-8250624268354617848,719830499970189717,-6383657771392069685,'2026-02-18','2024-01-31','2023-12-12','2023-12-12',null,'p','j','e','k','y','r','v'),(59,null,1,-10,7,null,-5835771079262329662,5209150392054190648,-1720713524132592946,null,'2025-06-18','2023-12-14','2023-12-11',null,null,'k','f','n',null,'g','m'),(60,-10,4,0,-4,-4472748874901497041,6614262386698960399,7887450717655378474,7134435436787347678,'2024-02-18','2026-01-18','2027-01-16','2023-12-11','k','c','o','r','k',null,'j','k'),(61,null,3,-10,-4,6706536143191523594,-3170705394174834561,-8853093071974259479,-3495951361208324825,'2024-01-17','2023-12-09','2027-01-09','2027-01-16','m','o','q','b','q',null,'w','w'),(62,-10,-4,0,3,9021462835703388045,null,-8057197783736586447,5456443037665857257,'2024-02-18',null,'2023-12-14','2024-01-19','z','l','i','g',null,null,'w','k'),(63,4,null,-10,-4,1263801391917774080,7659752334631798683,1993482639322221864,5231315386416251606,'2024-02-18','2024-01-19','2023-12-20','2023-12-19','j','u','o','o','z',null,'y','w'),(64,-10,-4,9,1,2509729806786373601,-5375812500023549585,5590897759725701223,7189055691776884729,'2025-06-18','2024-02-18','2023-12-19','2023-12-18','d','q','y','g','l','a','u','x'),(65,3,0,7,7,null,null,8357509749541371161,-2149388624831105902,null,'2023-12-11','2023-12-09','2023-12-18','j',null,'i','d','a',null,'o','f'),(66,5,8,-4,7,4185438158426437770,2574868598971524353,8911316364755921287,-9100935488088002128,'2024-02-18','2027-01-09','2024-01-08','2024-01-31',null,null,'z','n','c',null,'i','g'),(67,null,0,5,4,null,313186232700254613,7949551406782187554,-2779460383930036569,'2023-12-09','2026-01-18','2023-12-11','2023-12-19','b',null,'q','q',null,'h','q','v'),(68,4,null,8,1,1806530871440069554,3477469866955181601,-7975283921206196480,662565569209188062,'2023-12-14',null,'2024-02-18','2023-12-17','w',null,'h','z',null,'m','m','i'),(69,3,-4,5,-10,-3305603151062284055,3821488795952749243,7999548960061182075,-8357222842761595456,null,null,'2025-06-18','2024-01-08','h','y','z','t','s','s','v','r'),(70,4,1,8,-4,null,null,7872601211728672469,6399246092106712216,'2023-12-16',null,'2023-12-10','2024-01-17','c','p','l','u',null,'o','i','y'),(71,4,-10,2,-10,null,2095984782923112376,6817795253532516119,831688013769694544,'2024-01-31','2024-02-18','2024-02-18','2023-12-15','h',null,'j','l','t',null,'g','v'),(72,-4,5,-4,8,null,3450275682788154904,6866614452510568247,7650816577241044945,'2023-12-11','2023-12-20','2023-12-10','2027-01-09','u','r','l','p','e','a','t','n'),(73,-4,9,6,-4,6623981776082991771,5124801173187351698,7357816777100044635,2834611479186561863,'2025-06-18','2023-12-17','2024-02-18','2024-01-31','a','e','f','m','m','i','d','w'),(74,3,-4,-10,-10,1331481777889763152,5513125980754039439,-2284745227251538180,795524105935694747,'2024-01-19','2023-12-11','2024-01-08','2027-01-16',null,'w','z','z','q','l','o','p'),(75,-4,1,7,6,null,null,603799798092468882,-5770759215513736228,'2025-06-18','2024-01-08','2024-01-17','2023-12-14','l','i','f','m',null,'i','u','l'),(76,5,-10,3,-10,8674718801880847389,8254709274517327248,3752322910776501987,-2877918142018065649,'2023-12-19','2024-01-09','2024-01-31','2023-12-10','d','m','c','q','p','u','s','f'),(77,7,8,3,-10,-1347986401384195967,716981124871181737,6952117604833494505,3901997538653524769,'2026-01-18','2026-01-18','2024-02-18','2023-12-11','c',null,'o','c','e',null,'j','j'),(78,3,1,-4,9,null,2961591759562931299,4421737002353521383,-3117536543174815610,'2025-02-17',null,'2023-12-11','2026-01-18','d','c','i','p','w',null,'z','z'),(79,null,-4,7,3,-8859292053592641615,null,3755120851935726704,-5631038575894536802,'2024-01-17','2024-01-08','2025-02-17','2025-02-17','j','p','q','n','o','n','m','w'),(80,null,null,0,-4,2255317812719718951,-1542949256776753198,5165165574011727417,3362157805993875372,'2025-02-18',null,'2023-12-12','2024-02-18','l','g','z','l','m','q','n','s'),(81,null,-4,6,-4,-2721580821723779103,-1353744076419580288,-5260458005565053092,-7699334698963498432,'2023-12-19','2025-06-18','2023-12-10','2026-01-18','f','u','k','m','h','x','x','m'),(82,null,3,2,4,-20677508156293958,4433932604039254869,-1599151438646003892,6279654975009443436,'2025-02-17',null,'2026-02-18','2024-01-19',null,'o','i','u','v','n','c','x'),(83,4,-10,9,-10,null,null,1887080893954240868,2983873409792010094,'2027-01-16','2024-02-18','2024-02-18','2023-12-18','x','h','w','g','s','j','m','a'),(84,-10,2,9,0,2514795867679945996,1180423527189821650,-8334049902514799505,-311904996542246411,'2023-12-19','2023-12-18','2025-06-18','2023-12-20','l','z','t','t','u','k','j','n'),(85,1,-4,-4,-4,-2086280613661624694,null,-652686743531201072,-2455465614982683768,'2025-02-18',null,'2023-12-15','2025-06-18','b',null,'x','n',null,null,'v','z'),(86,5,null,7,5,-7153187634822973079,null,-4296891534257475252,8579055344421674447,'2023-12-10','2024-01-17','2023-12-20','2024-01-19',null,'g','a','n','f','d','g','v'),(87,-10,7,2,9,5364699919679512694,-8402281447103663176,4967255210369118644,1213253086812256012,'2023-12-14',null,'2024-01-31','2024-01-09','n','t','o','h','c','w','u','u'),(88,1,0,2,-4,2330602761735382967,5728822409293440773,2873720374721037680,9218552818291526510,'2023-12-16','2025-06-18','2024-01-08','2024-02-18','q','q','o','j','z','y','v','n'),(89,8,1,-10,4,4621112080056840925,null,-8740912311019697251,-996982670620749947,'2023-12-13','2026-02-18','2024-01-17','2027-01-16','x','y','o','e','d','p','p','i'),(90,-10,3,0,-4,-537470397376835792,null,-3121053793282232856,8780312835482752265,null,'2027-01-09','2026-02-18','2024-01-19','d','i','s','p','s',null,'r','u'),(91,-4,null,-4,-10,3578174019070916824,-4195514773191032784,-5024286613946640667,-6552645163788051131,'2023-12-20','2025-02-18','2023-12-10','2024-01-17','p','w','q','a','r','q','v','c'),(92,-4,7,9,8,-4637762434874020617,null,-2786596302395056532,3791679250048495807,'2026-02-18','2023-12-17','2024-01-08','2024-02-18','w','y','r','k','x','f','l','p'),(93,6,-10,8,5,-293629701199542961,7493770629733875779,-3094691401140820490,6717350982707155282,'2023-12-10','2023-12-13','2023-12-18','2023-12-12','j',null,'g','x',null,'x','w','q'),(94,7,4,6,-4,-82370903295588539,-110422267597649591,-56849494839699994,-5353184484281227043,'2023-12-10','2023-12-12','2024-02-18','2024-01-31','l','b','e','n',null,'o','y','y'),(95,4,2,6,4,8511226213490978849,4028258415226973779,-4444225001310692756,7848324692459614620,'2024-02-18','2024-02-18','2024-01-09','2023-12-19','n','f','n','c','c','g','m','t'),(96,5,2,9,6,null,null,-2163047989934076758,3323421202699332934,'2023-12-14','2023-12-12','2023-12-12','2023-12-11','y','m','g','e','i','r','j','l'),(97,null,-4,-10,4,null,-4005749239704895709,2308099215543141438,-8632639215095192205,'2025-06-18','2024-02-18','2024-02-18','2023-12-15',null,'n','i','n','v',null,'k','t'),(98,3,-4,1,5,1343441290905124027,5985928841299794808,2059021116323997292,-1545463762219304149,'2024-01-09','2025-02-18','2026-01-18','2024-01-19','f','i','x','z','a',null,'l','q'),(99,-4,3,4,2,-2779435807369183259,4488620703954699317,-5685905917878656843,-5854990526679501358,'2024-01-17','2024-01-09','2023-12-17','2024-01-09','l','y','k','s','s','f','c','g'),(100,0,2,-10,8,4778302667077575147,8280564320823411424,-1696839596454863812,8789925854201250450,null,'2024-01-08','2024-01-08','2025-02-17','e',null,'a','y',null,null,'z','x'),(101,7,2,-10,-10,-3378392658835997314,-3305331345242505689,2571374257910680108,7282353530159633042,'2024-01-09','2024-01-17','2024-02-18','2024-02-18','w','w','o','j','i','v','z','t'),(102,8,null,-10,9,5211719673235265188,6489886869329643232,2012665731589705360,423525679504426169,'2024-01-08','2023-12-15','2023-12-09','2023-12-16','g','f','r','y','d','y','r','j'),(103,0,1,4,-10,-5067007784159692585,208029847784525065,8519159137753663121,8741587957292686877,'2023-12-10','2025-02-17','2023-12-15','2024-02-18',null,'z','f','j',null,'k','m','y'),(104,1,-10,0,8,-6501833278173223499,7623321800619376098,-7197781112467263388,-2611051031671059196,'2023-12-15','2024-01-08','2024-01-19','2023-12-16','e','a','k','u','t','n','y','y'),(105,3,-10,6,1,-5931527416062833336,-6077776430116806009,-5363633540238041563,7751328605426931508,'2024-01-08','2023-12-10','2025-02-18','2024-01-17','w','t','v','j',null,'k','t','u'),(106,5,7,9,-10,-3311598334492162205,-8963431423229941817,-4065779267408635604,-1503211891632655678,'2024-02-18','2023-12-09','2023-12-11','2024-01-31',null,'l','v','l',null,'x','m','c'),(107,-10,-4,5,9,-2891443038426437934,7112101236652602790,-8966160938533309392,8250574028724848738,'2024-01-19','2023-12-11','2025-02-18','2026-01-18',null,'o','p','a',null,'r','r','i'),(108,7,6,3,6,null,4176699248807535761,7728537588971952783,-3119026471023348772,'2024-02-18',null,'2023-12-19','2025-06-18','m','j','j','q','d','m','g','c'),(109,9,-4,4,2,null,-2313118681658345563,3832839074227660670,2756140147439317982,'2024-01-31','2025-02-18','2023-12-15','2023-12-17','x','h','m','e','y','j','l','y'),(110,6,5,0,1,null,3005810481741755567,4312435299592135389,7741706875029319717,'2023-12-12','2023-12-13','2025-02-17','2023-12-17','f','y','n','t','s','a','s','b'),(111,5,2,-4,0,-1406464572344150773,null,-3789091921305903671,-1551604915672550933,'2023-12-15','2023-12-13','2023-12-16','2023-12-13','k','i','f','n','s','l','w','m'),(112,3,6,-4,6,null,-1494400314998703787,-3778556021604813646,-3472087406277232110,null,null,'2023-12-09','2025-02-18','q','q','o','x','x','x','n','k'),(113,-4,-10,-10,2,4679007757674996076,-1936558659062100793,1023332574310829606,-6885883451697927053,'2024-01-08','2023-12-16','2023-12-10','2023-12-09','u','t','b','y','c',null,'m','t'),(114,8,6,-4,6,-4885607248921418721,null,-7271739481142138259,-1815259327338851174,'2023-12-09','2027-01-09','2023-12-14','2027-01-09','i','o','w','i',null,'q','s','k'),(115,7,8,-4,0,8639532729297028441,null,-1575456351900821542,8566550289745425662,'2023-12-20','2023-12-15','2023-12-12','2023-12-16','q','f','i','p','h','x','k','g'),(116,8,2,3,1,-6153974662722527343,4511598998113023615,6220503259314201965,-7598892215191073304,'2023-12-18','2023-12-11','2026-01-18','2023-12-13','n',null,'o','f','t',null,'u','h'),(117,-4,8,1,2,-683433994245160231,-1068402540298147079,-2849622828484484476,-5436149582364337835,null,'2024-01-09','2024-01-09','2024-01-17','a','q','o','g','i','p','i','c'),(118,9,9,1,-10,null,null,-7824744283047616306,-4654460323054778860,'2023-12-17','2026-01-18','2023-12-12','2025-06-18','j','i','l','w',null,'p','s','l'),(119,5,null,8,9,-5034569697381041457,-5884660822446140354,-4101760948124516235,5167146025697161176,'2023-12-20','2027-01-09','2023-12-12','2023-12-15','j','f','a','r','r','g','p','x'),(120,-10,5,-10,7,-1207123946650247325,2025217943146622095,-3264854026481584749,1982083568607390,'2024-02-18',null,'2025-02-18','2023-12-14','e',null,'i','b','x',null,'i','n'),(121,3,-4,3,5,null,551061459101972996,7232562528788330759,-5406203619502267298,'2025-02-18','2027-01-16','2023-12-12','2023-12-14','m','e','d','q','c',null,'a','o'),(122,8,-4,5,8,-1650119627206910515,-6130046403465455405,-3580817790246412788,2699005345336191829,'2023-12-16','2024-02-18','2023-12-15','2023-12-16','g','v','c','j','k','z','w','z'),(123,2,0,5,6,1187747532894393077,-28894097257877656,8603117650094520968,2730919072245864091,null,'2027-01-09','2023-12-11','2024-01-17','t','b','o','l','k','t','s','m'),(124,2,5,6,-10,8385827522979191313,1767919099057778909,7143182730809575111,4709157700188500284,'2023-12-09','2023-12-09','2024-02-18','2024-02-18','b','k','v','p','b','b','u','s'),(125,-4,-10,4,8,8410451011076146166,-2191219765572350012,-2305149676517085109,-407769454346537975,'2023-12-19',null,'2023-12-19','2025-06-18','k','j','c','l','p',null,'h','u'),(126,9,-4,-10,9,8328355680073938767,-3379535880903743282,-1169622107863718241,-4552686409894710861,'2024-01-19','2023-12-13','2023-12-19','2026-02-18','x','m','s','h',null,'l','n','c'),(127,9,2,6,5,8445871382226836097,-5443632209631655307,-8989112927186869266,1738233019433582707,'2023-12-12','2023-12-16','2024-02-18','2023-12-10','j','z','z','r','h',null,'g','q'),(128,9,2,3,-10,null,null,-2372100357592806973,4338247854203237431,'2024-02-18','2024-02-18','2023-12-20','2024-02-18',null,null,'k','z','e','i','q','h'),(129,7,2,3,-10,-4417735777633385431,9071970020137679071,-5707010014317137184,2868630757181324901,'2023-12-10',null,'2024-02-18','2023-12-12','m','l','j','q','i','b','v','u'),(130,7,5,8,-10,null,4227704613523973331,2750441336788147409,-6485832640714524555,'2027-01-16','2023-12-10','2023-12-19','2024-01-08','s','h','y','v','m','l','t','u'),(131,-4,-4,-4,7,-6851667681343727046,4367064914631113233,5163178218151336720,3969909950479228655,'2024-02-18','2023-12-20','2024-02-18','2025-02-18','c',null,'n','m','u','g','b','b'),(132,5,8,2,-10,5834181244856856662,-5449876477630405694,-1240090186549158170,-4996403173213539680,'2024-01-19','2024-02-18','2027-01-09','2023-12-14','o','x','o','p','n','a','b','p'),(133,null,3,7,9,1592178064922352627,8533426722832786679,-9118371409010777306,5534509364584348949,null,'2023-12-19','2024-02-18','2027-01-09','k',null,'f','e','o','y','p','d'),(134,null,8,-4,7,-2079292502791653091,3200149736202225295,6235029433253324882,-6001494224233773866,'2025-02-17','2025-06-18','2026-02-18','2023-12-12','i','v','z','k','h',null,'d','b'),(135,5,8,-10,5,-6145936203441287883,null,2028304218249479589,4409091762597728418,'2024-01-19','2025-02-18','2023-12-10','2023-12-15','b','r','y','u','n','m','j','u'),(136,3,0,-10,6,-8264148661611096209,-5601414079410388130,82103538424261595,8309755830537525141,'2026-01-18',null,'2025-02-17','2023-12-20','s','o','w','f','f','u','v','o'),(137,-4,-4,5,7,2829715444911397267,1199029388382970973,3796685789522670001,2755119482340934123,'2025-06-18','2024-02-18','2024-01-19','2027-01-09',null,'s','r','u','x','a','u','t'),(138,1,6,9,9,null,null,6380140737515414519,4343683718934572370,'2026-02-18','2023-12-13','2024-01-08','2024-02-18','i','o','l','z','g','f','i','l'),(139,-10,3,-10,6,726720720991317248,null,4205384423434436791,5327138317273322856,'2023-12-09','2024-01-17','2025-06-18','2023-12-13',null,'j','t','v',null,'g','d','k'),(140,1,null,4,5,null,null,-6641007316872916011,-4810614772167245488,'2024-01-17','2023-12-20','2024-01-08','2027-01-09','j','g','w','b','k','w','u','z'),(141,9,-4,2,-10,-2297806863427977545,1030711621990228214,884547766177794284,-3618838148508268179,'2025-06-18','2023-12-19','2023-12-10','2023-12-13',null,'h','n','t','s','j','y','g'),(142,0,1,6,-10,5333814042573207449,8415309982041259189,-4553770605794953578,-8993385406662677467,'2023-12-09','2024-01-08','2025-06-18','2023-12-12',null,'e','e','g',null,'l','a','b'),(143,7,2,3,8,2492724970477263495,-9192873926087513662,-7459455129625750306,-532685574184305480,null,'2024-02-18','2023-12-20','2026-01-18','r','b','o','z','z','t','c','i'),(144,5,-10,5,-10,4311121377744046889,4329521466855646652,1639901007309562540,-3056039714595876694,'2025-06-18','2023-12-15','2025-06-18','2024-01-09','n','u','m','j','k',null,'p','y'),(145,-10,-10,5,-10,-223600674474504082,1141055678211836530,5842899648098041924,9188649358530202835,'2023-12-19','2023-12-19','2024-01-08','2026-02-18',null,'s','o','m','b',null,'a','t'),(146,0,8,-4,5,null,null,7830241322783936321,-2211028913370096184,'2024-02-18','2024-02-18','2023-12-20','2023-12-15',null,'u','z','m','p','g','y','o'),(147,-10,5,9,8,-7614206736601488641,-2272198453379013715,7323806815335476007,6202738252590830481,'2024-01-17','2024-02-18','2023-12-16','2023-12-17','z','f','v','e','i','t','s','y'),(148,-4,8,7,-4,-8786865690570238665,null,-4342528391048888218,2854298242533676708,'2023-12-17','2025-02-18','2023-12-11','2023-12-16',null,'s','g','e',null,'w','p','o'),(149,-10,-10,3,0,null,8567730716011838948,-6007579607748099650,-5970406031545339581,null,'2023-12-18','2023-12-10','2024-01-08','w','e','t','r','s','i','b','d'),(150,8,-4,-10,-10,-4816468858722006123,-3313826204845907097,878766875968731719,-6268104901090729394,'2024-02-18','2025-02-18','2027-01-09','2023-12-09',null,'q','d','c',null,null,'y','n'),(151,-4,8,8,4,null,-3972883517635689030,9205636207269322710,4407495981480097286,'2027-01-16','2027-01-09','2024-01-09','2025-06-18','m','w','n','j','q','t','m','e'),(152,1,2,9,-10,-5359614300643791445,null,3843173669116503241,2096500897610447673,'2023-12-15','2023-12-14','2027-01-16','2025-02-18',null,null,'c','n','a',null,'u','a'),(153,1,-4,-4,-4,-7384797922222548801,-2871856587598805628,1132007854568747657,508336154670182865,'2023-12-18','2024-01-08','2023-12-18','2023-12-12','l','t','a','b','l','k','e','b'),(154,1,2,-4,-10,null,null,2507441119731065265,6600965449913191471,'2024-01-08',null,'2026-01-18','2023-12-18','f','q','i','r','u',null,'t','h'),(155,7,null,-4,6,7958691941415204339,-5617235329948653585,5195065067765625568,972648639214427978,'2026-01-18','2024-01-08','2024-01-19','2025-02-17','v','v','t','g',null,'n','m','z'),(156,9,null,-4,6,5275201122306717534,-2053776681585762842,-2514570494127455211,13671866028182424,'2023-12-16','2025-02-18','2024-02-18','2024-02-18','s','w','n','a','m','d','b','f'),(157,5,6,-10,-10,729908883475181665,5170124620968600282,9036762851334497312,4660352567315678877,'2023-12-18','2023-12-18','2023-12-19','2023-12-09','o','i','x','w',null,null,'q','y'),(158,null,-10,7,1,441461999290476521,2490157209123888677,-8348496951265076493,326768390431383450,'2026-02-18','2025-02-18','2024-01-09','2023-12-13',null,null,'q','i',null,null,'h','y'),(159,-4,9,-10,3,9059181795796180336,-6623256306016216376,5250044187057791685,650062767851014915,'2025-06-18',null,'2023-12-13','2023-12-16','a','i','y','q',null,'u','b','e'),(160,null,4,0,3,4345807448106512427,-6446488151531446403,7794225974681066159,-9093724839905055488,'2024-02-18','2024-01-08','2023-12-16','2026-02-18','z','j','u','m','p','l','h','t'),(161,5,8,0,-4,-3598713850899057179,-2363063317218676716,8505521257309395911,-2014708559278646662,'2023-12-10','2025-02-17','2023-12-18','2027-01-09','q','r','g','p','t','g','z','w'),(162,-10,1,1,-4,null,null,-464218641565037081,-7843976149424896570,'2026-02-18','2026-01-18','2024-01-17','2024-01-19','h',null,'w','a',null,null,'c','d'),(163,2,-4,-4,7,1281030022487860106,null,-8224489933818424590,7091217793793206509,'2026-02-18','2025-06-18','2023-12-11','2024-01-09','q','o','p','i','x',null,'h','d'),(164,-4,-10,5,-10,-4074518686644808384,8032376885610745218,-4282378146761203763,7671790015713139412,'2023-12-17','2027-01-09','2024-01-09','2023-12-09','f','n','y','i','b',null,'i','g'),(165,3,7,4,7,null,7561547756537447694,6021467917861029661,2017959655814904223,'2023-12-11','2023-12-20','2024-01-08','2027-01-16','f',null,'i','c',null,'o','c','x'),(166,2,6,-10,5,-6827254344258745534,null,9172563978347331436,7177325498587194452,'2025-02-18','2024-02-18','2023-12-12','2024-02-18','g',null,'p','e','b','h','h','q'),(167,2,null,-10,1,null,2431834680183205061,-4948894022418777553,7218774748531615271,'2024-01-19','2026-02-18','2024-01-19','2023-12-10','t','n','r','u','o','t','z','n'),(168,null,-4,-10,5,-223725292341354264,null,-3801066124844074212,2805381330756091348,null,'2023-12-14','2024-02-18','2025-02-18','k','v','f','v','d',null,'z','t'),(169,3,7,-10,7,null,-1833306832979778838,-5643952893059696040,2687001791769359590,null,'2027-01-09','2023-12-17','2026-02-18',null,null,'g','o',null,null,'i','v'),(170,-10,-10,7,6,-5031832767236973735,-322627563764624794,1312473402743635166,9219682604938912601,'2023-12-12','2027-01-09','2024-01-17','2023-12-10','s',null,'l','g',null,'q','u','s'),(171,9,-4,3,4,-7746662411415548988,-2243228146866214715,-6601505688772344084,2356970782196512154,'2023-12-18','2023-12-11','2023-12-12','2023-12-13','g','z','v','e',null,'n','b','e'),(172,null,-10,4,-10,null,-5075877276103349667,-5521374795778999420,2786009628846716145,'2024-02-18','2027-01-09','2027-01-09','2023-12-20','k','b','h','w','s','j','n','i'),(173,1,2,2,-10,6905734047829315274,-1522309848349984324,-8624397713354743668,2233013846632926837,'2024-02-18','2024-01-19','2025-02-17','2024-01-31','t','g','m','x','r',null,'w','y'),(174,3,4,9,5,1866247159085348728,null,-1457322528432762067,-5618775571601319437,null,'2023-12-13','2024-01-08','2024-01-08','s','y','m','i','v','b','f','b'),(175,5,null,-4,3,null,7855973288355538370,4343355536311212584,93915961276513363,null,'2024-01-08','2027-01-16','2023-12-09',null,'t','u','q',null,null,'n','e'),(176,-4,-4,6,1,null,6339575909962635839,-8566962156962653528,-6131537983971480097,'2026-01-18','2023-12-15','2023-12-12','2023-12-15','n','z','i','l','b','r','i','r'),(177,4,5,7,-4,6972614850448031795,-2230492540756459688,5234975278087229154,6508105190249027664,'2023-12-14',null,'2023-12-16','2024-02-18','v',null,'o','s','y','t','o','y'),(178,1,-10,2,-4,3311499181259415877,6779191746588998685,8233916357977584658,1844711628768206939,null,'2027-01-09','2026-02-18','2024-01-31','d','g','l','s','c','e','e','l'),(179,1,null,7,0,null,-1198158587613105152,8417977348595157585,-6598099682872574210,'2025-02-18','2024-01-09','2023-12-13','2026-02-18','k',null,'j','y','p','v','c','n'),(180,-4,1,5,-4,4170140192412096101,6536907386047214787,-8697534421260237438,-6573649273281672645,'2023-12-13','2024-01-19','2023-12-11','2024-01-19',null,'f','y','g','f','s','s','r'),(181,-4,-10,-10,-4,590051844098045133,3059176084933959734,-7373937782709860831,-2749774247552951444,null,'2024-01-09','2024-01-09','2024-02-18','p','j','y','y','s','t','o','j'),(182,-4,-4,9,7,6931962213474854029,4305039275800347663,-2241917674727038857,-2407696028432456976,null,'2023-12-18','2024-01-09','2023-12-17','n','q','q','d','i','n','q','j'),(183,-4,5,5,-4,9182230834953942908,3153920117360367537,-6964523561584069411,-4258787353841637588,'2025-02-17','2024-02-18','2023-12-11','2023-12-20',null,'u','y','g','r','c','y','h'),(184,null,7,-10,9,-7873290708943205402,-6753231137321295128,-3838775840997793136,-8028604306909578083,'2024-01-09','2027-01-16','2023-12-15','2026-02-18','u','p','r','m','s',null,'m','j'),(185,8,0,7,4,-2625295883737853795,6457985247050040214,482509364286707989,-1715579675293028009,null,'2023-12-19','2024-02-18','2023-12-09',null,'e','h','f',null,'c','s','y'),(186,6,0,1,-10,null,-6183169887354483731,-4603129737995258061,-323433725512455820,'2023-12-14','2024-02-18','2024-02-18','2026-01-18','k','v','l','n','t','o','d','o'),(187,-4,7,-4,0,-6405253953868450007,-5254088950763357645,7214072085720433708,-9021090709803181939,'2023-12-11','2023-12-09','2023-12-17','2024-01-08','t',null,'o','z','n','u','n','r'),(188,2,-4,2,-10,null,-5694189373121017288,6724340246018771833,1833792579190084490,'2024-02-18',null,'2023-12-19','2026-01-18','b','l','g','v',null,'h','a','d'),(189,4,0,3,0,null,-4936229114658367420,28199202276056631,-5651486587963242817,'2023-12-19','2023-12-18','2024-01-31','2023-12-18','h','n','q','u','h','e','g','q'),(190,-4,-10,7,2,null,-439750349652710300,7547204428228883999,-4875253993115922076,'2027-01-09','2023-12-10','2024-01-17','2026-01-18',null,'r','i','n','z',null,'a','f'),(191,-10,3,-10,4,507523453969637763,8565256622818708059,-1003374276726152547,2612045649358002800,null,'2024-02-18','2024-01-31','2027-01-09','t','h','o','b','e','s','i','i'),(192,8,1,6,4,null,1279047756503474620,1433071910926303854,-2219775184565999643,'2024-01-09','2024-01-19','2025-06-18','2023-12-19','j',null,'k','n','x','s','a','d'),(193,6,0,7,2,-4144279173138579146,814239013464645879,8313902939183498965,-5517888863154193026,'2024-02-18','2023-12-20','2023-12-18','2023-12-14','m','h','m','n','g','z','e','s'),(194,9,-10,-4,-10,-399977877485569744,null,-7134299616675816732,3938804281593228121,'2024-01-31','2026-01-18','2024-02-18','2024-01-19','h','t','z','w','v','j','x','b'),(195,null,-4,-10,7,-8394449101636498681,5842211912819351068,7356546266596118670,1355453294919611273,'2023-12-09','2023-12-12','2026-01-18','2027-01-16','i','o','b','b','y','k','z','c'),(196,-10,null,4,-10,-2931645984909865668,3700653115916246607,5496841004148309651,-4014807699061969680,'2024-02-18','2025-02-18','2023-12-17','2027-01-09','h','j','b','v','h','s','m','r'),(197,null,-10,5,-4,-5116637634722060609,-2870519799499033896,-2257436928402637026,5060179046313167580,'2023-12-20','2023-12-10','2025-02-17','2026-02-18','h','i','p','w','m','p','q','s'),(198,7,-10,6,7,-5547835834020021929,-2607836240406495294,-6409172553860291922,429517182246597176,'2023-12-17','2023-12-19','2024-02-18','2024-01-17','g','l','x','o','y','p','x','e'),(199,-10,null,5,9,4248698263886138946,-8009444580424698559,568870935223124985,5338896842985076247,null,'2024-02-18','2023-12-09','2023-12-20','p','g','x','t',null,null,'j','c');
    """)


    sql("""
    DROP TABLE IF EXISTS `table_200_undef_partitions2_keys3_properties4_distributed_by54`;
    """)
    sql("""
create table table_200_undef_partitions2_keys3_properties4_distributed_by54 (
col_date_undef_signed_not_null_index_inverted date  not null  ,
col_bigint_undef_signed_not_null_index_inverted bigint  not null  ,
col_bigint_undef_signed_not_null bigint  not null  ,
col_int_undef_signed int  null  ,
col_int_undef_signed_index_inverted int  null  ,
col_int_undef_signed_not_null int  not null  ,
col_int_undef_signed_not_null_index_inverted int  not null  ,
col_bigint_undef_signed bigint  null  ,
col_bigint_undef_signed_index_inverted bigint  null  ,
col_date_undef_signed date  null  ,
col_date_undef_signed_index_inverted date  null  ,
col_date_undef_signed_not_null date  not null  ,
col_varchar_10__undef_signed varchar(10)  null  ,
col_varchar_10__undef_signed_index_inverted varchar(10)  null  ,
col_varchar_10__undef_signed_not_null varchar(10)  not null  ,
col_varchar_10__undef_signed_not_null_index_inverted varchar(10)  not null  ,
col_varchar_1024__undef_signed varchar(1024)  null  ,
col_varchar_1024__undef_signed_index_inverted varchar(1024)  null  ,
col_varchar_1024__undef_signed_not_null varchar(1024)  not null  ,
col_varchar_1024__undef_signed_not_null_index_inverted varchar(1024)  not null  ,
pk int,
INDEX col_int_undef_signed_index_inverted_idx (`col_int_undef_signed_index_inverted`) USING INVERTED,
INDEX col_int_undef_signed_not_null_index_inverted_idx (`col_int_undef_signed_not_null_index_inverted`) USING INVERTED,
INDEX col_bigint_undef_signed_index_inverted_idx (`col_bigint_undef_signed_index_inverted`) USING INVERTED,
INDEX col_bigint_undef_signed_not_null_index_inverted_idx (`col_bigint_undef_signed_not_null_index_inverted`) USING INVERTED,
INDEX col_date_undef_signed_index_inverted_idx (`col_date_undef_signed_index_inverted`) USING INVERTED,
INDEX col_date_undef_signed_not_null_index_inverted_idx (`col_date_undef_signed_not_null_index_inverted`) USING INVERTED,
INDEX col_varchar_10__undef_signed_index_inverted_idx (`col_varchar_10__undef_signed_index_inverted`) USING INVERTED,
INDEX col_varchar_10__undef_signed_not_null_index_inverted_idx (`col_varchar_10__undef_signed_not_null_index_inverted`) USING INVERTED,
INDEX col_varchar_1024__undef_signed_index_inverted_idx (`col_varchar_1024__undef_signed_index_inverted`) USING INVERTED,
INDEX col_varchar_1024__undef_signed_not_null_index_inverted_idx (`col_varchar_1024__undef_signed_not_null_index_inverted`) USING INVERTED
) engine=olap
UNIQUE KEY(col_date_undef_signed_not_null_index_inverted, col_bigint_undef_signed_not_null_index_inverted, col_bigint_undef_signed_not_null)
PARTITION BY             RANGE(col_date_undef_signed_not_null_index_inverted) (
                FROM ('2023-12-09') TO ('2024-03-09') INTERVAL 1 DAY,
                FROM ('2025-02-16') TO ('2025-03-09') INTERVAL 1 DAY,
                FROM ('2025-06-18') TO ('2025-06-20') INTERVAL 1 DAY,
                FROM ('2026-01-01') TO ('2026-03-09') INTERVAL 1 DAY,
                FROM ('2027-01-01') TO ('2027-02-09') INTERVAL 1 DAY
            )
distributed by hash(col_bigint_undef_signed_not_null)
properties("enable_unique_key_merge_on_write" = "true", "replication_num" = "1");
""")
sql("""
insert into table_200_undef_partitions2_keys3_properties4_distributed_by54(pk,col_int_undef_signed,col_int_undef_signed_index_inverted,col_int_undef_signed_not_null,col_int_undef_signed_not_null_index_inverted,col_bigint_undef_signed,col_bigint_undef_signed_index_inverted,col_bigint_undef_signed_not_null,col_bigint_undef_signed_not_null_index_inverted,col_date_undef_signed,col_date_undef_signed_index_inverted,col_date_undef_signed_not_null,col_date_undef_signed_not_null_index_inverted,col_varchar_10__undef_signed,col_varchar_10__undef_signed_index_inverted,col_varchar_10__undef_signed_not_null,col_varchar_10__undef_signed_not_null_index_inverted,col_varchar_1024__undef_signed,col_varchar_1024__undef_signed_index_inverted,col_varchar_1024__undef_signed_not_null,col_varchar_1024__undef_signed_not_null_index_inverted) values (0,1,9,-4,-4,null,-8697274787897818231,-796357718616868580,-8141408524145224763,'2024-01-09',null,'2024-02-18','2025-06-18','f','g','v','c','p','y','s','d'),(1,2,2,-10,-4,1709160028824204971,-64676356682042600,-1001566060299090067,-4904098795355833004,'2025-06-18','2024-02-18','2024-02-18','2024-01-19','d','j','q','w','f','w','w','x'),(2,-4,-10,6,6,-4684893021592239361,4884798853103761594,-1339889435120703249,393627847919214021,'2023-12-11',null,'2027-01-16','2023-12-15','i','d','w','u','f',null,'v','k'),(3,-10,5,-4,9,139583436376926528,2146571135005478318,-5927550232925753551,-2999956517658518593,'2025-02-17','2023-12-18','2026-01-18','2026-01-18','x','m','f','q',null,'a','o','b'),(4,-10,5,2,2,null,-6300074564055199087,4599922909970390051,-2453777627329801206,'2023-12-11',null,'2024-02-18','2023-12-10','p',null,'e','f',null,'t','d','f'),(5,-10,-4,9,-10,1391118572020354869,3667247819758702848,-1819307559465929426,4322894936142974349,'2024-02-18','2024-02-18','2025-06-18','2024-01-08','x','b','o','y','h','m','x','z'),(6,7,-4,7,1,-1692379077718952352,null,-634134563423033341,925889883092063251,'2023-12-12','2027-01-09','2027-01-09','2024-01-19','h','n','n','i','i','f','p','x'),(7,5,4,6,6,-5690309925984742950,-1579184850210462209,-8079187978359448800,-7263083326816237036,'2024-01-19','2023-12-11','2024-02-18','2024-01-31','m','f','n','q','j',null,'f','m'),(8,5,-4,8,-10,null,-7318643184150964221,2010650999822879110,5285822840228267743,'2023-12-10',null,'2027-01-09','2023-12-16','j','y','w','l','z',null,'j','s'),(9,-4,5,-4,6,3193139099707923781,1225809541984254906,553121966899159725,7289185010559508957,'2023-12-19','2024-02-18','2023-12-12','2023-12-14',null,'n','g','a','y','i','u','w'),(10,2,null,-4,3,3026337999588438247,1872633545569417004,1671212101512788283,7997179242837714575,'2025-06-18','2023-12-09','2023-12-12','2024-01-19',null,'n','c','o','t',null,'n','n'),(11,2,-10,6,3,537089562127941958,2079907507160590165,6854721507286645896,-4928004714493954491,'2023-12-09','2024-01-31','2023-12-09','2023-12-16','t','z','x','c','z','k','r','x'),(12,-4,1,-10,-4,-3941688471783969211,null,135008067551174849,3856483961544139265,null,'2023-12-12','2026-01-18','2023-12-11','w','p','n','k',null,'o','h','v'),(13,5,-10,1,-4,4654423885784140295,-6380552514967647768,4434108515304309787,-5879733642665133970,'2027-01-16','2027-01-16','2024-01-17','2023-12-17','j',null,'x','d',null,'i','j','a'),(14,-10,null,2,4,null,1113054188234896027,793629095673619084,2578445193682424006,null,null,'2023-12-09','2023-12-14',null,null,'i','o','q','y','n','l'),(15,1,-10,-10,7,-8016347368566618882,7092080364840745704,2935473120307342511,2279545035626765562,'2025-02-18','2024-02-18','2026-02-18','2025-06-18','q','j','c','n','j',null,'j','s'),(16,5,5,-4,5,-6011667230631637302,8161772210809447650,-4252447584899568007,1946382165625301113,'2025-06-18','2024-01-08','2023-12-17','2023-12-12','o',null,'q','q','u','w','v','p'),(17,5,5,-10,0,7429503617861396406,5853515943871572220,1319316384563234856,5955606245570347448,'2027-01-09','2024-02-18','2027-01-16','2025-06-18',null,'k','t','d','v','e','z','t'),(18,-10,4,1,1,-8874325864989002160,-6471841376296923531,-80183380077602400,8826749293480194299,null,null,'2025-02-17','2023-12-12','e',null,'t','y','b','l','u','g'),(19,6,-4,9,3,null,null,7982992611574631497,-5496917123423394085,null,'2023-12-13','2025-06-18','2025-06-18','m',null,'u','o',null,'m','t','l'),(20,3,null,2,-10,null,-2097666949402047606,5061336834080750566,-1471408116411970474,'2023-12-19','2026-01-18','2024-01-31','2023-12-17','p','n','c','u','r',null,'a','i'),(21,5,null,5,2,-2880769934488423265,2096797260810639844,3967881948857996170,7815826113543751782,'2026-02-18','2027-01-16','2024-01-17','2024-01-31','l',null,'u','u','d','s','x','m'),(22,8,8,4,2,1323302985937277009,-8427666088513361216,-3175447807840467951,3776265302140153290,'2023-12-20','2024-02-18','2023-12-09','2027-01-09','j','f','q','x','c','c','y','l'),(23,5,8,-4,5,null,null,3529481336029806877,-2007969901568818110,'2023-12-11','2023-12-19','2025-06-18','2024-01-09','t','s','p','j','g','o','h','t'),(24,4,-10,-10,-4,-1449500546806982985,2435065836708272478,5853360695876138729,4827644976708625347,'2023-12-09','2024-02-18','2023-12-16','2023-12-09','k','w','m','t',null,null,'b','s'),(25,9,2,9,5,5013002798212192008,-4111875691507009611,-2419108953376836633,-5078313613962391054,'2023-12-19','2027-01-16','2024-01-09','2025-06-18','b',null,'h','a','s','t','t','y'),(26,null,null,6,4,null,-4892167888253832264,6882206082696075300,4121991334560529327,'2024-01-08','2023-12-19','2023-12-12','2023-12-15',null,'t','z','v','k','o','q','u'),(27,4,null,-10,2,5287665637081437188,-5034328379661267322,5158144623635271893,1578589994876868138,'2023-12-14','2024-02-18','2023-12-17','2025-02-17','v','x','n','g',null,'i','y','l'),(28,7,2,1,4,-2286583773338386082,6520098383853744791,5155337211479801316,-3890124490063528774,'2024-01-08',null,'2024-01-19','2027-01-16','e','m','s','d',null,null,'q','f'),(29,null,-4,3,0,1810753727500955377,108047595415913512,7520335771932017015,-8352282892797064033,'2024-02-18','2025-02-17','2024-01-17','2023-12-15','u','y','l','g','l','y','p','s'),(30,4,3,4,-10,-9207896956759971582,6943958222750970910,-7211984958190855919,2989853418440433545,'2023-12-20','2024-01-17','2023-12-16','2024-01-19','v','a','u','b',null,null,'y','n'),(31,null,null,6,1,null,7282690506420679583,-2355251288477340951,-6406770507411883342,'2024-01-31','2024-01-09','2024-01-08','2026-02-18',null,'a','a','n','s','t','l','p'),(32,-10,-10,7,8,-6757596429488057155,-250310769817872871,2780923042133206347,5710427955260033266,null,null,'2024-01-09','2023-12-11','w',null,'v','w','l','q','q','a'),(33,6,null,2,-10,171371570613094328,7195952884610097966,8088346717297816785,-3604996777410764137,'2023-12-19','2024-01-31','2024-01-08','2024-01-31','f','g','v','f','j',null,'h','a'),(34,0,null,7,0,-5168924615126031163,5845997836491882651,3945920758165615316,-5990628371246439185,'2024-01-08','2024-01-19','2024-01-17','2025-02-17',null,'u','z','n','w','z','m','p'),(35,-10,8,2,0,null,null,-1956055872027316389,-6448045993562976485,'2023-12-14','2024-01-08','2024-02-18','2025-02-18','b','a','k','k','s','s','g','q'),(36,-10,-10,2,-10,7357261747691655751,null,-7371405377132920194,-3744707716902481275,'2027-01-09','2023-12-16','2023-12-15','2025-02-17',null,'o','q','w','b','l','e','m'),(37,null,9,3,5,3619506957139679924,2310746028404448668,-3740518089285675199,-6074138059189068102,'2023-12-10','2024-01-19','2027-01-09','2023-12-15','y','e','a','k','z','x','r','y'),(38,9,-4,5,5,-8489524880362095514,1806392313298520567,-2811717319555621002,441183364501464261,'2026-01-18','2024-01-17','2024-01-08','2023-12-18','d','j','h','h',null,null,'h','h'),(39,3,9,4,4,null,-5464444246641363822,3208417530511451644,7006442393005068324,'2025-06-18',null,'2026-02-18','2027-01-16',null,'z','w','j','i',null,'t','u'),(40,0,null,5,4,8022118941972041551,null,-710620859473696559,6343167209059134367,null,'2025-06-18','2024-02-18','2024-01-31',null,'a','f','m','f','d','s','x'),(41,-4,null,9,1,-4321287500367490649,-7846456688505420493,2224840389198216638,-4301645519167111115,'2024-02-18','2024-01-19','2024-01-09','2023-12-11','f','j','v','d','w','z','r','l'),(42,null,null,-4,8,3972212873529697658,null,6637889337556418073,3285522629324841270,null,'2023-12-09','2025-06-18','2023-12-16','n','l','l','c',null,null,'f','a'),(43,null,-4,1,-10,4495066138822135721,3679213704195481715,8638645000532554475,9148026980644024525,null,'2024-01-09','2023-12-12','2026-02-18','j','i','g','h',null,'p','h','c'),(44,null,3,-4,8,-7843815068607013691,-2630115303366875790,4496008211674218350,-4263418121106417185,'2023-12-09','2025-06-18','2024-01-17','2025-06-18','q',null,'e','c','h','x','r','n'),(45,5,-4,7,5,null,-1540657981768743159,6680884740502230260,7530616783272618149,'2023-12-20','2027-01-16','2025-02-17','2025-02-17','d','b','s','p',null,'g','c','h'),(46,-10,4,-10,-10,null,4602249640922610902,-7063522742058484046,8480089299686660926,'2023-12-15','2027-01-16','2023-12-17','2026-01-18','c','b','e','w','p','q','z','f'),(47,-4,9,-4,-10,4983391552313706018,null,-2446645855338764223,-431484242427942873,'2023-12-17','2026-01-18','2023-12-15','2027-01-16','p','j','o','s','l','q','l','j'),(48,-10,9,6,9,null,-6515820073965795573,-4301296883053517096,649905938872930021,null,'2024-02-18','2023-12-19','2023-12-19','g',null,'f','o','t','d','k','l'),(49,5,-4,-10,-10,null,8898518418154893950,-6765451257834329113,-7763396933771458954,'2023-12-09','2024-02-18','2023-12-14','2024-01-08','v','f','p','s','t','j','a','b'),(50,8,7,-10,5,-125980119457421410,null,4261335623187350010,-7701455080188785845,'2023-12-15','2024-01-17','2024-01-08','2023-12-15','f','q','x','o','g','s','q','h'),(51,0,-4,5,4,8688916186225619538,-2889474832111499067,-4201605978327079465,-439674913056411210,'2023-12-11','2023-12-17','2024-01-08','2026-02-18',null,'t','u','l','v',null,'d','g'),(52,6,-4,-10,-10,null,-3544092439712469588,4121210359035393028,-4062014008459370221,'2024-01-31','2023-12-09','2025-06-18','2023-12-10',null,'s','o','r','l','f','w','z'),(53,-4,-10,4,-10,null,null,2871312993957356964,1977881891603564537,'2023-12-17','2023-12-12','2023-12-14','2023-12-20','r',null,'c','j','w','i','l','d'),(54,-10,1,1,-10,null,-2622523634293893049,7911251996737787004,-9194990734889924737,'2024-01-31','2025-02-18','2023-12-19','2024-02-18',null,'g','m','m','s','a','g','l'),(55,-4,-4,3,8,1170219371491627048,-4116859336721947821,7794531176725374176,4375533256034731191,'2024-01-09',null,'2025-02-18','2024-02-18','j','s','h','c','r','u','z','v'),(56,-10,null,5,1,null,4904261310213785891,2799924332180218467,8311127374879080725,null,'2025-02-17','2026-02-18','2024-02-18','w','p','h','s',null,'e','h','t'),(57,2,1,6,2,null,-7578359134483606973,-6355628648875068528,7314099016688582319,null,'2023-12-11','2025-06-18','2023-12-09','h','j','g','h','z','t','q','u'),(58,3,3,0,8,null,-4627764059923221573,6785374642108340007,4655823997990946981,'2027-01-09','2024-02-18','2025-06-18','2024-02-18','n','k','b','m',null,'x','a','t'),(59,null,1,0,2,5488271164840822029,-2184700982562157047,-4302201395906445107,-8728539567551493617,'2023-12-17','2023-12-12','2023-12-09','2023-12-13',null,'p','l','h','a','h','x','r'),(60,null,0,-10,-10,7122650763204478633,null,5880944806416521296,-2493606976793115457,'2026-02-18','2023-12-19','2024-01-08','2023-12-13','t','r','j','k',null,'n','n','l'),(61,0,-10,8,2,null,null,1684011491871657424,-6513235585416786004,'2023-12-10','2023-12-13','2024-02-18','2026-02-18','y','g','r','s','c','j','n','n'),(62,7,3,-4,-4,5079337758314616435,-7593799734903574154,7176649569354587813,-5811386440213894103,'2024-02-18','2023-12-16','2026-02-18','2023-12-19',null,'x','z','q',null,'q','m','j'),(63,8,1,-10,3,2841410807751481848,null,-7373923477102524990,5173188643597199195,'2025-06-18','2023-12-18','2023-12-12','2024-02-18','u','y','v','y','t','c','t','m'),(64,8,-10,2,6,3695806435933644692,6347161510684832553,-3021394936469229273,-3073382349434824372,'2024-01-17','2024-02-18','2025-06-18','2023-12-11','g','v','c','m',null,'y','m','f'),(65,8,null,-4,7,-504582940142105012,null,3590611403152378188,3481070892134942790,'2024-01-17','2024-01-19','2027-01-09','2027-01-09','s','r','p','p','o','z','l','z'),(66,-10,5,2,5,-2073607836653848533,null,5172915406195607905,175381023707451305,'2024-01-31','2023-12-18','2024-02-18','2023-12-18','z','l','j','k','u','n','j','r'),(67,null,4,9,6,-3655171383434823496,null,5451115322598310505,9188796663216251810,'2027-01-16','2023-12-16','2023-12-09','2025-02-17',null,null,'r','c','p','g','t','m'),(68,8,3,3,-10,7619841996105166102,1771024491533047314,8665192513199647416,-9128473913830613788,'2024-02-18','2023-12-16','2023-12-14','2024-01-17','f','s','b','l','o',null,'i','b'),(69,3,-10,2,4,-6283022116880737090,-3895510282815789154,-6633359437214313727,-3252650291529887993,'2023-12-16','2024-02-18','2024-01-17','2026-01-18',null,'e','y','l','v','f','i','c'),(70,0,5,4,1,-6725225086933608284,-274273747416671256,-5795662863982933311,-1414418994697411339,'2023-12-18','2027-01-09','2025-06-18','2023-12-13','p','z','d','g',null,'d','u','h'),(71,7,9,4,6,null,-7136429306082145740,-3264633294528380280,-652909136204010115,'2024-01-31','2025-06-18','2024-01-19','2026-02-18','r','b','f','t','e','l','y','e'),(72,0,5,7,5,-8080730416193086722,7753730763011237693,-3025646630779886009,1855256945019426921,'2024-01-09','2026-01-18','2024-01-09','2023-12-10','g','t','m','x','t','s','c','c'),(73,7,5,6,3,-3306534579169708005,6273870711732935268,2360104847802068806,3989444982925406573,'2026-02-18','2027-01-16','2024-02-18','2024-01-31','v',null,'q','l','p','f','z','c'),(74,6,7,6,-10,3218210067899697630,-8426416753544196985,6571510507689618652,5467663324243744538,'2024-02-18',null,'2026-01-18','2023-12-18',null,'y','u','f',null,'w','h','j'),(75,-10,1,8,-10,null,-6419453657164720984,5695905867012312799,-3098099730053938771,'2023-12-18','2023-12-20','2024-01-17','2023-12-17','q','h','j','o','h','c','c','q'),(76,3,-4,5,5,306818287320284882,-3540193726459840773,-2519004637996439522,8865887259251560059,'2023-12-10','2023-12-18','2024-02-18','2024-01-17','s','v','h','b',null,'c','y','f'),(77,-10,-10,9,2,null,9060141165971986532,-4309724527302845440,4928958835913966382,'2024-01-19',null,'2023-12-17','2026-02-18','x','c','h','d',null,null,'p','p'),(78,2,8,-10,1,null,7835693783579219684,3418720756540741600,-1175683211868207710,'2025-02-18','2024-01-09','2023-12-11','2024-01-09','h','f','l','v','i','j','e','c'),(79,5,8,7,-4,5273364047938530641,4515897566536602320,3921713214272512528,7950469762804784589,'2023-12-19','2026-01-18','2024-01-09','2024-02-18','o',null,'h','t',null,'h','y','e'),(80,-10,null,0,0,-4099198837305878672,-8377750602034565869,-892267569208878697,8028535523595752995,'2026-01-18','2024-02-18','2025-06-18','2024-01-19','h','e','w','g',null,'a','y','r'),(81,null,5,8,1,4640070825385164324,null,-6599629894715941036,-4624372316083925938,'2024-01-31','2023-12-12','2023-12-17','2026-01-18','x',null,'r','r','k','u','u','k'),(82,-4,-4,7,5,6201973740808045217,null,-4912526591794969361,6560537961291276115,'2024-01-08','2023-12-11','2024-02-18','2026-01-18','r','w','p','k','n',null,'l','i'),(83,-4,5,1,-10,8766085372416838108,373688166295194123,-4752488981414468679,7644065262643337720,null,'2024-01-19','2023-12-15','2026-02-18','t',null,'a','x','v','x','e','e'),(84,6,9,-4,4,7051803356004766732,3387129997121301596,5403501555202967282,8456165572206183023,'2025-06-18','2024-02-18','2023-12-11','2025-02-18',null,null,'j','r','n',null,'k','d'),(85,6,7,4,-4,-4141759152651827399,-5544927095548764614,-7758749362040248252,1747683113756814333,'2025-06-18','2023-12-17','2027-01-16','2025-02-17','w','r','x','j',null,null,'c','c'),(86,-4,8,6,-4,872745329963747420,-1513700381069208101,-8297890569058110750,6107862402079685081,'2023-12-17','2023-12-10','2023-12-16','2025-06-18','y','n','j','m',null,'f','s','b'),(87,-4,-10,2,-10,4609544147310849557,null,5322007891123953505,-8970341769308881256,'2024-01-17','2024-01-17','2023-12-13','2023-12-10','a','z','z','j','o','h','h','y'),(88,7,2,-4,-10,null,8895134208374124715,8121324420850295804,-6006394585070841126,'2023-12-13','2023-12-09','2026-02-18','2023-12-17','h','g','r','q','i','v','j','e'),(89,-4,null,8,1,-6993920400842979424,1010336923866525287,-6301039720208870550,-2609871309152057384,'2023-12-12','2024-01-17','2026-02-18','2027-01-16','l','a','g','l','j','h','o','v'),(90,3,3,4,6,null,null,-43379212666181399,-4880838331639092345,'2023-12-17','2023-12-12','2023-12-20','2023-12-16','y','j','a','z','j','i','j','d'),(91,null,0,4,5,null,109013831323162312,-4068560998715081903,364748483914457240,'2025-02-17','2024-02-18','2024-01-17','2025-02-17','s','b','z','t','j','m','y','k'),(92,6,null,8,-4,-8383781671143968793,null,6821880634853644149,-5191796761130710459,'2024-02-18','2027-01-16','2023-12-17','2024-01-17','s','p','g','e','l','h','d','v'),(93,1,null,-4,-10,null,-5529880006460801067,-2684687247016004289,-7731379772950490315,'2024-02-18','2024-02-18','2023-12-10','2025-06-18','f','u','j','o','n','b','z','c'),(94,6,null,-4,-10,null,null,8035375247158207480,4501347073905735983,'2024-01-08','2027-01-16','2023-12-10','2026-01-18','x','r','t','m','v',null,'d','t'),(95,3,4,4,7,3203133045758053504,-5603345703838798454,9043631625708819105,-6963733296377728012,'2023-12-18','2024-01-19','2026-01-18','2023-12-20','z','x','q','l','q','u','z','v'),(96,4,8,9,8,7208792592256025386,-6940590611564324395,4542460818055511950,3734880173640844341,'2024-02-18',null,'2024-02-18','2023-12-12','h','x','k','d','e','g','r','r'),(97,9,7,9,7,1590400567905882498,4518981356217834483,5532644705529616085,-7081046816482435823,'2024-02-18','2023-12-19','2023-12-14','2027-01-16','a','n','f','q','g','x','j','s'),(98,8,null,9,-4,-8003830274944156653,8696421798202486280,4910537221785420575,1236853965078809466,'2024-02-18','2024-01-08','2023-12-15','2024-02-18','w','c','z','l','h','h','o','r'),(99,null,1,0,4,8471088815777016328,8000334021704638075,-944825833767417040,823687772302027082,'2023-12-18',null,'2023-12-13','2025-06-18','b',null,'x','i','d',null,'q','c'),(100,-4,6,4,-4,-3454192180015808823,-1907793476532444099,-1532210230171258966,2452836851943211930,'2024-01-19','2025-06-18','2023-12-20','2024-01-31',null,null,'k','t','n','k','e','s'),(101,null,2,6,2,-2160710854050039421,-1980447445274987014,-1063072232174918283,8874911632393437608,'2024-02-18','2024-01-17','2024-01-17','2023-12-15','d','h','t','s','u','y','l','v'),(102,-10,null,-10,3,-3536848101698222242,-8331984456562114475,8869381375914596627,-270083927315840442,'2023-12-09','2026-01-18','2023-12-19','2024-02-18','j','g','n','i','e','w','o','v'),(103,-4,-10,0,9,null,4375792983996749880,-4734613620885893179,4114668794910568606,'2023-12-20',null,'2024-01-19','2025-02-17',null,null,'b','b',null,null,'w','s'),(104,0,-4,3,8,null,null,-3535404664110038159,1782246411965398405,'2023-12-09','2023-12-13','2023-12-14','2023-12-16','f','r','r','k',null,'b','c','q'),(105,null,1,-4,2,3942442362259708788,3215230245389782318,6239929243257131349,-1427519437938327534,'2024-02-18','2024-01-31','2024-01-17','2023-12-13','h','a','s','d','y',null,'p','s'),(106,7,7,6,2,-919129104945750550,-4766434809321477634,-964756128900610964,-685569039287414953,'2024-02-18','2025-06-18','2024-02-18','2027-01-09',null,'o','c','a','i','z','c','j'),(107,-4,2,-10,8,null,-4456077175833370586,-4691688817793990906,-2992619211179023007,'2025-06-18','2023-12-18','2023-12-13','2023-12-14',null,'g','b','i','l','o','k','d'),(108,-10,-10,2,-10,585924862904136917,2732182616141529847,-3449435823099142961,325439878815211052,'2027-01-16','2023-12-09','2024-01-31','2023-12-20','f','p','e','v','p','h','p','h'),(109,8,7,8,-10,3598234073750289505,2656953858586364899,-2386125156048330454,-3568546661731120174,'2023-12-15','2023-12-14','2024-01-31','2024-01-19','j','q','f','x','a',null,'a','n'),(110,2,9,-4,8,null,null,6718376238365892685,1252409106890341185,'2023-12-18','2023-12-09','2023-12-17','2024-01-19',null,'z','u','p','f','m','i','u'),(111,1,-10,4,-10,null,-7272799856423826736,-5452403805571530498,7408393579925186206,'2025-06-18','2023-12-12','2023-12-17','2027-01-16',null,'a','u','t',null,'u','y','y'),(112,0,null,-4,6,4192149795989482028,-5892831450538493036,-1599159718558075133,-3031138322397391975,'2023-12-17','2026-02-18','2027-01-09','2026-02-18',null,'w','b','e','f','q','m','p'),(113,1,null,-10,-4,2625176400776423753,-7203876652963908406,5605025482181777123,-282895336411764600,'2026-02-18','2023-12-12','2024-02-18','2024-01-17',null,null,'w','w',null,'w','s','z'),(114,4,6,-4,-10,null,null,5295150097868063766,1059609926571090572,'2024-02-18','2023-12-17','2023-12-16','2024-01-19','o','s','u','d','h','u','j','r'),(115,0,1,8,-4,-5370779141816176794,1471545005607735948,-27851202895743398,-6057072154513768301,'2023-12-13','2023-12-12','2023-12-16','2025-06-18','t','w','q','u','h','t','d','b'),(116,-10,-10,-10,7,-7477148270125065148,-2593977861543250538,743215202513833824,515366193949589992,'2023-12-11','2024-02-18','2027-01-09','2023-12-12',null,'r','q','j','b','o','u','d'),(117,7,5,2,9,null,null,-114232008259074373,-7232532306655200172,null,'2024-02-18','2023-12-17','2023-12-09','y','u','h','q','t','p','s','d'),(118,null,-4,2,-4,6021132381409091795,1650789297355477455,-366425957191999284,4004078023825040211,'2023-12-15','2023-12-10','2025-06-18','2023-12-15','f','l','z','a','m',null,'c','s'),(119,7,7,5,7,9125760446256632664,-6066685389831379306,4508291619586372659,-2734574295294351379,'2023-12-20',null,'2024-01-08','2023-12-12','f',null,'n','x','d','p','b','w'),(120,0,null,-10,0,-4703715834005271792,7669859252841009121,5698434351107029817,6445903603926583218,null,'2023-12-15','2024-01-08','2027-01-09','d','f','k','e','x','o','a','o'),(121,-10,5,2,3,-5586452113691551476,null,-5185684332161960725,181883894744192432,'2025-06-18','2023-12-10','2024-02-18','2023-12-16','n','b','d','c','t',null,'q','i'),(122,null,7,0,9,null,null,-61706063927187698,8256600190168743885,'2023-12-18','2027-01-09','2023-12-15','2025-06-18',null,'k','f','p','t','w','h','n'),(123,4,-10,-10,2,null,-3202661343721271793,-35441071479679562,6155946930596405574,'2027-01-09','2024-01-17','2023-12-18','2023-12-16','l','x','g','q','t','g','g','b'),(124,-10,7,5,7,-2755239235986642955,null,-7328099146643386202,4616912600316063130,null,'2023-12-14','2023-12-11','2023-12-14','s',null,'h','k','s','m','w','m'),(125,-10,6,9,2,null,-2222712934694129157,-7790148528313786595,7793059442369654207,'2025-02-17','2023-12-19','2023-12-13','2023-12-12','v','m','c','b','v','u','w','z'),(126,9,5,-4,3,null,5667353134528425169,-8342632862203423939,662230422806965346,'2024-01-09','2027-01-09','2023-12-10','2026-01-18','q','v','m','x','x','e','j','y'),(127,null,null,7,4,null,-8023905937607892949,-5429962479676840020,-1489406118179237279,'2025-02-18',null,'2025-06-18','2023-12-11','w','r','w','k',null,'f','s','s'),(128,-4,-10,1,8,null,-812316229229946019,-4737058923050357786,-1456375037249991481,'2024-02-18','2026-02-18','2023-12-20','2023-12-17','l','h','z','d','s','p','h','x'),(129,null,-10,9,6,4878402162895505410,7146210644162497106,5793437727669781554,8437674935043147265,'2023-12-15',null,'2024-02-18','2023-12-18','i','e','p','k','i',null,'n','c'),(130,3,-4,-4,-10,-6379660769022535372,null,-4161360926575644726,4841558145647494317,'2025-06-18','2023-12-15','2027-01-16','2024-02-18','x','l','q','x',null,'f','r','s'),(131,1,3,4,2,4906815975674472140,-2477078758026258047,-4446180737741697403,-3715547192967827533,'2025-02-18','2023-12-20','2025-06-18','2023-12-10','x','o','o','h',null,'h','n','l'),(132,-4,-4,-4,8,4550632293981566144,-7081621774642982436,3381907570087055589,1531433747084357566,'2025-02-17','2026-02-18','2024-02-18','2023-12-16',null,'k','t','i','z','u','n','u'),(133,7,7,7,9,9153758535993882726,-5125755772914239931,-3914064260622086071,-2587395593884587182,'2027-01-09','2027-01-09','2023-12-12','2023-12-10','w','o','q','v','b','u','k','s'),(134,8,7,-4,5,7271329037748137144,-7482072292090985664,997405433441489812,8101575243625432544,'2024-01-31','2025-06-18','2024-01-17','2023-12-19','v',null,'l','w','q','k','o','g'),(135,6,-4,5,1,908039630475235962,-1195324307844891694,-8614187664977097102,-4833580632713414272,'2023-12-10','2023-12-20','2024-01-09','2023-12-09','e','v','l','j','p',null,'c','v'),(136,5,3,-4,4,5350769859152465796,3771149188382465998,2184757536600200832,-1904661553860902041,'2024-01-31',null,'2023-12-15','2027-01-09',null,null,'w','x','j','t','n','i'),(137,0,-10,-10,5,-5803959120523604798,-4953227164684135922,-5617936272259823104,2950562553375112997,'2023-12-09',null,'2024-01-08','2027-01-09','h','z','e','u','r','g','o','n'),(138,6,-4,-10,7,7606139218985613055,-4702477985265107883,-5063187067081545532,6473278755064812342,'2027-01-09','2024-01-17','2024-01-08','2023-12-18',null,'c','g','u','j',null,'j','e'),(139,4,5,-10,6,-4235204543871874366,-5022843261413575986,1124723473829043783,3815730208167303007,null,'2023-12-20','2023-12-16','2023-12-18','h','q','o','a',null,null,'v','r'),(140,4,5,3,5,2034028907083867032,-2477407812176001929,-5417016779154891894,893166056087879862,'2023-12-14','2026-01-18','2023-12-12','2023-12-11','r','s','t','h',null,null,'d','f'),(141,-4,-4,-10,1,1994497888386377734,1336593008966052432,-1375728327598099110,6785114475033567332,'2025-06-18','2024-01-08','2024-02-18','2023-12-11','w','a','n','m','z',null,'o','m'),(142,null,2,1,6,-5335947919085251477,null,-2919661691996017083,8689983960223270899,'2024-02-18','2024-02-18','2024-01-09','2025-02-18',null,'d','n','y','f','p','k','q'),(143,3,6,0,5,-3188690043913500960,7618804340618525809,-1662204516548402425,-7746523657466311751,'2024-02-18','2026-01-18','2024-01-08','2023-12-14','c',null,'l','q','i','t','v','v'),(144,null,3,0,5,-2368175734816880968,8753899102977978528,-433228347699661385,-3762996104248734637,'2023-12-20','2024-02-18','2023-12-20','2026-01-18','b','a','k','d','l','v','g','g'),(145,null,6,-10,0,3976025621255328174,5177541234258706854,4619589052007726409,4701811319843987010,'2023-12-14','2023-12-15','2023-12-10','2023-12-13','o',null,'q','k','m',null,'x','y'),(146,-10,2,8,4,null,null,-989202885052616694,-5057885819339528309,null,'2023-12-18','2025-06-18','2023-12-09','g','z','v','t','l','y','i','o'),(147,8,6,6,4,-7185873528364361277,-904977438731002612,4175810235761796392,2128492182117974773,null,'2023-12-12','2023-12-16','2023-12-16',null,null,'b','s','o',null,'p','w'),(148,3,-10,6,-4,-5144263027197579512,5631082723362146920,1935296891028689212,172167714761668897,'2024-02-18',null,'2023-12-19','2024-01-09','r',null,'p','w','s','o','n','z'),(149,7,null,7,-10,-5944313833408870559,4353757786854034855,496142583684933810,1588623673296028387,'2026-01-18','2024-01-17','2027-01-09','2024-01-17','y','a','e','a','u','t','o','r'),(150,-10,8,2,8,-5101349828957483785,5934789347399172977,-1525749821909326195,-8831580294703185700,null,null,'2027-01-09','2023-12-16','o','p','i','u','h',null,'j','m'),(151,null,2,1,9,null,5265119932701738290,-1936237272106945475,-4001509910800955487,'2026-01-18','2026-02-18','2027-01-09','2024-01-09','z','a','u','y','t','c','n','a'),(152,7,7,-4,-4,-5823621118250351584,-3044536530259707863,-7200704407501034613,-4709679696214147996,'2023-12-14','2024-01-19','2025-06-18','2026-02-18','p',null,'q','l','i','r','f','c'),(153,-10,4,6,0,null,7290483754390930718,-561683162928153884,8066631543556309530,'2023-12-09','2024-01-31','2024-02-18','2025-02-18','w',null,'x','n','p',null,'o','h'),(154,-4,7,1,8,7348432176380659370,-8029822620384485695,-3838888499867218910,5463658523245904088,null,'2027-01-09','2023-12-11','2024-01-09','j','k','a','z','m','f','s','x'),(155,0,-10,0,-4,null,-2788941347828310052,-951788026586203904,2842106229880086269,'2026-02-18','2026-01-18','2025-06-18','2023-12-16','l',null,'a','g',null,null,'y','t'),(156,9,8,6,-4,-8917199967485283517,7201568891391421110,3469771619333072295,-8695982654747849480,'2025-02-17','2023-12-15','2024-01-19','2023-12-18','x',null,'o','r','u','s','h','e'),(157,-4,-4,6,7,498445782676630405,null,5326113013304016248,-2573343986102872560,'2023-12-14','2023-12-15','2023-12-12','2027-01-09','q','k','w','g',null,null,'b','g'),(158,-10,-4,4,8,2920428888781877845,null,9058990120303572946,8145430542315530456,'2023-12-17','2024-02-18','2026-01-18','2024-01-19','a','f','f','w','h','y','z','w'),(159,null,-4,-10,8,-6746663705286678624,-2626781636556747748,-3689665696290254279,-1813785317514940500,'2023-12-16','2023-12-14','2024-01-08','2023-12-11','c','x','q','y','v',null,'a','c'),(160,null,3,-10,-10,2108247833914565236,806037139517085629,-9167315317917899917,-4945473926383543939,'2024-01-17','2025-06-18','2023-12-14','2023-12-20',null,'r','a','p','t','t','d','y'),(161,6,8,8,1,-8513309117052582034,-6868826105671129118,8428065585426251358,3072412182101431432,'2023-12-19','2023-12-19','2023-12-09','2027-01-16','s','x','u','z','m','p','d','c'),(162,6,5,2,3,-9096205400345529326,null,-964575717335198615,9189939611039396540,'2024-02-18','2023-12-19','2024-01-17','2026-01-18','t','l','n','h','i',null,'l','y'),(163,9,5,9,3,5622076131480862564,-6080953193821594917,5861950379668800813,-1994310447566629509,null,'2027-01-16','2023-12-12','2024-02-18','o','s','m','w',null,'v','g','n'),(164,8,-10,4,8,null,5879238136714790767,6777234411262083568,-8321264913510475122,'2026-01-18','2023-12-10','2023-12-18','2023-12-12',null,'k','f','x','k','m','n','v'),(165,-4,-4,6,4,null,7553656738585079875,7163474429595054810,4580456543839798844,'2027-01-16',null,'2024-02-18','2023-12-11','h','c','a','i','c','s','i','u'),(166,-4,null,-4,-10,null,5196275324277885035,-8021568149553238587,6769576772149231060,'2023-12-13','2025-02-17','2027-01-09','2025-02-18','b','h','p','v','j',null,'h','q'),(167,-10,-10,6,8,8535659433729496476,2334246737823055643,5295312491675675649,-1801277987162776543,'2025-02-17','2023-12-11','2023-12-09','2023-12-17','i','d','v','v','c',null,'b','i'),(168,4,5,6,-4,-5235711739628728429,null,-346293688676251166,-3960291858742531298,null,'2024-02-18','2023-12-17','2024-02-18','f','g','g','v','j','l','j','c'),(169,0,null,5,2,-2658088275255245312,null,-1192714027924465213,-6573470841055445874,'2023-12-18','2023-12-10','2024-01-19','2023-12-12',null,null,'b','f','o','k','p','t'),(170,null,null,8,-10,1358851157459234391,1848057154264132224,7896531959617093922,-7326784827992241060,null,'2023-12-18','2024-01-17','2025-06-18','o','h','k','i','a','c','f','l'),(171,6,-4,-4,7,-4013841090609936502,-4343922292691073800,-2303188401908640095,9056323310432143144,'2026-01-18','2025-02-17','2024-01-08','2023-12-16','z','v','q','u','f',null,'c','e'),(172,8,8,2,7,7385072420387143147,-8544852435076242565,-268088962098020658,6563242604841380899,'2023-12-13','2023-12-16','2027-01-09','2024-02-18','q',null,'d','x','y',null,'r','n'),(173,9,-10,4,-4,null,1249034744108871597,6091926321979076329,317392718848312314,'2023-12-16','2023-12-16','2023-12-13','2023-12-09',null,'i','i','l','u',null,'h','v'),(174,1,-10,-10,-10,-4748229435166239520,-668723605906386407,4927959032789730626,-4515702617821832022,'2026-01-18',null,'2024-01-19','2024-02-18','e','m','g','k','e','a','u','r'),(175,5,null,-4,2,null,-7270048035789609414,-3537218393445735429,-4867097057347938811,null,'2024-01-31','2023-12-11','2023-12-18',null,'z','q','u','e','g','q','i'),(176,3,0,0,-4,924556814621205892,null,3052150455722163314,-3254582940790911104,'2023-12-13','2027-01-09','2024-01-17','2026-01-18',null,null,'q','k','s','n','h','u'),(177,9,9,-4,4,-5739137401665187839,null,-8337509117518258017,-5517345497076395609,'2023-12-11','2023-12-10','2025-06-18','2024-02-18','o','d','d','l','d','a','f','f'),(178,6,6,-4,8,151623624760950428,-6171008536397580558,6754236749424260895,6309536163799448192,'2023-12-15',null,'2026-01-18','2026-01-18','c',null,'u','l','c','l','y','v'),(179,-10,1,4,-10,8694046965385314707,null,5490824774919458293,1059597059164124320,'2025-06-18','2024-01-19','2027-01-16','2025-02-18',null,null,'n','p',null,'v','x','e'),(180,null,3,7,-4,3980960220937547163,-1918401174371988477,-2452860065880086947,-5193456734140747702,'2025-02-18','2023-12-16','2024-01-08','2024-02-18','k','w','e','u','f','c','y','k'),(181,1,-4,-10,-10,null,null,1880033523621280522,1139098776041973797,'2024-02-18','2024-01-17','2024-02-18','2027-01-09','z',null,'f','x','n','l','j','q'),(182,5,-4,4,6,987761989513859589,1880741998083376451,1622873545309435002,8130696718799537228,'2023-12-18','2023-12-16','2023-12-19','2025-06-18','p','n','m','y','p',null,'w','p'),(183,2,-10,6,4,-4346290809173638796,null,-8297767274636297718,7584195327352890820,'2023-12-20','2023-12-10','2024-01-09','2023-12-16',null,'d','j','n','q','f','n','w'),(184,-10,-4,0,-4,-5913968218377858311,-3404701992662263022,-4117038439035294552,7022870850008741728,'2024-01-31','2025-02-18','2023-12-16','2023-12-14',null,null,'m','c',null,'w','c','k'),(185,8,2,-10,4,4838839878071916871,8541636935471926665,-4216674599478489665,-1118409672725614027,'2023-12-17','2023-12-17','2023-12-12','2023-12-13','r','b','v','i','c','z','h','e'),(186,-10,6,-4,8,-6614934303133756506,-5852869328136401652,256835984242718710,1385420704708782284,'2023-12-16','2026-01-18','2027-01-16','2024-01-09','p',null,'x','m','s','b','m','l'),(187,5,-4,1,3,null,null,-5639433680819543087,8987850776915802404,'2023-12-17','2023-12-13','2023-12-10','2025-06-18','q','b','h','r','w','c','f','m'),(188,-10,5,6,6,null,-3523396147768306900,-6372016298271027884,-3180840704194938253,null,'2023-12-17','2023-12-17','2024-02-18','m','a','t','i','s','l','r','d'),(189,8,null,8,8,2604486258264363126,6269947020762143905,-1856080576977968085,-1565447732599037033,'2026-02-18','2024-01-09','2027-01-09','2023-12-18','g','h','c','e','c','d','h','e'),(190,-4,-4,-4,-10,7573837446377080449,null,-38007606614259146,5002820328236106028,'2026-01-18','2026-01-18','2023-12-17','2023-12-14','s','c','d','b','g','h','w','g'),(191,-4,9,4,6,6052243250287029783,6502941858946104088,8733307736661392737,-8563750004470080151,'2024-01-08','2027-01-09','2027-01-16','2024-01-17',null,null,'q','q',null,'s','e','z'),(192,4,null,7,8,-700290879692065746,-4455665306480134045,-5097673468552444845,9203694876815107846,'2026-02-18',null,'2024-01-31','2026-01-18','z','h','x','j','z','v','c','j'),(193,6,0,5,-10,-798465729275119947,5450717374422334048,7143644105054681581,-4364091274226452218,'2023-12-19','2023-12-12','2023-12-13','2023-12-16','k','d','x','l',null,'b','t','h'),(194,7,8,-4,5,2155891360170199788,-2275080212620872029,2212535754731168546,-7290785072477806051,'2024-01-19','2027-01-16','2024-02-18','2026-02-18','k','p','y','o','m','c','u','p'),(195,1,null,6,-10,-4769644553730902953,4068321374860561281,3063833056634627767,82157069434850571,'2027-01-09','2027-01-16','2023-12-19','2023-12-17',null,'t','g','l','o','t','s','q'),(196,4,9,4,1,null,-5212713217053195322,2284298040161611944,2865353848000028322,'2026-01-18','2024-01-31','2023-12-20','2025-02-17','x',null,'y','d',null,'m','s','z'),(197,1,2,-4,-10,3822443884700995825,-4586442807943845444,2842001669016159163,-3884508359415804230,'2024-01-17','2023-12-17','2023-12-10','2024-01-09',null,'a','k','c','i','z','m','d'),(198,2,7,4,0,-3776318643754509117,-3733385444923928906,98682922015380559,5381774108374544809,'2027-01-09','2025-02-18','2025-06-18','2026-02-18','k','y','v','n','j','d','z','i'),(199,-4,null,9,1,7181025901875872650,null,2351904174944438219,-7543102594536276769,'2024-01-31',null,'2024-01-19','2024-01-17','o','q','w','x','b','c','p','x');
    """)

    sql("""
    DROP TABLE IF EXISTS `table_50_undef_partitions2_keys3_properties4_distributed_by511`;
    """)
    sql("""
create table table_50_undef_partitions2_keys3_properties4_distributed_by511 (
col_date_undef_signed_not_null_index_inverted date  not null  ,
col_bigint_undef_signed_not_null_index_inverted bigint  not null  ,
col_bigint_undef_signed_not_null bigint  not null  ,
col_int_undef_signed int  null  ,
col_int_undef_signed_index_inverted int  null  ,
col_int_undef_signed_not_null int  not null  ,
col_int_undef_signed_not_null_index_inverted int  not null  ,
col_bigint_undef_signed bigint  null  ,
col_bigint_undef_signed_index_inverted bigint  null  ,
col_date_undef_signed date  null  ,
col_date_undef_signed_index_inverted date  null  ,
col_date_undef_signed_not_null date  not null  ,
col_varchar_10__undef_signed varchar(10)  null  ,
col_varchar_10__undef_signed_index_inverted varchar(10)  null  ,
col_varchar_10__undef_signed_not_null varchar(10)  not null  ,
col_varchar_10__undef_signed_not_null_index_inverted varchar(10)  not null  ,
col_varchar_1024__undef_signed varchar(1024)  null  ,
col_varchar_1024__undef_signed_index_inverted varchar(1024)  null  ,
col_varchar_1024__undef_signed_not_null varchar(1024)  not null  ,
col_varchar_1024__undef_signed_not_null_index_inverted varchar(1024)  not null  ,
pk int,
INDEX col_int_undef_signed_index_inverted_idx (`col_int_undef_signed_index_inverted`) USING INVERTED,
INDEX col_int_undef_signed_not_null_index_inverted_idx (`col_int_undef_signed_not_null_index_inverted`) USING INVERTED,
INDEX col_bigint_undef_signed_index_inverted_idx (`col_bigint_undef_signed_index_inverted`) USING INVERTED,
INDEX col_bigint_undef_signed_not_null_index_inverted_idx (`col_bigint_undef_signed_not_null_index_inverted`) USING INVERTED,
INDEX col_date_undef_signed_index_inverted_idx (`col_date_undef_signed_index_inverted`) USING INVERTED,
INDEX col_date_undef_signed_not_null_index_inverted_idx (`col_date_undef_signed_not_null_index_inverted`) USING INVERTED,
INDEX col_varchar_10__undef_signed_index_inverted_idx (`col_varchar_10__undef_signed_index_inverted`) USING INVERTED,
INDEX col_varchar_10__undef_signed_not_null_index_inverted_idx (`col_varchar_10__undef_signed_not_null_index_inverted`) USING INVERTED,
INDEX col_varchar_1024__undef_signed_index_inverted_idx (`col_varchar_1024__undef_signed_index_inverted`) USING INVERTED,
INDEX col_varchar_1024__undef_signed_not_null_index_inverted_idx (`col_varchar_1024__undef_signed_not_null_index_inverted`) USING INVERTED
) engine=olap
UNIQUE KEY(col_date_undef_signed_not_null_index_inverted, col_bigint_undef_signed_not_null_index_inverted, col_bigint_undef_signed_not_null)
PARTITION BY             RANGE(col_date_undef_signed_not_null_index_inverted) (
                FROM ('2023-12-08') TO ('2024-01-01') INTERVAL 1 DAY,
                FROM ('2024-01-01') TO ('2024-12-01') INTERVAL 1 MONTH,
                FROM ('2025-01-01') TO ('2027-01-01') INTERVAL 1 YEAR,
                FROM ('2027-01-01') TO ('2032-01-01') INTERVAL 2 YEAR
            )
distributed by hash(col_bigint_undef_signed_not_null_index_inverted)
properties("enable_unique_key_merge_on_write" = "true", "replication_num" = "1");
""")
sql("""
insert into table_50_undef_partitions2_keys3_properties4_distributed_by511(pk,col_int_undef_signed,col_int_undef_signed_index_inverted,col_int_undef_signed_not_null,col_int_undef_signed_not_null_index_inverted,col_bigint_undef_signed,col_bigint_undef_signed_index_inverted,col_bigint_undef_signed_not_null,col_bigint_undef_signed_not_null_index_inverted,col_date_undef_signed,col_date_undef_signed_index_inverted,col_date_undef_signed_not_null,col_date_undef_signed_not_null_index_inverted,col_varchar_10__undef_signed,col_varchar_10__undef_signed_index_inverted,col_varchar_10__undef_signed_not_null,col_varchar_10__undef_signed_not_null_index_inverted,col_varchar_1024__undef_signed,col_varchar_1024__undef_signed_index_inverted,col_varchar_1024__undef_signed_not_null,col_varchar_1024__undef_signed_not_null_index_inverted) values (0,6,-10,-4,4,2498617858168527098,5373549466364772229,-658557609743903814,-4826776721949128922,'2023-12-13','2024-01-09','2023-12-09','2023-12-18','n','m','l','a','s','t','j','c'),(1,0,4,-4,5,2304677083228736504,null,-2480666172274100536,3079835409251756325,'2024-01-31',null,'2024-01-08','2024-01-09','j','x','m','b','v',null,'c','n'),(2,9,5,9,4,null,-5396255301466547079,6968837610032052434,-5951268972109899953,'2023-12-09','2024-02-18','2025-02-17','2025-02-18','p','f','t','e','r',null,'x','f'),(3,6,0,6,-4,null,null,-2998328355145980833,-2775948131183576664,'2024-01-17','2025-02-17','2024-01-17','2024-02-18','j',null,'v','z','q','x','m','t'),(4,1,-4,4,6,2931588939353101483,278439088981260593,4090409152790185445,-4850946391114416725,'2027-01-16','2025-06-18','2025-02-17','2023-12-09','h','m','n','a','w','h','n','g'),(5,null,-10,8,-4,-2003008650357641114,5224263036429730084,-3374519117226105201,-341266537425367743,'2023-12-15','2023-12-17','2024-01-19','2025-06-18','m','j','f','l','i','l','r','u'),(6,8,6,-4,8,-3751334986022271590,null,-4288546621966174160,-2581136017306658343,'2023-12-14','2024-01-19','2025-06-18','2024-02-18','k','y','b','c','m','l','y','e'),(7,9,4,7,8,494029762266903877,8794643503716861845,1910646716042740316,3212841618106280089,'2026-02-18','2024-02-18','2024-01-17','2025-06-18',null,'h','w','y','u',null,'f','d'),(8,2,1,0,8,-1208806525617745350,-1878447537750785696,8461796413078643061,-1113632212241634372,'2025-06-18','2025-06-18','2025-02-17','2023-12-10','q',null,'i','c',null,'k','k','g'),(9,-4,0,3,-10,null,-4048057494993772300,-6829948994893894163,3880020520014988968,'2023-12-18','2023-12-11','2023-12-17','2024-01-31',null,'q','e','g','y','v','c','g'),(10,null,8,-4,6,8463422098568617745,5890535407762390362,-3937857663199592017,-729475616125191042,'2023-12-10','2024-01-17','2023-12-09','2023-12-17',null,'d','o','k',null,'k','o','w'),(11,1,null,-4,-4,879701396675291153,5102413703150338359,-1949447275993982476,-355674104351666305,'2025-06-18','2023-12-18','2023-12-11','2023-12-10','k',null,'c','a','h','m','y','b'),(12,5,5,-4,7,-4488487884314473451,-519900744268054324,-8627599288523107981,-6276963716840157044,'2025-02-18','2023-12-15','2027-01-09','2023-12-20','s','s','i','i',null,null,'a','n'),(13,8,1,4,6,-87146272277226708,6994136873435994520,-4788566442722973929,-3300176986929936016,'2023-12-14','2027-01-09','2026-02-18','2025-02-18','a','g','a','c','q','q','r','u'),(14,1,-10,-4,3,null,6868482422453748242,5444915068477497393,1680339264288558555,'2027-01-09','2024-02-18','2023-12-14','2024-01-31','g','z','a','v','s','p','r','g'),(15,4,-4,-4,6,-7850950726122142269,null,-5218074734034329284,3894832525147370290,'2024-02-18','2023-12-20','2023-12-09','2023-12-16','d','h','w','q','u','m','y','i'),(16,5,0,3,4,1370942829436360231,null,4021044394821798623,-7907159018696393540,'2023-12-15','2023-12-19','2025-02-18','2023-12-11','m','r','a','y','v','h','b','w'),(17,-4,0,-10,9,-35597416310332868,-7182597080456018891,7172904079809975820,-3009219096141135844,'2027-01-09','2027-01-09','2024-01-31','2024-01-31','v','i','i','y',null,'e','w','y'),(18,7,-10,-10,3,-6386283891383849458,-3009606348184914915,7261576864805040968,170951717007753555,'2025-06-18','2023-12-18','2023-12-10','2023-12-15','g',null,'y','r','s','p','c','u'),(19,-4,5,9,3,2761747837236765212,null,-3118303026863026131,-78026070669503039,'2026-01-18','2026-01-18','2023-12-15','2024-01-31','v','w','a','h','q','v','l','c'),(20,8,7,3,0,null,-6377005234709039125,5797034247807241057,-8966335190144814695,'2023-12-17','2023-12-17','2024-01-31','2023-12-17',null,null,'i','h','u','f','k','c'),(21,3,5,-10,8,4893267170054703940,-1551380881898038724,-1110571543374124477,-3427397137685629330,'2023-12-17',null,'2024-01-31','2024-02-18','y',null,'d','j','w','g','f','d'),(22,null,-10,6,8,6309528284761078365,null,-8918327598296909988,547870344626301827,'2026-01-18','2025-06-18','2024-01-17','2025-02-17','g',null,'a','x','o','t','c','x'),(23,6,1,9,-4,4918036581494743333,-7913725501914363451,8869844905529516711,6954418639282763317,'2026-01-18','2023-12-10','2025-06-18','2023-12-20',null,'q','b','q','h',null,'v','u'),(24,-4,6,7,-10,1588039461593893479,null,6749314548203254385,8309572545869347751,'2024-02-18','2023-12-13','2023-12-11','2025-06-18','v','r','b','q','d',null,'f','n'),(25,-4,null,9,6,null,3894778168530063841,-3596038027116032194,2194898833548456146,'2026-01-18',null,'2023-12-09','2023-12-20','c','n','v','c','k','o','l','a'),(26,5,4,-4,2,null,-266579373851536908,-1940091095898012350,-6113639534838204273,'2023-12-15','2027-01-09','2023-12-19','2025-02-17',null,'e','g','s','m','k','o','u'),(27,null,null,-10,8,987514619404866955,7653958002731402455,1318519539759591421,-3131260976474931989,'2024-01-09','2023-12-13','2024-01-09','2023-12-15','r','i','k','n','i','r','t','f'),(28,-4,null,7,-10,6264384158025918687,616771859413804848,4043645687892490882,-5991155324996911379,'2023-12-09',null,'2023-12-11','2023-12-16','n','f','p','d','s','a','j','l'),(29,6,-4,0,-4,-836773520883433131,-6939116974595448438,-1421706443370937936,-4164311787058643822,'2027-01-16','2024-01-31','2024-02-18','2027-01-09','x','f','d','d','h','c','l','e'),(30,4,6,0,4,-3796433322493772240,-4037432256237530578,5001752494653223957,-322599404215629441,'2025-02-17','2023-12-19','2024-01-08','2024-01-17','n','u','i','j',null,'m','i','a'),(31,-4,1,4,7,4182037664265556349,null,-3079442860609827333,-7990072421752377707,'2025-02-18','2024-02-18','2027-01-16','2024-02-18','t',null,'r','y',null,'u','t','m'),(32,4,1,7,-10,-7138593610168075189,-2019604039373790461,-3281912590479044669,4179637264260793933,'2023-12-12','2025-02-17','2024-02-18','2024-02-18',null,'p','q','a','o',null,'g','n'),(33,null,-10,8,-10,null,null,-5917221849270701931,-1014375348436916978,'2025-06-18','2026-01-18','2025-02-17','2024-02-18','k','z','y','e','q','p','t','f'),(34,-4,-4,-4,7,6118046245435782122,null,585480680448417527,2232034415418306486,null,'2023-12-11','2024-01-17','2027-01-16','h','e','r','n',null,'a','p','a'),(35,2,-10,-10,7,1989217150518766380,-2140551533828704683,4157292035989110174,-9212429539606564375,'2027-01-16','2023-12-13','2025-06-18','2023-12-15','s','e','g','a',null,'i','r','r'),(36,7,4,-4,-4,6199790078162426203,-1097004610059782245,-2540489675991395877,-2325312609752889209,'2023-12-18','2025-06-18','2025-06-18','2023-12-16','a','f','f','s','r','j','f','i'),(37,5,null,7,5,null,1807093610388564460,1333806568245060482,968539176267663253,'2024-01-08','2025-06-18','2023-12-20','2023-12-20','n',null,'h','w',null,'l','o','k'),(38,6,-10,-4,6,6337076999845007881,6566143624347899733,903043302161449536,-5479072921075365100,'2026-02-18','2026-02-18','2024-01-09','2027-01-09','g','u','o','q','z','z','c','s'),(39,3,5,-10,1,5436239486152387052,4826406716463001842,701006214602736409,7014859679652629431,'2026-01-18','2025-06-18','2025-02-17','2024-01-09',null,null,'g','u',null,'t','o','t'),(40,0,-4,4,9,-8506081518622669862,6120815731833147193,-5271110143040750545,8791590967061838304,'2023-12-18','2026-01-18','2024-01-17','2025-06-18',null,'o','g','z','u','b','s','u'),(41,5,-10,-4,-10,-8680751578983156842,6405593925859199879,6475864387853961555,359435681113837386,'2026-01-18','2023-12-16','2023-12-11','2024-02-18','v','d','i','w','g','s','v','v'),(42,2,-10,0,8,7245829418223754233,-3484990730927572146,-4197069007789863700,6160017091309710774,'2025-06-18','2023-12-17','2023-12-09','2024-01-31','y','h','l','v','g','e','m','y'),(43,7,-4,7,7,null,-1765449970646222759,-7550945937585902532,3638308197955607809,'2023-12-18','2025-06-18','2024-01-31','2023-12-13',null,'i','v','h','e',null,'s','r'),(44,-10,7,-10,-4,null,null,7087558227481767790,-1277525460716623164,'2026-01-18','2024-01-19','2023-12-11','2023-12-20',null,'x','h','r','h','y','x','p'),(45,-4,9,-4,4,-2680569912516288829,616452172933583618,-4522758857164084948,-7113163997063712981,'2023-12-16',null,'2025-02-17','2025-06-18',null,'h','h','u','x','b','n','r'),(46,null,9,5,6,-7623963562043742093,-8992192264949596911,6415168985874011725,6517816064420230930,'2023-12-18','2024-01-09','2024-02-18','2025-02-18','j','t','p','y','s',null,'p','b'),(47,3,-4,9,1,-2433206652527659380,-9190398832161436526,6450258973669857996,-1881412422123297857,'2024-01-17','2026-02-18','2026-02-18','2025-02-18','c',null,'g','w',null,'n','i','c'),(48,3,-4,0,2,null,-7527886142691482945,-3348740722806945164,7196825032292266043,'2023-12-19','2024-01-08','2024-01-08','2024-01-17',null,'n','n','c','c','u','o','g'),(49,-10,1,-4,-4,8175739067098937172,-4640205084076007657,2803457098818571055,3875267346180258004,null,'2025-02-17','2026-02-18','2023-12-16','p',null,'v','x','r','g','c','p');
    """)

    qt_test("""
    SELECT DAY ( DATE_ADD ( table1 . col_date_undef_signed , INTERVAL 3 DAY ) ) AS field1, COUNT( distinct table1 . col_varchar_10__undef_signed ) AS field2 FROM table_200_undef_partitions2_keys3_properties4_distributed_by59 AS table1 RIGHT JOIN table_200_undef_partitions2_keys3_properties4_distributed_by54 AS table2 ON ( table2 . col_date_undef_signed_not_null_index_inverted = table1 . col_date_undef_signed_index_inverted ) INNER JOIN table_50_undef_partitions2_keys3_properties4_distributed_by511 AS table3 ON ( table3 . col_date_undef_signed_not_null_index_inverted = table2 . col_date_undef_signed_index_inverted ) WHERE  (  ( table1 . `col_int_undef_signed_not_null`  <  9 ) AND table2 . col_int_undef_signed_not_null_index_inverted  <=>  table3 . col_int_undef_signed_index_inverted )  GROUP BY field1  ORDER BY field1 LIMIT 1000;
    """)
}