/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.metastore.iceberg.transform;

import java.lang.invoke.MethodHandle;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.iceberg.data.Record;

public abstract class OutputDataTransformer<T> {
    private final Map<String, MethodHandle> unitSetters;
    private final List<String> columns = new ArrayList<String>();
    private final List<Record> records = new ArrayList<Record>();

    protected OutputDataTransformer(Map<String, MethodHandle> unitSetters) {
        this.unitSetters = unitSetters;
    }

    public OutputDataTransformer<T> columns(List<String> columns) {
        this.columns.addAll(columns);
        return this;
    }

    public OutputDataTransformer<T> columns(String ... columns) {
        return this.columns(Arrays.asList(columns));
    }

    public OutputDataTransformer<T> records(List<Record> records) {
        this.records.addAll(records);
        return this;
    }

    public abstract List<T> execute();

    protected List<Map<MethodHandle, Object>> valuesToSet() {
        return this.records.stream().map(record -> this.columns.stream().filter(column -> this.unitSetters.get(column) != null).filter(column -> record.getField(column) != null).collect(Collectors.toMap(this.unitSetters::get, arg_0 -> ((Record)record).getField(arg_0), (o, n) -> n))).collect(Collectors.toList());
    }
}

