/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.yarn.appMaster;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.drill.yarn.appMaster.AMException;
import org.apache.drill.yarn.appMaster.AMRegistrar;
import org.apache.drill.yarn.appMaster.AMYarnFacade;
import org.apache.drill.yarn.appMaster.ClusterController;
import org.apache.drill.yarn.appMaster.ClusterControllerImpl;
import org.apache.drill.yarn.appMaster.DispatcherAddOn;
import org.apache.drill.yarn.appMaster.Pollable;
import org.apache.drill.yarn.appMaster.PulseRunnable;
import org.apache.drill.yarn.appMaster.YarnFacadeException;
import org.apache.drill.yarn.core.DrillOnYarnConfig;
import org.apache.hadoop.yarn.api.records.Container;
import org.apache.hadoop.yarn.api.records.ContainerId;
import org.apache.hadoop.yarn.api.records.ContainerStatus;
import org.apache.hadoop.yarn.api.records.NodeReport;
import org.apache.hadoop.yarn.client.api.async.AMRMClientAsync;
import org.apache.hadoop.yarn.client.api.async.NMClientAsync;

public class Dispatcher {
    private static final Log LOG = LogFactory.getLog(Dispatcher.class);
    private AMYarnFacade yarn;
    private ClusterController controller;
    private List<Pollable> pollables = new ArrayList<Pollable>();
    private List<DispatcherAddOn> addOns = new ArrayList<DispatcherAddOn>();
    private String trackingUrl;
    private AMRegistrar amRegistrar;
    private int httpPort;
    private PulseRunnable timer;
    private Thread pulseThread;
    private final int timerPeriodMs;

    public Dispatcher(int timerPeriodMs) {
        this.timerPeriodMs = timerPeriodMs;
    }

    public void setYarn(AMYarnFacade yarn) throws YarnFacadeException {
        this.yarn = yarn;
        this.controller = new ClusterControllerImpl(yarn);
    }

    public ClusterController getController() {
        return this.controller;
    }

    public void registerPollable(Pollable pollable) {
        this.pollables.add(pollable);
    }

    public void registerAddOn(DispatcherAddOn addOn) {
        this.addOns.add(addOn);
    }

    public void setHttpPort(int port) {
        this.httpPort = port;
    }

    public void setTrackingUrl(String trackingUrl) {
        this.trackingUrl = trackingUrl;
    }

    public String getTrackingUrl() {
        return this.yarn.getTrackingUrl();
    }

    public void setAMRegistrar(AMRegistrar registrar) {
        this.amRegistrar = registrar;
    }

    public boolean start() throws YarnFacadeException {
        try {
            this.setup();
        }
        catch (AMException e) {
            String msg = e.getMessage();
            LOG.error((Object)("Fatal error: " + msg));
            this.yarn.finish(false, msg);
            return false;
        }
        try {
            this.register();
        }
        catch (AMRegistrar.AMRegistrationException e) {
            LOG.error((Object)e.getMessage(), (Throwable)e);
            this.yarn.finish(true, e.getMessage());
            return false;
        }
        return true;
    }

    public void run() throws YarnFacadeException {
        this.startTimer();
        LOG.trace((Object)"Running");
        boolean success = this.controller.waitForCompletion();
        LOG.trace((Object)"Finishing");
        this.finish(success, null);
    }

    private void setup() throws YarnFacadeException, AMException {
        LOG.trace((Object)"Starting YARN agent");
        this.yarn.start(new ResourceCallback(), new NodeCallback());
        String url = this.trackingUrl.replace("<port>", Integer.toString(this.httpPort));
        if (DrillOnYarnConfig.config().getBoolean(DrillOnYarnConfig.HTTP_ENABLE_SSL)) {
            url = url.replace("http:", "https:");
        }
        LOG.trace((Object)("Registering YARN application, URL: " + url));
        this.yarn.register(url);
        this.controller.started();
        for (DispatcherAddOn addOn : this.addOns) {
            addOn.start(this.controller);
        }
    }

    private void register() throws AMRegistrar.AMRegistrationException {
        if (this.amRegistrar == null) {
            LOG.warn((Object)"No AM Registrar provided: cannot check if this is the only AM for the Drill cluster.");
        } else {
            AMYarnFacade.YarnAppHostReport rpt = this.yarn.getAppHostReport();
            this.amRegistrar.register(rpt.amHost, this.httpPort, rpt.appId);
        }
    }

    private void startTimer() {
        this.timer = new PulseRunnable(this.timerPeriodMs, new TimerCallback());
        this.pulseThread = new Thread(this.timer);
        this.pulseThread.setName("Pulse");
        this.pulseThread.start();
    }

    private void finish(boolean success, String msg) throws YarnFacadeException {
        for (DispatcherAddOn addOn : this.addOns) {
            addOn.finish(this.controller);
        }
        LOG.trace((Object)"Shutting down YARN agent");
        this.stopTimer();
        this.yarn.finish(success, msg);
    }

    private void stopTimer() {
        this.timer.stop();
        try {
            this.pulseThread.join();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    private class ResourceCallback
    implements AMRMClientAsync.CallbackHandler {
        private ResourceCallback() {
        }

        public void onContainersAllocated(List<Container> containers) {
            LOG.trace((Object)("NM: Containers allocated: " + containers.size()));
            Dispatcher.this.controller.containersAllocated(containers);
        }

        public void onContainersCompleted(List<ContainerStatus> statuses) {
            LOG.trace((Object)("NM: Containers completed: " + statuses.size()));
            Dispatcher.this.controller.containersCompleted(statuses);
        }

        public void onShutdownRequest() {
            LOG.trace((Object)"RM: Shutdown request");
            Dispatcher.this.controller.shutDown();
        }

        public void onNodesUpdated(List<NodeReport> updatedNodes) {
            LOG.trace((Object)("RM: Nodes updated, count= " + updatedNodes.size()));
        }

        public float getProgress() {
            Dispatcher.this.controller.updateRMStatus();
            return Dispatcher.this.controller.getProgress();
        }

        public void onError(Throwable e) {
            LOG.error((Object)("Fatal RM Error: " + e.getMessage()));
            LOG.error((Object)"AM Shutting down!");
            Dispatcher.this.controller.shutDown();
        }
    }

    public class NodeCallback
    implements NMClientAsync.CallbackHandler {
        public void onStartContainerError(ContainerId containerId, Throwable t) {
            LOG.trace((Object)("CNM: ontainer start error: " + String.valueOf(containerId)), t);
            Dispatcher.this.controller.taskStartFailed(containerId, t);
        }

        public void onContainerStarted(ContainerId containerId, Map<String, ByteBuffer> allServiceResponse) {
            LOG.trace((Object)("NM: Container started: " + String.valueOf(containerId)));
            Dispatcher.this.controller.containerStarted(containerId);
        }

        public void onContainerStatusReceived(ContainerId containerId, ContainerStatus containerStatus) {
            LOG.trace((Object)("NM: Container status: " + String.valueOf(containerId) + " - " + containerStatus.toString()));
        }

        public void onGetContainerStatusError(ContainerId containerId, Throwable t) {
            LOG.trace((Object)("NM: Container error: " + String.valueOf(containerId)), t);
        }

        public void onStopContainerError(ContainerId containerId, Throwable t) {
            LOG.trace((Object)("NM: Stop container error: " + String.valueOf(containerId)), t);
            Dispatcher.this.controller.stopTaskFailed(containerId, t);
        }

        public void onContainerStopped(ContainerId containerId) {
            LOG.trace((Object)("NM: Container stopped: " + String.valueOf(containerId)));
            Dispatcher.this.controller.containerStopped(containerId);
        }
    }

    public class TimerCallback
    implements PulseRunnable.PulseCallback {
        @Override
        public void onTick(long curTime) {
            for (Pollable pollable : Dispatcher.this.pollables) {
                pollable.tick(curTime);
            }
            Dispatcher.this.controller.tick(curTime);
        }
    }
}

